// Code generated by go-swagger; DO NOT EDIT.

package intel

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQueryMitreAttacksParams creates a new QueryMitreAttacksParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQueryMitreAttacksParams() *QueryMitreAttacksParams {
	return &QueryMitreAttacksParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQueryMitreAttacksParamsWithTimeout creates a new QueryMitreAttacksParams object
// with the ability to set a timeout on a request.
func NewQueryMitreAttacksParamsWithTimeout(timeout time.Duration) *QueryMitreAttacksParams {
	return &QueryMitreAttacksParams{
		timeout: timeout,
	}
}

// NewQueryMitreAttacksParamsWithContext creates a new QueryMitreAttacksParams object
// with the ability to set a context for a request.
func NewQueryMitreAttacksParamsWithContext(ctx context.Context) *QueryMitreAttacksParams {
	return &QueryMitreAttacksParams{
		Context: ctx,
	}
}

// NewQueryMitreAttacksParamsWithHTTPClient creates a new QueryMitreAttacksParams object
// with the ability to set a custom HTTPClient for a request.
func NewQueryMitreAttacksParamsWithHTTPClient(client *http.Client) *QueryMitreAttacksParams {
	return &QueryMitreAttacksParams{
		HTTPClient: client,
	}
}

/*
QueryMitreAttacksParams contains all the parameters to send to the API endpoint

	for the query mitre attacks operation.

	Typically these are written to a http.Request.
*/
type QueryMitreAttacksParams struct {

	/* ID.

	   The actor ID(derived from the actor's name) for which to retrieve a list of attacks, for example: fancy-bear. Only one value is allowed
	*/
	ID *string

	/* Ids.

	   The actor ID(derived from the actor's name) for which to retrieve a list of attacks, for example: fancy-bear. Multiple values are allowed
	*/
	Ids []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the query mitre attacks params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryMitreAttacksParams) WithDefaults() *QueryMitreAttacksParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the query mitre attacks params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryMitreAttacksParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the query mitre attacks params
func (o *QueryMitreAttacksParams) WithTimeout(timeout time.Duration) *QueryMitreAttacksParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the query mitre attacks params
func (o *QueryMitreAttacksParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the query mitre attacks params
func (o *QueryMitreAttacksParams) WithContext(ctx context.Context) *QueryMitreAttacksParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the query mitre attacks params
func (o *QueryMitreAttacksParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the query mitre attacks params
func (o *QueryMitreAttacksParams) WithHTTPClient(client *http.Client) *QueryMitreAttacksParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the query mitre attacks params
func (o *QueryMitreAttacksParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithID adds the id to the query mitre attacks params
func (o *QueryMitreAttacksParams) WithID(id *string) *QueryMitreAttacksParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the query mitre attacks params
func (o *QueryMitreAttacksParams) SetID(id *string) {
	o.ID = id
}

// WithIds adds the ids to the query mitre attacks params
func (o *QueryMitreAttacksParams) WithIds(ids []string) *QueryMitreAttacksParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the query mitre attacks params
func (o *QueryMitreAttacksParams) SetIds(ids []string) {
	o.Ids = ids
}

// WriteToRequest writes these params to a swagger request
func (o *QueryMitreAttacksParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ID != nil {

		// query param id
		var qrID string

		if o.ID != nil {
			qrID = *o.ID
		}
		qID := qrID
		if qID != "" {

			if err := r.SetQueryParam("id", qID); err != nil {
				return err
			}
		}
	}

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamQueryMitreAttacks binds the parameter ids
func (o *QueryMitreAttacksParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}
