// Code generated by go-swagger; DO NOT EDIT.

package intel

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQueryVulnerabilitiesParams creates a new QueryVulnerabilitiesParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQueryVulnerabilitiesParams() *QueryVulnerabilitiesParams {
	return &QueryVulnerabilitiesParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQueryVulnerabilitiesParamsWithTimeout creates a new QueryVulnerabilitiesParams object
// with the ability to set a timeout on a request.
func NewQueryVulnerabilitiesParamsWithTimeout(timeout time.Duration) *QueryVulnerabilitiesParams {
	return &QueryVulnerabilitiesParams{
		timeout: timeout,
	}
}

// NewQueryVulnerabilitiesParamsWithContext creates a new QueryVulnerabilitiesParams object
// with the ability to set a context for a request.
func NewQueryVulnerabilitiesParamsWithContext(ctx context.Context) *QueryVulnerabilitiesParams {
	return &QueryVulnerabilitiesParams{
		Context: ctx,
	}
}

// NewQueryVulnerabilitiesParamsWithHTTPClient creates a new QueryVulnerabilitiesParams object
// with the ability to set a custom HTTPClient for a request.
func NewQueryVulnerabilitiesParamsWithHTTPClient(client *http.Client) *QueryVulnerabilitiesParams {
	return &QueryVulnerabilitiesParams{
		HTTPClient: client,
	}
}

/*
QueryVulnerabilitiesParams contains all the parameters to send to the API endpoint

	for the query vulnerabilities operation.

	Typically these are written to a http.Request.
*/
type QueryVulnerabilitiesParams struct {

	/* Filter.

	   FQL query specifying the filter parameters.
	*/
	Filter *string

	/* Limit.

	   Number of IDs to return.
	*/
	Limit *int64

	/* Offset.

	   Starting index of result set from which to return IDs.
	*/
	Offset *string

	/* Q.

	   Match phrase_prefix query criteria; included fields: _all (all filter string fields indexed).
	*/
	Q *string

	/* Sort.

	   Order by fields.
	*/
	Sort *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the query vulnerabilities params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryVulnerabilitiesParams) WithDefaults() *QueryVulnerabilitiesParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the query vulnerabilities params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryVulnerabilitiesParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the query vulnerabilities params
func (o *QueryVulnerabilitiesParams) WithTimeout(timeout time.Duration) *QueryVulnerabilitiesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the query vulnerabilities params
func (o *QueryVulnerabilitiesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the query vulnerabilities params
func (o *QueryVulnerabilitiesParams) WithContext(ctx context.Context) *QueryVulnerabilitiesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the query vulnerabilities params
func (o *QueryVulnerabilitiesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the query vulnerabilities params
func (o *QueryVulnerabilitiesParams) WithHTTPClient(client *http.Client) *QueryVulnerabilitiesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the query vulnerabilities params
func (o *QueryVulnerabilitiesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFilter adds the filter to the query vulnerabilities params
func (o *QueryVulnerabilitiesParams) WithFilter(filter *string) *QueryVulnerabilitiesParams {
	o.SetFilter(filter)
	return o
}

// SetFilter adds the filter to the query vulnerabilities params
func (o *QueryVulnerabilitiesParams) SetFilter(filter *string) {
	o.Filter = filter
}

// WithLimit adds the limit to the query vulnerabilities params
func (o *QueryVulnerabilitiesParams) WithLimit(limit *int64) *QueryVulnerabilitiesParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the query vulnerabilities params
func (o *QueryVulnerabilitiesParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithOffset adds the offset to the query vulnerabilities params
func (o *QueryVulnerabilitiesParams) WithOffset(offset *string) *QueryVulnerabilitiesParams {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the query vulnerabilities params
func (o *QueryVulnerabilitiesParams) SetOffset(offset *string) {
	o.Offset = offset
}

// WithQ adds the q to the query vulnerabilities params
func (o *QueryVulnerabilitiesParams) WithQ(q *string) *QueryVulnerabilitiesParams {
	o.SetQ(q)
	return o
}

// SetQ adds the q to the query vulnerabilities params
func (o *QueryVulnerabilitiesParams) SetQ(q *string) {
	o.Q = q
}

// WithSort adds the sort to the query vulnerabilities params
func (o *QueryVulnerabilitiesParams) WithSort(sort *string) *QueryVulnerabilitiesParams {
	o.SetSort(sort)
	return o
}

// SetSort adds the sort to the query vulnerabilities params
func (o *QueryVulnerabilitiesParams) SetSort(sort *string) {
	o.Sort = sort
}

// WriteToRequest writes these params to a swagger request
func (o *QueryVulnerabilitiesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Filter != nil {

		// query param filter
		var qrFilter string

		if o.Filter != nil {
			qrFilter = *o.Filter
		}
		qFilter := qrFilter
		if qFilter != "" {

			if err := r.SetQueryParam("filter", qFilter); err != nil {
				return err
			}
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset string

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := qrOffset
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if o.Q != nil {

		// query param q
		var qrQ string

		if o.Q != nil {
			qrQ = *o.Q
		}
		qQ := qrQ
		if qQ != "" {

			if err := r.SetQueryParam("q", qQ); err != nil {
				return err
			}
		}
	}

	if o.Sort != nil {

		// query param sort
		var qrSort string

		if o.Sort != nil {
			qrSort = *o.Sort
		}
		qSort := qrSort
		if qSort != "" {

			if err := r.SetQueryParam("sort", qSort); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
