// Code generated by go-swagger; DO NOT EDIT.

package inventories

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// CreateInventoryReader is a Reader for the CreateInventory structure.
type CreateInventoryReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateInventoryReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreateInventoryOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewCreateInventoryBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewCreateInventoryForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewCreateInventoryTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewCreateInventoryInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /snapshots/entities/inventories/v1] CreateInventory", response, response.Code())
	}
}

// NewCreateInventoryOK creates a CreateInventoryOK with default headers values
func NewCreateInventoryOK() *CreateInventoryOK {
	return &CreateInventoryOK{}
}

/*
CreateInventoryOK describes a response with status code 200, with default header values.

OK
*/
type CreateInventoryOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.CommonEntitiesResponse
}

// IsSuccess returns true when this create inventory o k response has a 2xx status code
func (o *CreateInventoryOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create inventory o k response has a 3xx status code
func (o *CreateInventoryOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create inventory o k response has a 4xx status code
func (o *CreateInventoryOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this create inventory o k response has a 5xx status code
func (o *CreateInventoryOK) IsServerError() bool {
	return false
}

// IsCode returns true when this create inventory o k response a status code equal to that given
func (o *CreateInventoryOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the create inventory o k response
func (o *CreateInventoryOK) Code() int {
	return 200
}

func (o *CreateInventoryOK) Error() string {
	return fmt.Sprintf("[POST /snapshots/entities/inventories/v1][%d] createInventoryOK  %+v", 200, o.Payload)
}

func (o *CreateInventoryOK) String() string {
	return fmt.Sprintf("[POST /snapshots/entities/inventories/v1][%d] createInventoryOK  %+v", 200, o.Payload)
}

func (o *CreateInventoryOK) GetPayload() *models.CommonEntitiesResponse {
	return o.Payload
}

func (o *CreateInventoryOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.CommonEntitiesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateInventoryBadRequest creates a CreateInventoryBadRequest with default headers values
func NewCreateInventoryBadRequest() *CreateInventoryBadRequest {
	return &CreateInventoryBadRequest{}
}

/*
CreateInventoryBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type CreateInventoryBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecResponseFields
}

// IsSuccess returns true when this create inventory bad request response has a 2xx status code
func (o *CreateInventoryBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create inventory bad request response has a 3xx status code
func (o *CreateInventoryBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create inventory bad request response has a 4xx status code
func (o *CreateInventoryBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this create inventory bad request response has a 5xx status code
func (o *CreateInventoryBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this create inventory bad request response a status code equal to that given
func (o *CreateInventoryBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the create inventory bad request response
func (o *CreateInventoryBadRequest) Code() int {
	return 400
}

func (o *CreateInventoryBadRequest) Error() string {
	return fmt.Sprintf("[POST /snapshots/entities/inventories/v1][%d] createInventoryBadRequest  %+v", 400, o.Payload)
}

func (o *CreateInventoryBadRequest) String() string {
	return fmt.Sprintf("[POST /snapshots/entities/inventories/v1][%d] createInventoryBadRequest  %+v", 400, o.Payload)
}

func (o *CreateInventoryBadRequest) GetPayload() *models.MsaspecResponseFields {
	return o.Payload
}

func (o *CreateInventoryBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateInventoryForbidden creates a CreateInventoryForbidden with default headers values
func NewCreateInventoryForbidden() *CreateInventoryForbidden {
	return &CreateInventoryForbidden{}
}

/*
CreateInventoryForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type CreateInventoryForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecResponseFields
}

// IsSuccess returns true when this create inventory forbidden response has a 2xx status code
func (o *CreateInventoryForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create inventory forbidden response has a 3xx status code
func (o *CreateInventoryForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create inventory forbidden response has a 4xx status code
func (o *CreateInventoryForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this create inventory forbidden response has a 5xx status code
func (o *CreateInventoryForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this create inventory forbidden response a status code equal to that given
func (o *CreateInventoryForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the create inventory forbidden response
func (o *CreateInventoryForbidden) Code() int {
	return 403
}

func (o *CreateInventoryForbidden) Error() string {
	return fmt.Sprintf("[POST /snapshots/entities/inventories/v1][%d] createInventoryForbidden  %+v", 403, o.Payload)
}

func (o *CreateInventoryForbidden) String() string {
	return fmt.Sprintf("[POST /snapshots/entities/inventories/v1][%d] createInventoryForbidden  %+v", 403, o.Payload)
}

func (o *CreateInventoryForbidden) GetPayload() *models.MsaspecResponseFields {
	return o.Payload
}

func (o *CreateInventoryForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateInventoryTooManyRequests creates a CreateInventoryTooManyRequests with default headers values
func NewCreateInventoryTooManyRequests() *CreateInventoryTooManyRequests {
	return &CreateInventoryTooManyRequests{}
}

/*
CreateInventoryTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type CreateInventoryTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this create inventory too many requests response has a 2xx status code
func (o *CreateInventoryTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create inventory too many requests response has a 3xx status code
func (o *CreateInventoryTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create inventory too many requests response has a 4xx status code
func (o *CreateInventoryTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this create inventory too many requests response has a 5xx status code
func (o *CreateInventoryTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this create inventory too many requests response a status code equal to that given
func (o *CreateInventoryTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the create inventory too many requests response
func (o *CreateInventoryTooManyRequests) Code() int {
	return 429
}

func (o *CreateInventoryTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /snapshots/entities/inventories/v1][%d] createInventoryTooManyRequests  %+v", 429, o.Payload)
}

func (o *CreateInventoryTooManyRequests) String() string {
	return fmt.Sprintf("[POST /snapshots/entities/inventories/v1][%d] createInventoryTooManyRequests  %+v", 429, o.Payload)
}

func (o *CreateInventoryTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CreateInventoryTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateInventoryInternalServerError creates a CreateInventoryInternalServerError with default headers values
func NewCreateInventoryInternalServerError() *CreateInventoryInternalServerError {
	return &CreateInventoryInternalServerError{}
}

/*
CreateInventoryInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type CreateInventoryInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecResponseFields
}

// IsSuccess returns true when this create inventory internal server error response has a 2xx status code
func (o *CreateInventoryInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create inventory internal server error response has a 3xx status code
func (o *CreateInventoryInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create inventory internal server error response has a 4xx status code
func (o *CreateInventoryInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this create inventory internal server error response has a 5xx status code
func (o *CreateInventoryInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this create inventory internal server error response a status code equal to that given
func (o *CreateInventoryInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the create inventory internal server error response
func (o *CreateInventoryInternalServerError) Code() int {
	return 500
}

func (o *CreateInventoryInternalServerError) Error() string {
	return fmt.Sprintf("[POST /snapshots/entities/inventories/v1][%d] createInventoryInternalServerError  %+v", 500, o.Payload)
}

func (o *CreateInventoryInternalServerError) String() string {
	return fmt.Sprintf("[POST /snapshots/entities/inventories/v1][%d] createInventoryInternalServerError  %+v", 500, o.Payload)
}

func (o *CreateInventoryInternalServerError) GetPayload() *models.MsaspecResponseFields {
	return o.Payload
}

func (o *CreateInventoryInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
