// Code generated by go-swagger; DO NOT EDIT.

package ioc

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewActionQueryV1Params creates a new ActionQueryV1Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewActionQueryV1Params() *ActionQueryV1Params {
	return &ActionQueryV1Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewActionQueryV1ParamsWithTimeout creates a new ActionQueryV1Params object
// with the ability to set a timeout on a request.
func NewActionQueryV1ParamsWithTimeout(timeout time.Duration) *ActionQueryV1Params {
	return &ActionQueryV1Params{
		timeout: timeout,
	}
}

// NewActionQueryV1ParamsWithContext creates a new ActionQueryV1Params object
// with the ability to set a context for a request.
func NewActionQueryV1ParamsWithContext(ctx context.Context) *ActionQueryV1Params {
	return &ActionQueryV1Params{
		Context: ctx,
	}
}

// NewActionQueryV1ParamsWithHTTPClient creates a new ActionQueryV1Params object
// with the ability to set a custom HTTPClient for a request.
func NewActionQueryV1ParamsWithHTTPClient(client *http.Client) *ActionQueryV1Params {
	return &ActionQueryV1Params{
		HTTPClient: client,
	}
}

/*
ActionQueryV1Params contains all the parameters to send to the API endpoint

	for the action query v1 operation.

	Typically these are written to a http.Request.
*/
type ActionQueryV1Params struct {

	/* Limit.

	   Number of ids to return.
	*/
	Limit *int64

	/* Offset.

	   Starting index of overall result set from which to return ids.
	*/
	Offset *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the action query v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ActionQueryV1Params) WithDefaults() *ActionQueryV1Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the action query v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ActionQueryV1Params) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the action query v1 params
func (o *ActionQueryV1Params) WithTimeout(timeout time.Duration) *ActionQueryV1Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the action query v1 params
func (o *ActionQueryV1Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the action query v1 params
func (o *ActionQueryV1Params) WithContext(ctx context.Context) *ActionQueryV1Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the action query v1 params
func (o *ActionQueryV1Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the action query v1 params
func (o *ActionQueryV1Params) WithHTTPClient(client *http.Client) *ActionQueryV1Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the action query v1 params
func (o *ActionQueryV1Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithLimit adds the limit to the action query v1 params
func (o *ActionQueryV1Params) WithLimit(limit *int64) *ActionQueryV1Params {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the action query v1 params
func (o *ActionQueryV1Params) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithOffset adds the offset to the action query v1 params
func (o *ActionQueryV1Params) WithOffset(offset *string) *ActionQueryV1Params {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the action query v1 params
func (o *ActionQueryV1Params) SetOffset(offset *string) {
	o.Offset = offset
}

// WriteToRequest writes these params to a swagger request
func (o *ActionQueryV1Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset string

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := qrOffset
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
