// Code generated by go-swagger; DO NOT EDIT.

package ioc

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// NewIndicatorAggregateV1Params creates a new IndicatorAggregateV1Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewIndicatorAggregateV1Params() *IndicatorAggregateV1Params {
	return &IndicatorAggregateV1Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewIndicatorAggregateV1ParamsWithTimeout creates a new IndicatorAggregateV1Params object
// with the ability to set a timeout on a request.
func NewIndicatorAggregateV1ParamsWithTimeout(timeout time.Duration) *IndicatorAggregateV1Params {
	return &IndicatorAggregateV1Params{
		timeout: timeout,
	}
}

// NewIndicatorAggregateV1ParamsWithContext creates a new IndicatorAggregateV1Params object
// with the ability to set a context for a request.
func NewIndicatorAggregateV1ParamsWithContext(ctx context.Context) *IndicatorAggregateV1Params {
	return &IndicatorAggregateV1Params{
		Context: ctx,
	}
}

// NewIndicatorAggregateV1ParamsWithHTTPClient creates a new IndicatorAggregateV1Params object
// with the ability to set a custom HTTPClient for a request.
func NewIndicatorAggregateV1ParamsWithHTTPClient(client *http.Client) *IndicatorAggregateV1Params {
	return &IndicatorAggregateV1Params{
		HTTPClient: client,
	}
}

/*
IndicatorAggregateV1Params contains all the parameters to send to the API endpoint

	for the indicator aggregate v1 operation.

	Typically these are written to a http.Request.
*/
type IndicatorAggregateV1Params struct {

	// Body.
	Body *models.MsaAggregateQueryRequest

	/* Filter.

	   The filter to narrow down the aggregation data
	*/
	Filter *string

	/* FromParent.

	   The filter for returning either only indicators for the request customer or its MSSP parents
	*/
	FromParent *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the indicator aggregate v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IndicatorAggregateV1Params) WithDefaults() *IndicatorAggregateV1Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the indicator aggregate v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IndicatorAggregateV1Params) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the indicator aggregate v1 params
func (o *IndicatorAggregateV1Params) WithTimeout(timeout time.Duration) *IndicatorAggregateV1Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the indicator aggregate v1 params
func (o *IndicatorAggregateV1Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the indicator aggregate v1 params
func (o *IndicatorAggregateV1Params) WithContext(ctx context.Context) *IndicatorAggregateV1Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the indicator aggregate v1 params
func (o *IndicatorAggregateV1Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the indicator aggregate v1 params
func (o *IndicatorAggregateV1Params) WithHTTPClient(client *http.Client) *IndicatorAggregateV1Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the indicator aggregate v1 params
func (o *IndicatorAggregateV1Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the indicator aggregate v1 params
func (o *IndicatorAggregateV1Params) WithBody(body *models.MsaAggregateQueryRequest) *IndicatorAggregateV1Params {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the indicator aggregate v1 params
func (o *IndicatorAggregateV1Params) SetBody(body *models.MsaAggregateQueryRequest) {
	o.Body = body
}

// WithFilter adds the filter to the indicator aggregate v1 params
func (o *IndicatorAggregateV1Params) WithFilter(filter *string) *IndicatorAggregateV1Params {
	o.SetFilter(filter)
	return o
}

// SetFilter adds the filter to the indicator aggregate v1 params
func (o *IndicatorAggregateV1Params) SetFilter(filter *string) {
	o.Filter = filter
}

// WithFromParent adds the fromParent to the indicator aggregate v1 params
func (o *IndicatorAggregateV1Params) WithFromParent(fromParent *bool) *IndicatorAggregateV1Params {
	o.SetFromParent(fromParent)
	return o
}

// SetFromParent adds the fromParent to the indicator aggregate v1 params
func (o *IndicatorAggregateV1Params) SetFromParent(fromParent *bool) {
	o.FromParent = fromParent
}

// WriteToRequest writes these params to a swagger request
func (o *IndicatorAggregateV1Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if o.Filter != nil {

		// query param filter
		var qrFilter string

		if o.Filter != nil {
			qrFilter = *o.Filter
		}
		qFilter := qrFilter
		if qFilter != "" {

			if err := r.SetQueryParam("filter", qFilter); err != nil {
				return err
			}
		}
	}

	if o.FromParent != nil {

		// query param from_parent
		var qrFromParent bool

		if o.FromParent != nil {
			qrFromParent = *o.FromParent
		}
		qFromParent := swag.FormatBool(qrFromParent)
		if qFromParent != "" {

			if err := r.SetQueryParam("from_parent", qFromParent); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
