// Code generated by go-swagger; DO NOT EDIT.

package ioc

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewIndicatorDeleteV1Params creates a new IndicatorDeleteV1Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewIndicatorDeleteV1Params() *IndicatorDeleteV1Params {
	return &IndicatorDeleteV1Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewIndicatorDeleteV1ParamsWithTimeout creates a new IndicatorDeleteV1Params object
// with the ability to set a timeout on a request.
func NewIndicatorDeleteV1ParamsWithTimeout(timeout time.Duration) *IndicatorDeleteV1Params {
	return &IndicatorDeleteV1Params{
		timeout: timeout,
	}
}

// NewIndicatorDeleteV1ParamsWithContext creates a new IndicatorDeleteV1Params object
// with the ability to set a context for a request.
func NewIndicatorDeleteV1ParamsWithContext(ctx context.Context) *IndicatorDeleteV1Params {
	return &IndicatorDeleteV1Params{
		Context: ctx,
	}
}

// NewIndicatorDeleteV1ParamsWithHTTPClient creates a new IndicatorDeleteV1Params object
// with the ability to set a custom HTTPClient for a request.
func NewIndicatorDeleteV1ParamsWithHTTPClient(client *http.Client) *IndicatorDeleteV1Params {
	return &IndicatorDeleteV1Params{
		HTTPClient: client,
	}
}

/*
IndicatorDeleteV1Params contains all the parameters to send to the API endpoint

	for the indicator delete v1 operation.

	Typically these are written to a http.Request.
*/
type IndicatorDeleteV1Params struct {

	/* Comment.

	   The comment why these indicators were deleted
	*/
	Comment *string

	/* Filter.

	   The FQL expression to delete Indicators in bulk. If both 'filter' and 'ids' are provided, then filter takes precedence and ignores ids.
	*/
	Filter *string

	/* FromParent.

	   The filter for returning either only indicators for the request customer or its MSSP parents
	*/
	FromParent *bool

	/* Ids.

	   The ids of the Indicators to delete. If both 'filter' and 'ids' are provided, then filter takes precedence and ignores ids
	*/
	Ids []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the indicator delete v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IndicatorDeleteV1Params) WithDefaults() *IndicatorDeleteV1Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the indicator delete v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IndicatorDeleteV1Params) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the indicator delete v1 params
func (o *IndicatorDeleteV1Params) WithTimeout(timeout time.Duration) *IndicatorDeleteV1Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the indicator delete v1 params
func (o *IndicatorDeleteV1Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the indicator delete v1 params
func (o *IndicatorDeleteV1Params) WithContext(ctx context.Context) *IndicatorDeleteV1Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the indicator delete v1 params
func (o *IndicatorDeleteV1Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the indicator delete v1 params
func (o *IndicatorDeleteV1Params) WithHTTPClient(client *http.Client) *IndicatorDeleteV1Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the indicator delete v1 params
func (o *IndicatorDeleteV1Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithComment adds the comment to the indicator delete v1 params
func (o *IndicatorDeleteV1Params) WithComment(comment *string) *IndicatorDeleteV1Params {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the indicator delete v1 params
func (o *IndicatorDeleteV1Params) SetComment(comment *string) {
	o.Comment = comment
}

// WithFilter adds the filter to the indicator delete v1 params
func (o *IndicatorDeleteV1Params) WithFilter(filter *string) *IndicatorDeleteV1Params {
	o.SetFilter(filter)
	return o
}

// SetFilter adds the filter to the indicator delete v1 params
func (o *IndicatorDeleteV1Params) SetFilter(filter *string) {
	o.Filter = filter
}

// WithFromParent adds the fromParent to the indicator delete v1 params
func (o *IndicatorDeleteV1Params) WithFromParent(fromParent *bool) *IndicatorDeleteV1Params {
	o.SetFromParent(fromParent)
	return o
}

// SetFromParent adds the fromParent to the indicator delete v1 params
func (o *IndicatorDeleteV1Params) SetFromParent(fromParent *bool) {
	o.FromParent = fromParent
}

// WithIds adds the ids to the indicator delete v1 params
func (o *IndicatorDeleteV1Params) WithIds(ids []string) *IndicatorDeleteV1Params {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the indicator delete v1 params
func (o *IndicatorDeleteV1Params) SetIds(ids []string) {
	o.Ids = ids
}

// WriteToRequest writes these params to a swagger request
func (o *IndicatorDeleteV1Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.Filter != nil {

		// query param filter
		var qrFilter string

		if o.Filter != nil {
			qrFilter = *o.Filter
		}
		qFilter := qrFilter
		if qFilter != "" {

			if err := r.SetQueryParam("filter", qFilter); err != nil {
				return err
			}
		}
	}

	if o.FromParent != nil {

		// query param from_parent
		var qrFromParent bool

		if o.FromParent != nil {
			qrFromParent = *o.FromParent
		}
		qFromParent := swag.FormatBool(qrFromParent)
		if qFromParent != "" {

			if err := r.SetQueryParam("from_parent", qFromParent); err != nil {
				return err
			}
		}
	}

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamIndicatorDeleteV1 binds the parameter ids
func (o *IndicatorDeleteV1Params) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}
