// Code generated by go-swagger; DO NOT EDIT.

package ioc

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// NewIndicatorUpdateV1Params creates a new IndicatorUpdateV1Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewIndicatorUpdateV1Params() *IndicatorUpdateV1Params {
	return &IndicatorUpdateV1Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewIndicatorUpdateV1ParamsWithTimeout creates a new IndicatorUpdateV1Params object
// with the ability to set a timeout on a request.
func NewIndicatorUpdateV1ParamsWithTimeout(timeout time.Duration) *IndicatorUpdateV1Params {
	return &IndicatorUpdateV1Params{
		timeout: timeout,
	}
}

// NewIndicatorUpdateV1ParamsWithContext creates a new IndicatorUpdateV1Params object
// with the ability to set a context for a request.
func NewIndicatorUpdateV1ParamsWithContext(ctx context.Context) *IndicatorUpdateV1Params {
	return &IndicatorUpdateV1Params{
		Context: ctx,
	}
}

// NewIndicatorUpdateV1ParamsWithHTTPClient creates a new IndicatorUpdateV1Params object
// with the ability to set a custom HTTPClient for a request.
func NewIndicatorUpdateV1ParamsWithHTTPClient(client *http.Client) *IndicatorUpdateV1Params {
	return &IndicatorUpdateV1Params{
		HTTPClient: client,
	}
}

/*
IndicatorUpdateV1Params contains all the parameters to send to the API endpoint

	for the indicator update v1 operation.

	Typically these are written to a http.Request.
*/
type IndicatorUpdateV1Params struct {

	// Body.
	Body *models.APIIndicatorUpdateReqsV1

	/* IgnoreWarnings.

	   Set to true to ignore warnings and add all IOCs
	*/
	IgnoreWarnings *bool

	/* Retrodetects.

	   Whether to submit to retrodetects
	*/
	Retrodetects *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the indicator update v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IndicatorUpdateV1Params) WithDefaults() *IndicatorUpdateV1Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the indicator update v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IndicatorUpdateV1Params) SetDefaults() {
	var (
		ignoreWarningsDefault = bool(false)
	)

	val := IndicatorUpdateV1Params{
		IgnoreWarnings: &ignoreWarningsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the indicator update v1 params
func (o *IndicatorUpdateV1Params) WithTimeout(timeout time.Duration) *IndicatorUpdateV1Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the indicator update v1 params
func (o *IndicatorUpdateV1Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the indicator update v1 params
func (o *IndicatorUpdateV1Params) WithContext(ctx context.Context) *IndicatorUpdateV1Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the indicator update v1 params
func (o *IndicatorUpdateV1Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the indicator update v1 params
func (o *IndicatorUpdateV1Params) WithHTTPClient(client *http.Client) *IndicatorUpdateV1Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the indicator update v1 params
func (o *IndicatorUpdateV1Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the indicator update v1 params
func (o *IndicatorUpdateV1Params) WithBody(body *models.APIIndicatorUpdateReqsV1) *IndicatorUpdateV1Params {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the indicator update v1 params
func (o *IndicatorUpdateV1Params) SetBody(body *models.APIIndicatorUpdateReqsV1) {
	o.Body = body
}

// WithIgnoreWarnings adds the ignoreWarnings to the indicator update v1 params
func (o *IndicatorUpdateV1Params) WithIgnoreWarnings(ignoreWarnings *bool) *IndicatorUpdateV1Params {
	o.SetIgnoreWarnings(ignoreWarnings)
	return o
}

// SetIgnoreWarnings adds the ignoreWarnings to the indicator update v1 params
func (o *IndicatorUpdateV1Params) SetIgnoreWarnings(ignoreWarnings *bool) {
	o.IgnoreWarnings = ignoreWarnings
}

// WithRetrodetects adds the retrodetects to the indicator update v1 params
func (o *IndicatorUpdateV1Params) WithRetrodetects(retrodetects *bool) *IndicatorUpdateV1Params {
	o.SetRetrodetects(retrodetects)
	return o
}

// SetRetrodetects adds the retrodetects to the indicator update v1 params
func (o *IndicatorUpdateV1Params) SetRetrodetects(retrodetects *bool) {
	o.Retrodetects = retrodetects
}

// WriteToRequest writes these params to a swagger request
func (o *IndicatorUpdateV1Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if o.IgnoreWarnings != nil {

		// query param ignore_warnings
		var qrIgnoreWarnings bool

		if o.IgnoreWarnings != nil {
			qrIgnoreWarnings = *o.IgnoreWarnings
		}
		qIgnoreWarnings := swag.FormatBool(qrIgnoreWarnings)
		if qIgnoreWarnings != "" {

			if err := r.SetQueryParam("ignore_warnings", qIgnoreWarnings); err != nil {
				return err
			}
		}
	}

	if o.Retrodetects != nil {

		// query param retrodetects
		var qrRetrodetects bool

		if o.Retrodetects != nil {
			qrRetrodetects = *o.Retrodetects
		}
		qRetrodetects := swag.FormatBool(qrRetrodetects)
		if qRetrodetects != "" {

			if err := r.SetQueryParam("retrodetects", qRetrodetects); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
