// Code generated by go-swagger; DO NOT EDIT.

package ioc

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewPlatformQueryV1Params creates a new PlatformQueryV1Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPlatformQueryV1Params() *PlatformQueryV1Params {
	return &PlatformQueryV1Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewPlatformQueryV1ParamsWithTimeout creates a new PlatformQueryV1Params object
// with the ability to set a timeout on a request.
func NewPlatformQueryV1ParamsWithTimeout(timeout time.Duration) *PlatformQueryV1Params {
	return &PlatformQueryV1Params{
		timeout: timeout,
	}
}

// NewPlatformQueryV1ParamsWithContext creates a new PlatformQueryV1Params object
// with the ability to set a context for a request.
func NewPlatformQueryV1ParamsWithContext(ctx context.Context) *PlatformQueryV1Params {
	return &PlatformQueryV1Params{
		Context: ctx,
	}
}

// NewPlatformQueryV1ParamsWithHTTPClient creates a new PlatformQueryV1Params object
// with the ability to set a custom HTTPClient for a request.
func NewPlatformQueryV1ParamsWithHTTPClient(client *http.Client) *PlatformQueryV1Params {
	return &PlatformQueryV1Params{
		HTTPClient: client,
	}
}

/*
PlatformQueryV1Params contains all the parameters to send to the API endpoint

	for the platform query v1 operation.

	Typically these are written to a http.Request.
*/
type PlatformQueryV1Params struct {

	/* Limit.

	   Number of ids to return.
	*/
	Limit *int64

	/* Offset.

	   Starting index of overall result set from which to return ids.
	*/
	Offset *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the platform query v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PlatformQueryV1Params) WithDefaults() *PlatformQueryV1Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the platform query v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PlatformQueryV1Params) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the platform query v1 params
func (o *PlatformQueryV1Params) WithTimeout(timeout time.Duration) *PlatformQueryV1Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the platform query v1 params
func (o *PlatformQueryV1Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the platform query v1 params
func (o *PlatformQueryV1Params) WithContext(ctx context.Context) *PlatformQueryV1Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the platform query v1 params
func (o *PlatformQueryV1Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the platform query v1 params
func (o *PlatformQueryV1Params) WithHTTPClient(client *http.Client) *PlatformQueryV1Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the platform query v1 params
func (o *PlatformQueryV1Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithLimit adds the limit to the platform query v1 params
func (o *PlatformQueryV1Params) WithLimit(limit *int64) *PlatformQueryV1Params {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the platform query v1 params
func (o *PlatformQueryV1Params) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithOffset adds the offset to the platform query v1 params
func (o *PlatformQueryV1Params) WithOffset(offset *string) *PlatformQueryV1Params {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the platform query v1 params
func (o *PlatformQueryV1Params) SetOffset(offset *string) {
	o.Offset = offset
}

// WriteToRequest writes these params to a swagger request
func (o *PlatformQueryV1Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset string

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := qrOffset
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
