// Code generated by go-swagger; DO NOT EDIT.

package ioc

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// PlatformQueryV1Reader is a Reader for the PlatformQueryV1 structure.
type PlatformQueryV1Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PlatformQueryV1Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPlatformQueryV1OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewPlatformQueryV1Forbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewPlatformQueryV1TooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /iocs/queries/platforms/v1] platform.query.v1", response, response.Code())
	}
}

// NewPlatformQueryV1OK creates a PlatformQueryV1OK with default headers values
func NewPlatformQueryV1OK() *PlatformQueryV1OK {
	return &PlatformQueryV1OK{}
}

/*
PlatformQueryV1OK describes a response with status code 200, with default header values.

OK
*/
type PlatformQueryV1OK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.APIIndicatorQueryRespV1
}

// IsSuccess returns true when this platform query v1 o k response has a 2xx status code
func (o *PlatformQueryV1OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this platform query v1 o k response has a 3xx status code
func (o *PlatformQueryV1OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this platform query v1 o k response has a 4xx status code
func (o *PlatformQueryV1OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this platform query v1 o k response has a 5xx status code
func (o *PlatformQueryV1OK) IsServerError() bool {
	return false
}

// IsCode returns true when this platform query v1 o k response a status code equal to that given
func (o *PlatformQueryV1OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the platform query v1 o k response
func (o *PlatformQueryV1OK) Code() int {
	return 200
}

func (o *PlatformQueryV1OK) Error() string {
	return fmt.Sprintf("[GET /iocs/queries/platforms/v1][%d] platformQueryV1OK  %+v", 200, o.Payload)
}

func (o *PlatformQueryV1OK) String() string {
	return fmt.Sprintf("[GET /iocs/queries/platforms/v1][%d] platformQueryV1OK  %+v", 200, o.Payload)
}

func (o *PlatformQueryV1OK) GetPayload() *models.APIIndicatorQueryRespV1 {
	return o.Payload
}

func (o *PlatformQueryV1OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.APIIndicatorQueryRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPlatformQueryV1Forbidden creates a PlatformQueryV1Forbidden with default headers values
func NewPlatformQueryV1Forbidden() *PlatformQueryV1Forbidden {
	return &PlatformQueryV1Forbidden{}
}

/*
PlatformQueryV1Forbidden describes a response with status code 403, with default header values.

Forbidden
*/
type PlatformQueryV1Forbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this platform query v1 forbidden response has a 2xx status code
func (o *PlatformQueryV1Forbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this platform query v1 forbidden response has a 3xx status code
func (o *PlatformQueryV1Forbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this platform query v1 forbidden response has a 4xx status code
func (o *PlatformQueryV1Forbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this platform query v1 forbidden response has a 5xx status code
func (o *PlatformQueryV1Forbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this platform query v1 forbidden response a status code equal to that given
func (o *PlatformQueryV1Forbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the platform query v1 forbidden response
func (o *PlatformQueryV1Forbidden) Code() int {
	return 403
}

func (o *PlatformQueryV1Forbidden) Error() string {
	return fmt.Sprintf("[GET /iocs/queries/platforms/v1][%d] platformQueryV1Forbidden  %+v", 403, o.Payload)
}

func (o *PlatformQueryV1Forbidden) String() string {
	return fmt.Sprintf("[GET /iocs/queries/platforms/v1][%d] platformQueryV1Forbidden  %+v", 403, o.Payload)
}

func (o *PlatformQueryV1Forbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *PlatformQueryV1Forbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPlatformQueryV1TooManyRequests creates a PlatformQueryV1TooManyRequests with default headers values
func NewPlatformQueryV1TooManyRequests() *PlatformQueryV1TooManyRequests {
	return &PlatformQueryV1TooManyRequests{}
}

/*
PlatformQueryV1TooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type PlatformQueryV1TooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this platform query v1 too many requests response has a 2xx status code
func (o *PlatformQueryV1TooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this platform query v1 too many requests response has a 3xx status code
func (o *PlatformQueryV1TooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this platform query v1 too many requests response has a 4xx status code
func (o *PlatformQueryV1TooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this platform query v1 too many requests response has a 5xx status code
func (o *PlatformQueryV1TooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this platform query v1 too many requests response a status code equal to that given
func (o *PlatformQueryV1TooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the platform query v1 too many requests response
func (o *PlatformQueryV1TooManyRequests) Code() int {
	return 429
}

func (o *PlatformQueryV1TooManyRequests) Error() string {
	return fmt.Sprintf("[GET /iocs/queries/platforms/v1][%d] platformQueryV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *PlatformQueryV1TooManyRequests) String() string {
	return fmt.Sprintf("[GET /iocs/queries/platforms/v1][%d] platformQueryV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *PlatformQueryV1TooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *PlatformQueryV1TooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
