// Code generated by go-swagger; DO NOT EDIT.

package iocs

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewEntitiesProcessesParams creates a new EntitiesProcessesParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewEntitiesProcessesParams() *EntitiesProcessesParams {
	return &EntitiesProcessesParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewEntitiesProcessesParamsWithTimeout creates a new EntitiesProcessesParams object
// with the ability to set a timeout on a request.
func NewEntitiesProcessesParamsWithTimeout(timeout time.Duration) *EntitiesProcessesParams {
	return &EntitiesProcessesParams{
		timeout: timeout,
	}
}

// NewEntitiesProcessesParamsWithContext creates a new EntitiesProcessesParams object
// with the ability to set a context for a request.
func NewEntitiesProcessesParamsWithContext(ctx context.Context) *EntitiesProcessesParams {
	return &EntitiesProcessesParams{
		Context: ctx,
	}
}

// NewEntitiesProcessesParamsWithHTTPClient creates a new EntitiesProcessesParams object
// with the ability to set a custom HTTPClient for a request.
func NewEntitiesProcessesParamsWithHTTPClient(client *http.Client) *EntitiesProcessesParams {
	return &EntitiesProcessesParams{
		HTTPClient: client,
	}
}

/*
EntitiesProcessesParams contains all the parameters to send to the API endpoint

	for the entities processes operation.

	Typically these are written to a http.Request.
*/
type EntitiesProcessesParams struct {

	/* Ids.

	   ProcessID for the running process you want to lookup
	*/
	Ids []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the entities processes params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *EntitiesProcessesParams) WithDefaults() *EntitiesProcessesParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the entities processes params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *EntitiesProcessesParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the entities processes params
func (o *EntitiesProcessesParams) WithTimeout(timeout time.Duration) *EntitiesProcessesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the entities processes params
func (o *EntitiesProcessesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the entities processes params
func (o *EntitiesProcessesParams) WithContext(ctx context.Context) *EntitiesProcessesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the entities processes params
func (o *EntitiesProcessesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the entities processes params
func (o *EntitiesProcessesParams) WithHTTPClient(client *http.Client) *EntitiesProcessesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the entities processes params
func (o *EntitiesProcessesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the entities processes params
func (o *EntitiesProcessesParams) WithIds(ids []string) *EntitiesProcessesParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the entities processes params
func (o *EntitiesProcessesParams) SetIds(ids []string) {
	o.Ids = ids
}

// WriteToRequest writes these params to a swagger request
func (o *EntitiesProcessesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamEntitiesProcesses binds the parameter ids
func (o *EntitiesProcessesParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}
