// Code generated by go-swagger; DO NOT EDIT.

package iocs

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new iocs API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for iocs API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	DevicesCount(params *DevicesCountParams, opts ...ClientOption) (*DevicesCountOK, error)

	DevicesRanOn(params *DevicesRanOnParams, opts ...ClientOption) (*DevicesRanOnOK, error)

	ProcessesRanOn(params *ProcessesRanOnParams, opts ...ClientOption) (*ProcessesRanOnOK, error)

	EntitiesProcesses(params *EntitiesProcessesParams, opts ...ClientOption) (*EntitiesProcessesOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
DevicesCount numbers of hosts in your customer account that have observed a given custom i o c
*/
func (a *Client) DevicesCount(params *DevicesCountParams, opts ...ClientOption) (*DevicesCountOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDevicesCountParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DevicesCount",
		Method:             "GET",
		PathPattern:        "/indicators/aggregates/devices-count/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DevicesCountReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DevicesCountOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for DevicesCount: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DevicesRanOn finds hosts that have observed a given custom i o c for details about those hosts use g e t devices entities devices v1
*/
func (a *Client) DevicesRanOn(params *DevicesRanOnParams, opts ...ClientOption) (*DevicesRanOnOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDevicesRanOnParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DevicesRanOn",
		Method:             "GET",
		PathPattern:        "/indicators/queries/devices/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DevicesRanOnReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DevicesRanOnOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for DevicesRanOn: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ProcessesRanOn searches for processes associated with a custom i o c
*/
func (a *Client) ProcessesRanOn(params *ProcessesRanOnParams, opts ...ClientOption) (*ProcessesRanOnOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewProcessesRanOnParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ProcessesRanOn",
		Method:             "GET",
		PathPattern:        "/indicators/queries/processes/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ProcessesRanOnReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ProcessesRanOnOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ProcessesRanOn: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
EntitiesProcesses fors the provided process ID retrieve the process details
*/
func (a *Client) EntitiesProcesses(params *EntitiesProcessesParams, opts ...ClientOption) (*EntitiesProcessesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEntitiesProcessesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "entities.processes",
		Method:             "GET",
		PathPattern:        "/processes/entities/processes/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &EntitiesProcessesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*EntitiesProcessesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for entities.processes: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
