// Code generated by go-swagger; DO NOT EDIT.

package iocs

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// ProcessesRanOnReader is a Reader for the ProcessesRanOn structure.
type ProcessesRanOnReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ProcessesRanOnReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewProcessesRanOnOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewProcessesRanOnForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewProcessesRanOnTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /indicators/queries/processes/v1] ProcessesRanOn", response, response.Code())
	}
}

// NewProcessesRanOnOK creates a ProcessesRanOnOK with default headers values
func NewProcessesRanOnOK() *ProcessesRanOnOK {
	return &ProcessesRanOnOK{}
}

/*
ProcessesRanOnOK describes a response with status code 200, with default header values.

OK
*/
type ProcessesRanOnOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.IocapiMsaReplyProcessesRanOn
}

// IsSuccess returns true when this processes ran on o k response has a 2xx status code
func (o *ProcessesRanOnOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this processes ran on o k response has a 3xx status code
func (o *ProcessesRanOnOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this processes ran on o k response has a 4xx status code
func (o *ProcessesRanOnOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this processes ran on o k response has a 5xx status code
func (o *ProcessesRanOnOK) IsServerError() bool {
	return false
}

// IsCode returns true when this processes ran on o k response a status code equal to that given
func (o *ProcessesRanOnOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the processes ran on o k response
func (o *ProcessesRanOnOK) Code() int {
	return 200
}

func (o *ProcessesRanOnOK) Error() string {
	return fmt.Sprintf("[GET /indicators/queries/processes/v1][%d] processesRanOnOK  %+v", 200, o.Payload)
}

func (o *ProcessesRanOnOK) String() string {
	return fmt.Sprintf("[GET /indicators/queries/processes/v1][%d] processesRanOnOK  %+v", 200, o.Payload)
}

func (o *ProcessesRanOnOK) GetPayload() *models.IocapiMsaReplyProcessesRanOn {
	return o.Payload
}

func (o *ProcessesRanOnOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.IocapiMsaReplyProcessesRanOn)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewProcessesRanOnForbidden creates a ProcessesRanOnForbidden with default headers values
func NewProcessesRanOnForbidden() *ProcessesRanOnForbidden {
	return &ProcessesRanOnForbidden{}
}

/*
ProcessesRanOnForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type ProcessesRanOnForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this processes ran on forbidden response has a 2xx status code
func (o *ProcessesRanOnForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this processes ran on forbidden response has a 3xx status code
func (o *ProcessesRanOnForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this processes ran on forbidden response has a 4xx status code
func (o *ProcessesRanOnForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this processes ran on forbidden response has a 5xx status code
func (o *ProcessesRanOnForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this processes ran on forbidden response a status code equal to that given
func (o *ProcessesRanOnForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the processes ran on forbidden response
func (o *ProcessesRanOnForbidden) Code() int {
	return 403
}

func (o *ProcessesRanOnForbidden) Error() string {
	return fmt.Sprintf("[GET /indicators/queries/processes/v1][%d] processesRanOnForbidden  %+v", 403, o.Payload)
}

func (o *ProcessesRanOnForbidden) String() string {
	return fmt.Sprintf("[GET /indicators/queries/processes/v1][%d] processesRanOnForbidden  %+v", 403, o.Payload)
}

func (o *ProcessesRanOnForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *ProcessesRanOnForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewProcessesRanOnTooManyRequests creates a ProcessesRanOnTooManyRequests with default headers values
func NewProcessesRanOnTooManyRequests() *ProcessesRanOnTooManyRequests {
	return &ProcessesRanOnTooManyRequests{}
}

/*
ProcessesRanOnTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type ProcessesRanOnTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this processes ran on too many requests response has a 2xx status code
func (o *ProcessesRanOnTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this processes ran on too many requests response has a 3xx status code
func (o *ProcessesRanOnTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this processes ran on too many requests response has a 4xx status code
func (o *ProcessesRanOnTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this processes ran on too many requests response has a 5xx status code
func (o *ProcessesRanOnTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this processes ran on too many requests response a status code equal to that given
func (o *ProcessesRanOnTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the processes ran on too many requests response
func (o *ProcessesRanOnTooManyRequests) Code() int {
	return 429
}

func (o *ProcessesRanOnTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /indicators/queries/processes/v1][%d] processesRanOnTooManyRequests  %+v", 429, o.Payload)
}

func (o *ProcessesRanOnTooManyRequests) String() string {
	return fmt.Sprintf("[GET /indicators/queries/processes/v1][%d] processesRanOnTooManyRequests  %+v", 429, o.Payload)
}

func (o *ProcessesRanOnTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *ProcessesRanOnTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
