// Code generated by go-swagger; DO NOT EDIT.

package kubernetes_protection

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDeleteAzureSubscriptionParams creates a new DeleteAzureSubscriptionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDeleteAzureSubscriptionParams() *DeleteAzureSubscriptionParams {
	return &DeleteAzureSubscriptionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDeleteAzureSubscriptionParamsWithTimeout creates a new DeleteAzureSubscriptionParams object
// with the ability to set a timeout on a request.
func NewDeleteAzureSubscriptionParamsWithTimeout(timeout time.Duration) *DeleteAzureSubscriptionParams {
	return &DeleteAzureSubscriptionParams{
		timeout: timeout,
	}
}

// NewDeleteAzureSubscriptionParamsWithContext creates a new DeleteAzureSubscriptionParams object
// with the ability to set a context for a request.
func NewDeleteAzureSubscriptionParamsWithContext(ctx context.Context) *DeleteAzureSubscriptionParams {
	return &DeleteAzureSubscriptionParams{
		Context: ctx,
	}
}

// NewDeleteAzureSubscriptionParamsWithHTTPClient creates a new DeleteAzureSubscriptionParams object
// with the ability to set a custom HTTPClient for a request.
func NewDeleteAzureSubscriptionParamsWithHTTPClient(client *http.Client) *DeleteAzureSubscriptionParams {
	return &DeleteAzureSubscriptionParams{
		HTTPClient: client,
	}
}

/*
DeleteAzureSubscriptionParams contains all the parameters to send to the API endpoint

	for the delete azure subscription operation.

	Typically these are written to a http.Request.
*/
type DeleteAzureSubscriptionParams struct {

	/* Ids.

	   Azure Subscription IDs
	*/
	Ids []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the delete azure subscription params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteAzureSubscriptionParams) WithDefaults() *DeleteAzureSubscriptionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the delete azure subscription params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteAzureSubscriptionParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the delete azure subscription params
func (o *DeleteAzureSubscriptionParams) WithTimeout(timeout time.Duration) *DeleteAzureSubscriptionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the delete azure subscription params
func (o *DeleteAzureSubscriptionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the delete azure subscription params
func (o *DeleteAzureSubscriptionParams) WithContext(ctx context.Context) *DeleteAzureSubscriptionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the delete azure subscription params
func (o *DeleteAzureSubscriptionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the delete azure subscription params
func (o *DeleteAzureSubscriptionParams) WithHTTPClient(client *http.Client) *DeleteAzureSubscriptionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the delete azure subscription params
func (o *DeleteAzureSubscriptionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the delete azure subscription params
func (o *DeleteAzureSubscriptionParams) WithIds(ids []string) *DeleteAzureSubscriptionParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the delete azure subscription params
func (o *DeleteAzureSubscriptionParams) SetIds(ids []string) {
	o.Ids = ids
}

// WriteToRequest writes these params to a swagger request
func (o *DeleteAzureSubscriptionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDeleteAzureSubscription binds the parameter ids
func (o *DeleteAzureSubscriptionParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "csv"
	idsIS := swag.JoinByFormat(idsIC, "csv")

	return idsIS
}
