// Code generated by go-swagger; DO NOT EDIT.

package kubernetes_protection

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetAWSAccountsMixin0Params creates a new GetAWSAccountsMixin0Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetAWSAccountsMixin0Params() *GetAWSAccountsMixin0Params {
	return &GetAWSAccountsMixin0Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetAWSAccountsMixin0ParamsWithTimeout creates a new GetAWSAccountsMixin0Params object
// with the ability to set a timeout on a request.
func NewGetAWSAccountsMixin0ParamsWithTimeout(timeout time.Duration) *GetAWSAccountsMixin0Params {
	return &GetAWSAccountsMixin0Params{
		timeout: timeout,
	}
}

// NewGetAWSAccountsMixin0ParamsWithContext creates a new GetAWSAccountsMixin0Params object
// with the ability to set a context for a request.
func NewGetAWSAccountsMixin0ParamsWithContext(ctx context.Context) *GetAWSAccountsMixin0Params {
	return &GetAWSAccountsMixin0Params{
		Context: ctx,
	}
}

// NewGetAWSAccountsMixin0ParamsWithHTTPClient creates a new GetAWSAccountsMixin0Params object
// with the ability to set a custom HTTPClient for a request.
func NewGetAWSAccountsMixin0ParamsWithHTTPClient(client *http.Client) *GetAWSAccountsMixin0Params {
	return &GetAWSAccountsMixin0Params{
		HTTPClient: client,
	}
}

/*
GetAWSAccountsMixin0Params contains all the parameters to send to the API endpoint

	for the get a w s accounts mixin0 operation.

	Typically these are written to a http.Request.
*/
type GetAWSAccountsMixin0Params struct {

	/* Ids.

	   AWS Account IDs
	*/
	Ids []string

	/* IsHorizonAcct.

	   Filter by whether an account originates from Horizon or not
	*/
	IsHorizonAcct *string

	/* Limit.

	   Limit returned accounts
	*/
	Limit *int64

	/* Offset.

	   Offset returned accounts
	*/
	Offset *int64

	/* Status.

	   Filter by account status
	*/
	Status *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get a w s accounts mixin0 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetAWSAccountsMixin0Params) WithDefaults() *GetAWSAccountsMixin0Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get a w s accounts mixin0 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetAWSAccountsMixin0Params) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get a w s accounts mixin0 params
func (o *GetAWSAccountsMixin0Params) WithTimeout(timeout time.Duration) *GetAWSAccountsMixin0Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get a w s accounts mixin0 params
func (o *GetAWSAccountsMixin0Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get a w s accounts mixin0 params
func (o *GetAWSAccountsMixin0Params) WithContext(ctx context.Context) *GetAWSAccountsMixin0Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get a w s accounts mixin0 params
func (o *GetAWSAccountsMixin0Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get a w s accounts mixin0 params
func (o *GetAWSAccountsMixin0Params) WithHTTPClient(client *http.Client) *GetAWSAccountsMixin0Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get a w s accounts mixin0 params
func (o *GetAWSAccountsMixin0Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the get a w s accounts mixin0 params
func (o *GetAWSAccountsMixin0Params) WithIds(ids []string) *GetAWSAccountsMixin0Params {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the get a w s accounts mixin0 params
func (o *GetAWSAccountsMixin0Params) SetIds(ids []string) {
	o.Ids = ids
}

// WithIsHorizonAcct adds the isHorizonAcct to the get a w s accounts mixin0 params
func (o *GetAWSAccountsMixin0Params) WithIsHorizonAcct(isHorizonAcct *string) *GetAWSAccountsMixin0Params {
	o.SetIsHorizonAcct(isHorizonAcct)
	return o
}

// SetIsHorizonAcct adds the isHorizonAcct to the get a w s accounts mixin0 params
func (o *GetAWSAccountsMixin0Params) SetIsHorizonAcct(isHorizonAcct *string) {
	o.IsHorizonAcct = isHorizonAcct
}

// WithLimit adds the limit to the get a w s accounts mixin0 params
func (o *GetAWSAccountsMixin0Params) WithLimit(limit *int64) *GetAWSAccountsMixin0Params {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the get a w s accounts mixin0 params
func (o *GetAWSAccountsMixin0Params) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithOffset adds the offset to the get a w s accounts mixin0 params
func (o *GetAWSAccountsMixin0Params) WithOffset(offset *int64) *GetAWSAccountsMixin0Params {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the get a w s accounts mixin0 params
func (o *GetAWSAccountsMixin0Params) SetOffset(offset *int64) {
	o.Offset = offset
}

// WithStatus adds the status to the get a w s accounts mixin0 params
func (o *GetAWSAccountsMixin0Params) WithStatus(status *string) *GetAWSAccountsMixin0Params {
	o.SetStatus(status)
	return o
}

// SetStatus adds the status to the get a w s accounts mixin0 params
func (o *GetAWSAccountsMixin0Params) SetStatus(status *string) {
	o.Status = status
}

// WriteToRequest writes these params to a swagger request
func (o *GetAWSAccountsMixin0Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if o.IsHorizonAcct != nil {

		// query param is_horizon_acct
		var qrIsHorizonAcct string

		if o.IsHorizonAcct != nil {
			qrIsHorizonAcct = *o.IsHorizonAcct
		}
		qIsHorizonAcct := qrIsHorizonAcct
		if qIsHorizonAcct != "" {

			if err := r.SetQueryParam("is_horizon_acct", qIsHorizonAcct); err != nil {
				return err
			}
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset int64

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := swag.FormatInt64(qrOffset)
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if o.Status != nil {

		// query param status
		var qrStatus string

		if o.Status != nil {
			qrStatus = *o.Status
		}
		qStatus := qrStatus
		if qStatus != "" {

			if err := r.SetQueryParam("status", qStatus); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGetAWSAccountsMixin0 binds the parameter ids
func (o *GetAWSAccountsMixin0Params) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "csv"
	idsIS := swag.JoinByFormat(idsIC, "csv")

	return idsIS
}
