// Code generated by go-swagger; DO NOT EDIT.

package kubernetes_protection

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetAWSAccountsMixin0Reader is a Reader for the GetAWSAccountsMixin0 structure.
type GetAWSAccountsMixin0Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetAWSAccountsMixin0Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetAWSAccountsMixin0OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 207:
		result := NewGetAWSAccountsMixin0MultiStatus()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetAWSAccountsMixin0BadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetAWSAccountsMixin0Forbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetAWSAccountsMixin0TooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetAWSAccountsMixin0InternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /kubernetes-protection/entities/accounts/aws/v1] GetAWSAccountsMixin0", response, response.Code())
	}
}

// NewGetAWSAccountsMixin0OK creates a GetAWSAccountsMixin0OK with default headers values
func NewGetAWSAccountsMixin0OK() *GetAWSAccountsMixin0OK {
	return &GetAWSAccountsMixin0OK{}
}

/*
GetAWSAccountsMixin0OK describes a response with status code 200, with default header values.

OK
*/
type GetAWSAccountsMixin0OK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.K8sregGetAWSAccountsResp
}

// IsSuccess returns true when this get a w s accounts mixin0 o k response has a 2xx status code
func (o *GetAWSAccountsMixin0OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get a w s accounts mixin0 o k response has a 3xx status code
func (o *GetAWSAccountsMixin0OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get a w s accounts mixin0 o k response has a 4xx status code
func (o *GetAWSAccountsMixin0OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get a w s accounts mixin0 o k response has a 5xx status code
func (o *GetAWSAccountsMixin0OK) IsServerError() bool {
	return false
}

// IsCode returns true when this get a w s accounts mixin0 o k response a status code equal to that given
func (o *GetAWSAccountsMixin0OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get a w s accounts mixin0 o k response
func (o *GetAWSAccountsMixin0OK) Code() int {
	return 200
}

func (o *GetAWSAccountsMixin0OK) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/accounts/aws/v1][%d] getAWSAccountsMixin0OK  %+v", 200, o.Payload)
}

func (o *GetAWSAccountsMixin0OK) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/accounts/aws/v1][%d] getAWSAccountsMixin0OK  %+v", 200, o.Payload)
}

func (o *GetAWSAccountsMixin0OK) GetPayload() *models.K8sregGetAWSAccountsResp {
	return o.Payload
}

func (o *GetAWSAccountsMixin0OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.K8sregGetAWSAccountsResp)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAWSAccountsMixin0MultiStatus creates a GetAWSAccountsMixin0MultiStatus with default headers values
func NewGetAWSAccountsMixin0MultiStatus() *GetAWSAccountsMixin0MultiStatus {
	return &GetAWSAccountsMixin0MultiStatus{}
}

/*
GetAWSAccountsMixin0MultiStatus describes a response with status code 207, with default header values.

Multi-Status
*/
type GetAWSAccountsMixin0MultiStatus struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.K8sregGetAWSAccountsResp
}

// IsSuccess returns true when this get a w s accounts mixin0 multi status response has a 2xx status code
func (o *GetAWSAccountsMixin0MultiStatus) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get a w s accounts mixin0 multi status response has a 3xx status code
func (o *GetAWSAccountsMixin0MultiStatus) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get a w s accounts mixin0 multi status response has a 4xx status code
func (o *GetAWSAccountsMixin0MultiStatus) IsClientError() bool {
	return false
}

// IsServerError returns true when this get a w s accounts mixin0 multi status response has a 5xx status code
func (o *GetAWSAccountsMixin0MultiStatus) IsServerError() bool {
	return false
}

// IsCode returns true when this get a w s accounts mixin0 multi status response a status code equal to that given
func (o *GetAWSAccountsMixin0MultiStatus) IsCode(code int) bool {
	return code == 207
}

// Code gets the status code for the get a w s accounts mixin0 multi status response
func (o *GetAWSAccountsMixin0MultiStatus) Code() int {
	return 207
}

func (o *GetAWSAccountsMixin0MultiStatus) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/accounts/aws/v1][%d] getAWSAccountsMixin0MultiStatus  %+v", 207, o.Payload)
}

func (o *GetAWSAccountsMixin0MultiStatus) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/accounts/aws/v1][%d] getAWSAccountsMixin0MultiStatus  %+v", 207, o.Payload)
}

func (o *GetAWSAccountsMixin0MultiStatus) GetPayload() *models.K8sregGetAWSAccountsResp {
	return o.Payload
}

func (o *GetAWSAccountsMixin0MultiStatus) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.K8sregGetAWSAccountsResp)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAWSAccountsMixin0BadRequest creates a GetAWSAccountsMixin0BadRequest with default headers values
func NewGetAWSAccountsMixin0BadRequest() *GetAWSAccountsMixin0BadRequest {
	return &GetAWSAccountsMixin0BadRequest{}
}

/*
GetAWSAccountsMixin0BadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetAWSAccountsMixin0BadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.K8sregGetAWSAccountsResp
}

// IsSuccess returns true when this get a w s accounts mixin0 bad request response has a 2xx status code
func (o *GetAWSAccountsMixin0BadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get a w s accounts mixin0 bad request response has a 3xx status code
func (o *GetAWSAccountsMixin0BadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get a w s accounts mixin0 bad request response has a 4xx status code
func (o *GetAWSAccountsMixin0BadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get a w s accounts mixin0 bad request response has a 5xx status code
func (o *GetAWSAccountsMixin0BadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get a w s accounts mixin0 bad request response a status code equal to that given
func (o *GetAWSAccountsMixin0BadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get a w s accounts mixin0 bad request response
func (o *GetAWSAccountsMixin0BadRequest) Code() int {
	return 400
}

func (o *GetAWSAccountsMixin0BadRequest) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/accounts/aws/v1][%d] getAWSAccountsMixin0BadRequest  %+v", 400, o.Payload)
}

func (o *GetAWSAccountsMixin0BadRequest) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/accounts/aws/v1][%d] getAWSAccountsMixin0BadRequest  %+v", 400, o.Payload)
}

func (o *GetAWSAccountsMixin0BadRequest) GetPayload() *models.K8sregGetAWSAccountsResp {
	return o.Payload
}

func (o *GetAWSAccountsMixin0BadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.K8sregGetAWSAccountsResp)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAWSAccountsMixin0Forbidden creates a GetAWSAccountsMixin0Forbidden with default headers values
func NewGetAWSAccountsMixin0Forbidden() *GetAWSAccountsMixin0Forbidden {
	return &GetAWSAccountsMixin0Forbidden{}
}

/*
GetAWSAccountsMixin0Forbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetAWSAccountsMixin0Forbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get a w s accounts mixin0 forbidden response has a 2xx status code
func (o *GetAWSAccountsMixin0Forbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get a w s accounts mixin0 forbidden response has a 3xx status code
func (o *GetAWSAccountsMixin0Forbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get a w s accounts mixin0 forbidden response has a 4xx status code
func (o *GetAWSAccountsMixin0Forbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get a w s accounts mixin0 forbidden response has a 5xx status code
func (o *GetAWSAccountsMixin0Forbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get a w s accounts mixin0 forbidden response a status code equal to that given
func (o *GetAWSAccountsMixin0Forbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get a w s accounts mixin0 forbidden response
func (o *GetAWSAccountsMixin0Forbidden) Code() int {
	return 403
}

func (o *GetAWSAccountsMixin0Forbidden) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/accounts/aws/v1][%d] getAWSAccountsMixin0Forbidden  %+v", 403, o.Payload)
}

func (o *GetAWSAccountsMixin0Forbidden) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/accounts/aws/v1][%d] getAWSAccountsMixin0Forbidden  %+v", 403, o.Payload)
}

func (o *GetAWSAccountsMixin0Forbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetAWSAccountsMixin0Forbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAWSAccountsMixin0TooManyRequests creates a GetAWSAccountsMixin0TooManyRequests with default headers values
func NewGetAWSAccountsMixin0TooManyRequests() *GetAWSAccountsMixin0TooManyRequests {
	return &GetAWSAccountsMixin0TooManyRequests{}
}

/*
GetAWSAccountsMixin0TooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetAWSAccountsMixin0TooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get a w s accounts mixin0 too many requests response has a 2xx status code
func (o *GetAWSAccountsMixin0TooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get a w s accounts mixin0 too many requests response has a 3xx status code
func (o *GetAWSAccountsMixin0TooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get a w s accounts mixin0 too many requests response has a 4xx status code
func (o *GetAWSAccountsMixin0TooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get a w s accounts mixin0 too many requests response has a 5xx status code
func (o *GetAWSAccountsMixin0TooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get a w s accounts mixin0 too many requests response a status code equal to that given
func (o *GetAWSAccountsMixin0TooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get a w s accounts mixin0 too many requests response
func (o *GetAWSAccountsMixin0TooManyRequests) Code() int {
	return 429
}

func (o *GetAWSAccountsMixin0TooManyRequests) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/accounts/aws/v1][%d] getAWSAccountsMixin0TooManyRequests  %+v", 429, o.Payload)
}

func (o *GetAWSAccountsMixin0TooManyRequests) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/accounts/aws/v1][%d] getAWSAccountsMixin0TooManyRequests  %+v", 429, o.Payload)
}

func (o *GetAWSAccountsMixin0TooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetAWSAccountsMixin0TooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAWSAccountsMixin0InternalServerError creates a GetAWSAccountsMixin0InternalServerError with default headers values
func NewGetAWSAccountsMixin0InternalServerError() *GetAWSAccountsMixin0InternalServerError {
	return &GetAWSAccountsMixin0InternalServerError{}
}

/*
GetAWSAccountsMixin0InternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetAWSAccountsMixin0InternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.K8sregGetAWSAccountsResp
}

// IsSuccess returns true when this get a w s accounts mixin0 internal server error response has a 2xx status code
func (o *GetAWSAccountsMixin0InternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get a w s accounts mixin0 internal server error response has a 3xx status code
func (o *GetAWSAccountsMixin0InternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get a w s accounts mixin0 internal server error response has a 4xx status code
func (o *GetAWSAccountsMixin0InternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get a w s accounts mixin0 internal server error response has a 5xx status code
func (o *GetAWSAccountsMixin0InternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get a w s accounts mixin0 internal server error response a status code equal to that given
func (o *GetAWSAccountsMixin0InternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get a w s accounts mixin0 internal server error response
func (o *GetAWSAccountsMixin0InternalServerError) Code() int {
	return 500
}

func (o *GetAWSAccountsMixin0InternalServerError) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/accounts/aws/v1][%d] getAWSAccountsMixin0InternalServerError  %+v", 500, o.Payload)
}

func (o *GetAWSAccountsMixin0InternalServerError) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/accounts/aws/v1][%d] getAWSAccountsMixin0InternalServerError  %+v", 500, o.Payload)
}

func (o *GetAWSAccountsMixin0InternalServerError) GetPayload() *models.K8sregGetAWSAccountsResp {
	return o.Payload
}

func (o *GetAWSAccountsMixin0InternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.K8sregGetAWSAccountsResp)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
