// Code generated by go-swagger; DO NOT EDIT.

package kubernetes_protection

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetAzureInstallScriptReader is a Reader for the GetAzureInstallScript structure.
type GetAzureInstallScriptReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetAzureInstallScriptReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetAzureInstallScriptOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 207:
		result := NewGetAzureInstallScriptMultiStatus()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetAzureInstallScriptBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetAzureInstallScriptForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetAzureInstallScriptTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetAzureInstallScriptInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /kubernetes-protection/entities/user-script/azure/v1] GetAzureInstallScript", response, response.Code())
	}
}

// NewGetAzureInstallScriptOK creates a GetAzureInstallScriptOK with default headers values
func NewGetAzureInstallScriptOK() *GetAzureInstallScriptOK {
	return &GetAzureInstallScriptOK{}
}

/*
GetAzureInstallScriptOK describes a response with status code 200, with default header values.

OK
*/
type GetAzureInstallScriptOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.K8sregGetAzureBashScriptResp
}

// IsSuccess returns true when this get azure install script o k response has a 2xx status code
func (o *GetAzureInstallScriptOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get azure install script o k response has a 3xx status code
func (o *GetAzureInstallScriptOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get azure install script o k response has a 4xx status code
func (o *GetAzureInstallScriptOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get azure install script o k response has a 5xx status code
func (o *GetAzureInstallScriptOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get azure install script o k response a status code equal to that given
func (o *GetAzureInstallScriptOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get azure install script o k response
func (o *GetAzureInstallScriptOK) Code() int {
	return 200
}

func (o *GetAzureInstallScriptOK) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/user-script/azure/v1][%d] getAzureInstallScriptOK  %+v", 200, o.Payload)
}

func (o *GetAzureInstallScriptOK) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/user-script/azure/v1][%d] getAzureInstallScriptOK  %+v", 200, o.Payload)
}

func (o *GetAzureInstallScriptOK) GetPayload() *models.K8sregGetAzureBashScriptResp {
	return o.Payload
}

func (o *GetAzureInstallScriptOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.K8sregGetAzureBashScriptResp)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAzureInstallScriptMultiStatus creates a GetAzureInstallScriptMultiStatus with default headers values
func NewGetAzureInstallScriptMultiStatus() *GetAzureInstallScriptMultiStatus {
	return &GetAzureInstallScriptMultiStatus{}
}

/*
GetAzureInstallScriptMultiStatus describes a response with status code 207, with default header values.

Multi-Status
*/
type GetAzureInstallScriptMultiStatus struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.K8sregGetAzureBashScriptResp
}

// IsSuccess returns true when this get azure install script multi status response has a 2xx status code
func (o *GetAzureInstallScriptMultiStatus) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get azure install script multi status response has a 3xx status code
func (o *GetAzureInstallScriptMultiStatus) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get azure install script multi status response has a 4xx status code
func (o *GetAzureInstallScriptMultiStatus) IsClientError() bool {
	return false
}

// IsServerError returns true when this get azure install script multi status response has a 5xx status code
func (o *GetAzureInstallScriptMultiStatus) IsServerError() bool {
	return false
}

// IsCode returns true when this get azure install script multi status response a status code equal to that given
func (o *GetAzureInstallScriptMultiStatus) IsCode(code int) bool {
	return code == 207
}

// Code gets the status code for the get azure install script multi status response
func (o *GetAzureInstallScriptMultiStatus) Code() int {
	return 207
}

func (o *GetAzureInstallScriptMultiStatus) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/user-script/azure/v1][%d] getAzureInstallScriptMultiStatus  %+v", 207, o.Payload)
}

func (o *GetAzureInstallScriptMultiStatus) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/user-script/azure/v1][%d] getAzureInstallScriptMultiStatus  %+v", 207, o.Payload)
}

func (o *GetAzureInstallScriptMultiStatus) GetPayload() *models.K8sregGetAzureBashScriptResp {
	return o.Payload
}

func (o *GetAzureInstallScriptMultiStatus) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.K8sregGetAzureBashScriptResp)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAzureInstallScriptBadRequest creates a GetAzureInstallScriptBadRequest with default headers values
func NewGetAzureInstallScriptBadRequest() *GetAzureInstallScriptBadRequest {
	return &GetAzureInstallScriptBadRequest{}
}

/*
GetAzureInstallScriptBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetAzureInstallScriptBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.K8sregGetAzureBashScriptResp
}

// IsSuccess returns true when this get azure install script bad request response has a 2xx status code
func (o *GetAzureInstallScriptBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get azure install script bad request response has a 3xx status code
func (o *GetAzureInstallScriptBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get azure install script bad request response has a 4xx status code
func (o *GetAzureInstallScriptBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get azure install script bad request response has a 5xx status code
func (o *GetAzureInstallScriptBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get azure install script bad request response a status code equal to that given
func (o *GetAzureInstallScriptBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get azure install script bad request response
func (o *GetAzureInstallScriptBadRequest) Code() int {
	return 400
}

func (o *GetAzureInstallScriptBadRequest) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/user-script/azure/v1][%d] getAzureInstallScriptBadRequest  %+v", 400, o.Payload)
}

func (o *GetAzureInstallScriptBadRequest) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/user-script/azure/v1][%d] getAzureInstallScriptBadRequest  %+v", 400, o.Payload)
}

func (o *GetAzureInstallScriptBadRequest) GetPayload() *models.K8sregGetAzureBashScriptResp {
	return o.Payload
}

func (o *GetAzureInstallScriptBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.K8sregGetAzureBashScriptResp)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAzureInstallScriptForbidden creates a GetAzureInstallScriptForbidden with default headers values
func NewGetAzureInstallScriptForbidden() *GetAzureInstallScriptForbidden {
	return &GetAzureInstallScriptForbidden{}
}

/*
GetAzureInstallScriptForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetAzureInstallScriptForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get azure install script forbidden response has a 2xx status code
func (o *GetAzureInstallScriptForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get azure install script forbidden response has a 3xx status code
func (o *GetAzureInstallScriptForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get azure install script forbidden response has a 4xx status code
func (o *GetAzureInstallScriptForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get azure install script forbidden response has a 5xx status code
func (o *GetAzureInstallScriptForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get azure install script forbidden response a status code equal to that given
func (o *GetAzureInstallScriptForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get azure install script forbidden response
func (o *GetAzureInstallScriptForbidden) Code() int {
	return 403
}

func (o *GetAzureInstallScriptForbidden) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/user-script/azure/v1][%d] getAzureInstallScriptForbidden  %+v", 403, o.Payload)
}

func (o *GetAzureInstallScriptForbidden) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/user-script/azure/v1][%d] getAzureInstallScriptForbidden  %+v", 403, o.Payload)
}

func (o *GetAzureInstallScriptForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetAzureInstallScriptForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAzureInstallScriptTooManyRequests creates a GetAzureInstallScriptTooManyRequests with default headers values
func NewGetAzureInstallScriptTooManyRequests() *GetAzureInstallScriptTooManyRequests {
	return &GetAzureInstallScriptTooManyRequests{}
}

/*
GetAzureInstallScriptTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetAzureInstallScriptTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get azure install script too many requests response has a 2xx status code
func (o *GetAzureInstallScriptTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get azure install script too many requests response has a 3xx status code
func (o *GetAzureInstallScriptTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get azure install script too many requests response has a 4xx status code
func (o *GetAzureInstallScriptTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get azure install script too many requests response has a 5xx status code
func (o *GetAzureInstallScriptTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get azure install script too many requests response a status code equal to that given
func (o *GetAzureInstallScriptTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get azure install script too many requests response
func (o *GetAzureInstallScriptTooManyRequests) Code() int {
	return 429
}

func (o *GetAzureInstallScriptTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/user-script/azure/v1][%d] getAzureInstallScriptTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetAzureInstallScriptTooManyRequests) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/user-script/azure/v1][%d] getAzureInstallScriptTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetAzureInstallScriptTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetAzureInstallScriptTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAzureInstallScriptInternalServerError creates a GetAzureInstallScriptInternalServerError with default headers values
func NewGetAzureInstallScriptInternalServerError() *GetAzureInstallScriptInternalServerError {
	return &GetAzureInstallScriptInternalServerError{}
}

/*
GetAzureInstallScriptInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetAzureInstallScriptInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.K8sregGetAzureBashScriptResp
}

// IsSuccess returns true when this get azure install script internal server error response has a 2xx status code
func (o *GetAzureInstallScriptInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get azure install script internal server error response has a 3xx status code
func (o *GetAzureInstallScriptInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get azure install script internal server error response has a 4xx status code
func (o *GetAzureInstallScriptInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get azure install script internal server error response has a 5xx status code
func (o *GetAzureInstallScriptInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get azure install script internal server error response a status code equal to that given
func (o *GetAzureInstallScriptInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get azure install script internal server error response
func (o *GetAzureInstallScriptInternalServerError) Code() int {
	return 500
}

func (o *GetAzureInstallScriptInternalServerError) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/user-script/azure/v1][%d] getAzureInstallScriptInternalServerError  %+v", 500, o.Payload)
}

func (o *GetAzureInstallScriptInternalServerError) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/user-script/azure/v1][%d] getAzureInstallScriptInternalServerError  %+v", 500, o.Payload)
}

func (o *GetAzureInstallScriptInternalServerError) GetPayload() *models.K8sregGetAzureBashScriptResp {
	return o.Payload
}

func (o *GetAzureInstallScriptInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.K8sregGetAzureBashScriptResp)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
