// Code generated by go-swagger; DO NOT EDIT.

package kubernetes_protection

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetAzureTenantIDsParams creates a new GetAzureTenantIDsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetAzureTenantIDsParams() *GetAzureTenantIDsParams {
	return &GetAzureTenantIDsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetAzureTenantIDsParamsWithTimeout creates a new GetAzureTenantIDsParams object
// with the ability to set a timeout on a request.
func NewGetAzureTenantIDsParamsWithTimeout(timeout time.Duration) *GetAzureTenantIDsParams {
	return &GetAzureTenantIDsParams{
		timeout: timeout,
	}
}

// NewGetAzureTenantIDsParamsWithContext creates a new GetAzureTenantIDsParams object
// with the ability to set a context for a request.
func NewGetAzureTenantIDsParamsWithContext(ctx context.Context) *GetAzureTenantIDsParams {
	return &GetAzureTenantIDsParams{
		Context: ctx,
	}
}

// NewGetAzureTenantIDsParamsWithHTTPClient creates a new GetAzureTenantIDsParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetAzureTenantIDsParamsWithHTTPClient(client *http.Client) *GetAzureTenantIDsParams {
	return &GetAzureTenantIDsParams{
		HTTPClient: client,
	}
}

/*
GetAzureTenantIDsParams contains all the parameters to send to the API endpoint

	for the get azure tenant i ds operation.

	Typically these are written to a http.Request.
*/
type GetAzureTenantIDsParams struct {

	/* Ids.

	   Azure Tenant IDs
	*/
	Ids []string

	/* Limit.

	   Limit returned accounts
	*/
	Limit *int64

	/* Offset.

	   Offset returned accounts
	*/
	Offset *int64

	/* Status.

	   Cluster Status
	*/
	Status *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get azure tenant i ds params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetAzureTenantIDsParams) WithDefaults() *GetAzureTenantIDsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get azure tenant i ds params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetAzureTenantIDsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get azure tenant i ds params
func (o *GetAzureTenantIDsParams) WithTimeout(timeout time.Duration) *GetAzureTenantIDsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get azure tenant i ds params
func (o *GetAzureTenantIDsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get azure tenant i ds params
func (o *GetAzureTenantIDsParams) WithContext(ctx context.Context) *GetAzureTenantIDsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get azure tenant i ds params
func (o *GetAzureTenantIDsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get azure tenant i ds params
func (o *GetAzureTenantIDsParams) WithHTTPClient(client *http.Client) *GetAzureTenantIDsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get azure tenant i ds params
func (o *GetAzureTenantIDsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the get azure tenant i ds params
func (o *GetAzureTenantIDsParams) WithIds(ids []string) *GetAzureTenantIDsParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the get azure tenant i ds params
func (o *GetAzureTenantIDsParams) SetIds(ids []string) {
	o.Ids = ids
}

// WithLimit adds the limit to the get azure tenant i ds params
func (o *GetAzureTenantIDsParams) WithLimit(limit *int64) *GetAzureTenantIDsParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the get azure tenant i ds params
func (o *GetAzureTenantIDsParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithOffset adds the offset to the get azure tenant i ds params
func (o *GetAzureTenantIDsParams) WithOffset(offset *int64) *GetAzureTenantIDsParams {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the get azure tenant i ds params
func (o *GetAzureTenantIDsParams) SetOffset(offset *int64) {
	o.Offset = offset
}

// WithStatus adds the status to the get azure tenant i ds params
func (o *GetAzureTenantIDsParams) WithStatus(status *string) *GetAzureTenantIDsParams {
	o.SetStatus(status)
	return o
}

// SetStatus adds the status to the get azure tenant i ds params
func (o *GetAzureTenantIDsParams) SetStatus(status *string) {
	o.Status = status
}

// WriteToRequest writes these params to a swagger request
func (o *GetAzureTenantIDsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset int64

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := swag.FormatInt64(qrOffset)
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if o.Status != nil {

		// query param status
		var qrStatus string

		if o.Status != nil {
			qrStatus = *o.Status
		}
		qStatus := qrStatus
		if qStatus != "" {

			if err := r.SetQueryParam("status", qStatus); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGetAzureTenantIDs binds the parameter ids
func (o *GetAzureTenantIDsParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "csv"
	idsIS := swag.JoinByFormat(idsIC, "csv")

	return idsIS
}
