// Code generated by go-swagger; DO NOT EDIT.

package kubernetes_protection

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetAzureTenantIDsReader is a Reader for the GetAzureTenantIDs structure.
type GetAzureTenantIDsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetAzureTenantIDsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetAzureTenantIDsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 207:
		result := NewGetAzureTenantIDsMultiStatus()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetAzureTenantIDsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetAzureTenantIDsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetAzureTenantIDsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetAzureTenantIDsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /kubernetes-protection/entities/tenants/azure/v1] GetAzureTenantIDs", response, response.Code())
	}
}

// NewGetAzureTenantIDsOK creates a GetAzureTenantIDsOK with default headers values
func NewGetAzureTenantIDsOK() *GetAzureTenantIDsOK {
	return &GetAzureTenantIDsOK{}
}

/*
GetAzureTenantIDsOK describes a response with status code 200, with default header values.

OK
*/
type GetAzureTenantIDsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.K8sregGetAzureTenantInfoResp
}

// IsSuccess returns true when this get azure tenant i ds o k response has a 2xx status code
func (o *GetAzureTenantIDsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get azure tenant i ds o k response has a 3xx status code
func (o *GetAzureTenantIDsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get azure tenant i ds o k response has a 4xx status code
func (o *GetAzureTenantIDsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get azure tenant i ds o k response has a 5xx status code
func (o *GetAzureTenantIDsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get azure tenant i ds o k response a status code equal to that given
func (o *GetAzureTenantIDsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get azure tenant i ds o k response
func (o *GetAzureTenantIDsOK) Code() int {
	return 200
}

func (o *GetAzureTenantIDsOK) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/tenants/azure/v1][%d] getAzureTenantIDsOK  %+v", 200, o.Payload)
}

func (o *GetAzureTenantIDsOK) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/tenants/azure/v1][%d] getAzureTenantIDsOK  %+v", 200, o.Payload)
}

func (o *GetAzureTenantIDsOK) GetPayload() *models.K8sregGetAzureTenantInfoResp {
	return o.Payload
}

func (o *GetAzureTenantIDsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.K8sregGetAzureTenantInfoResp)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAzureTenantIDsMultiStatus creates a GetAzureTenantIDsMultiStatus with default headers values
func NewGetAzureTenantIDsMultiStatus() *GetAzureTenantIDsMultiStatus {
	return &GetAzureTenantIDsMultiStatus{}
}

/*
GetAzureTenantIDsMultiStatus describes a response with status code 207, with default header values.

Multi-Status
*/
type GetAzureTenantIDsMultiStatus struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.K8sregGetAzureTenantInfoResp
}

// IsSuccess returns true when this get azure tenant i ds multi status response has a 2xx status code
func (o *GetAzureTenantIDsMultiStatus) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get azure tenant i ds multi status response has a 3xx status code
func (o *GetAzureTenantIDsMultiStatus) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get azure tenant i ds multi status response has a 4xx status code
func (o *GetAzureTenantIDsMultiStatus) IsClientError() bool {
	return false
}

// IsServerError returns true when this get azure tenant i ds multi status response has a 5xx status code
func (o *GetAzureTenantIDsMultiStatus) IsServerError() bool {
	return false
}

// IsCode returns true when this get azure tenant i ds multi status response a status code equal to that given
func (o *GetAzureTenantIDsMultiStatus) IsCode(code int) bool {
	return code == 207
}

// Code gets the status code for the get azure tenant i ds multi status response
func (o *GetAzureTenantIDsMultiStatus) Code() int {
	return 207
}

func (o *GetAzureTenantIDsMultiStatus) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/tenants/azure/v1][%d] getAzureTenantIDsMultiStatus  %+v", 207, o.Payload)
}

func (o *GetAzureTenantIDsMultiStatus) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/tenants/azure/v1][%d] getAzureTenantIDsMultiStatus  %+v", 207, o.Payload)
}

func (o *GetAzureTenantIDsMultiStatus) GetPayload() *models.K8sregGetAzureTenantInfoResp {
	return o.Payload
}

func (o *GetAzureTenantIDsMultiStatus) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.K8sregGetAzureTenantInfoResp)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAzureTenantIDsBadRequest creates a GetAzureTenantIDsBadRequest with default headers values
func NewGetAzureTenantIDsBadRequest() *GetAzureTenantIDsBadRequest {
	return &GetAzureTenantIDsBadRequest{}
}

/*
GetAzureTenantIDsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetAzureTenantIDsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.K8sregGetAzureTenantInfoResp
}

// IsSuccess returns true when this get azure tenant i ds bad request response has a 2xx status code
func (o *GetAzureTenantIDsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get azure tenant i ds bad request response has a 3xx status code
func (o *GetAzureTenantIDsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get azure tenant i ds bad request response has a 4xx status code
func (o *GetAzureTenantIDsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get azure tenant i ds bad request response has a 5xx status code
func (o *GetAzureTenantIDsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get azure tenant i ds bad request response a status code equal to that given
func (o *GetAzureTenantIDsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get azure tenant i ds bad request response
func (o *GetAzureTenantIDsBadRequest) Code() int {
	return 400
}

func (o *GetAzureTenantIDsBadRequest) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/tenants/azure/v1][%d] getAzureTenantIDsBadRequest  %+v", 400, o.Payload)
}

func (o *GetAzureTenantIDsBadRequest) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/tenants/azure/v1][%d] getAzureTenantIDsBadRequest  %+v", 400, o.Payload)
}

func (o *GetAzureTenantIDsBadRequest) GetPayload() *models.K8sregGetAzureTenantInfoResp {
	return o.Payload
}

func (o *GetAzureTenantIDsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.K8sregGetAzureTenantInfoResp)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAzureTenantIDsForbidden creates a GetAzureTenantIDsForbidden with default headers values
func NewGetAzureTenantIDsForbidden() *GetAzureTenantIDsForbidden {
	return &GetAzureTenantIDsForbidden{}
}

/*
GetAzureTenantIDsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetAzureTenantIDsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get azure tenant i ds forbidden response has a 2xx status code
func (o *GetAzureTenantIDsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get azure tenant i ds forbidden response has a 3xx status code
func (o *GetAzureTenantIDsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get azure tenant i ds forbidden response has a 4xx status code
func (o *GetAzureTenantIDsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get azure tenant i ds forbidden response has a 5xx status code
func (o *GetAzureTenantIDsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get azure tenant i ds forbidden response a status code equal to that given
func (o *GetAzureTenantIDsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get azure tenant i ds forbidden response
func (o *GetAzureTenantIDsForbidden) Code() int {
	return 403
}

func (o *GetAzureTenantIDsForbidden) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/tenants/azure/v1][%d] getAzureTenantIDsForbidden  %+v", 403, o.Payload)
}

func (o *GetAzureTenantIDsForbidden) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/tenants/azure/v1][%d] getAzureTenantIDsForbidden  %+v", 403, o.Payload)
}

func (o *GetAzureTenantIDsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetAzureTenantIDsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAzureTenantIDsTooManyRequests creates a GetAzureTenantIDsTooManyRequests with default headers values
func NewGetAzureTenantIDsTooManyRequests() *GetAzureTenantIDsTooManyRequests {
	return &GetAzureTenantIDsTooManyRequests{}
}

/*
GetAzureTenantIDsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetAzureTenantIDsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get azure tenant i ds too many requests response has a 2xx status code
func (o *GetAzureTenantIDsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get azure tenant i ds too many requests response has a 3xx status code
func (o *GetAzureTenantIDsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get azure tenant i ds too many requests response has a 4xx status code
func (o *GetAzureTenantIDsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get azure tenant i ds too many requests response has a 5xx status code
func (o *GetAzureTenantIDsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get azure tenant i ds too many requests response a status code equal to that given
func (o *GetAzureTenantIDsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get azure tenant i ds too many requests response
func (o *GetAzureTenantIDsTooManyRequests) Code() int {
	return 429
}

func (o *GetAzureTenantIDsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/tenants/azure/v1][%d] getAzureTenantIDsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetAzureTenantIDsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/tenants/azure/v1][%d] getAzureTenantIDsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetAzureTenantIDsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetAzureTenantIDsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAzureTenantIDsInternalServerError creates a GetAzureTenantIDsInternalServerError with default headers values
func NewGetAzureTenantIDsInternalServerError() *GetAzureTenantIDsInternalServerError {
	return &GetAzureTenantIDsInternalServerError{}
}

/*
GetAzureTenantIDsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetAzureTenantIDsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.K8sregGetAzureTenantInfoResp
}

// IsSuccess returns true when this get azure tenant i ds internal server error response has a 2xx status code
func (o *GetAzureTenantIDsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get azure tenant i ds internal server error response has a 3xx status code
func (o *GetAzureTenantIDsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get azure tenant i ds internal server error response has a 4xx status code
func (o *GetAzureTenantIDsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get azure tenant i ds internal server error response has a 5xx status code
func (o *GetAzureTenantIDsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get azure tenant i ds internal server error response a status code equal to that given
func (o *GetAzureTenantIDsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get azure tenant i ds internal server error response
func (o *GetAzureTenantIDsInternalServerError) Code() int {
	return 500
}

func (o *GetAzureTenantIDsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/tenants/azure/v1][%d] getAzureTenantIDsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetAzureTenantIDsInternalServerError) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/tenants/azure/v1][%d] getAzureTenantIDsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetAzureTenantIDsInternalServerError) GetPayload() *models.K8sregGetAzureTenantInfoResp {
	return o.Payload
}

func (o *GetAzureTenantIDsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.K8sregGetAzureTenantInfoResp)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
