// Code generated by go-swagger; DO NOT EDIT.

package kubernetes_protection

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetClustersReader is a Reader for the GetClusters structure.
type GetClustersReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetClustersReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetClustersOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 207:
		result := NewGetClustersMultiStatus()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetClustersBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetClustersForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetClustersTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetClustersInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /kubernetes-protection/entities/kubernetes/clusters/v1] GetClusters", response, response.Code())
	}
}

// NewGetClustersOK creates a GetClustersOK with default headers values
func NewGetClustersOK() *GetClustersOK {
	return &GetClustersOK{}
}

/*
GetClustersOK describes a response with status code 200, with default header values.

OK
*/
type GetClustersOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.K8sregGetClustersResp
}

// IsSuccess returns true when this get clusters o k response has a 2xx status code
func (o *GetClustersOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get clusters o k response has a 3xx status code
func (o *GetClustersOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get clusters o k response has a 4xx status code
func (o *GetClustersOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get clusters o k response has a 5xx status code
func (o *GetClustersOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get clusters o k response a status code equal to that given
func (o *GetClustersOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get clusters o k response
func (o *GetClustersOK) Code() int {
	return 200
}

func (o *GetClustersOK) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/kubernetes/clusters/v1][%d] getClustersOK  %+v", 200, o.Payload)
}

func (o *GetClustersOK) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/kubernetes/clusters/v1][%d] getClustersOK  %+v", 200, o.Payload)
}

func (o *GetClustersOK) GetPayload() *models.K8sregGetClustersResp {
	return o.Payload
}

func (o *GetClustersOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.K8sregGetClustersResp)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetClustersMultiStatus creates a GetClustersMultiStatus with default headers values
func NewGetClustersMultiStatus() *GetClustersMultiStatus {
	return &GetClustersMultiStatus{}
}

/*
GetClustersMultiStatus describes a response with status code 207, with default header values.

Multi-Status
*/
type GetClustersMultiStatus struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.K8sregGetClustersResp
}

// IsSuccess returns true when this get clusters multi status response has a 2xx status code
func (o *GetClustersMultiStatus) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get clusters multi status response has a 3xx status code
func (o *GetClustersMultiStatus) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get clusters multi status response has a 4xx status code
func (o *GetClustersMultiStatus) IsClientError() bool {
	return false
}

// IsServerError returns true when this get clusters multi status response has a 5xx status code
func (o *GetClustersMultiStatus) IsServerError() bool {
	return false
}

// IsCode returns true when this get clusters multi status response a status code equal to that given
func (o *GetClustersMultiStatus) IsCode(code int) bool {
	return code == 207
}

// Code gets the status code for the get clusters multi status response
func (o *GetClustersMultiStatus) Code() int {
	return 207
}

func (o *GetClustersMultiStatus) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/kubernetes/clusters/v1][%d] getClustersMultiStatus  %+v", 207, o.Payload)
}

func (o *GetClustersMultiStatus) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/kubernetes/clusters/v1][%d] getClustersMultiStatus  %+v", 207, o.Payload)
}

func (o *GetClustersMultiStatus) GetPayload() *models.K8sregGetClustersResp {
	return o.Payload
}

func (o *GetClustersMultiStatus) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.K8sregGetClustersResp)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetClustersBadRequest creates a GetClustersBadRequest with default headers values
func NewGetClustersBadRequest() *GetClustersBadRequest {
	return &GetClustersBadRequest{}
}

/*
GetClustersBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetClustersBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.K8sregGetClustersResp
}

// IsSuccess returns true when this get clusters bad request response has a 2xx status code
func (o *GetClustersBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get clusters bad request response has a 3xx status code
func (o *GetClustersBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get clusters bad request response has a 4xx status code
func (o *GetClustersBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get clusters bad request response has a 5xx status code
func (o *GetClustersBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get clusters bad request response a status code equal to that given
func (o *GetClustersBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get clusters bad request response
func (o *GetClustersBadRequest) Code() int {
	return 400
}

func (o *GetClustersBadRequest) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/kubernetes/clusters/v1][%d] getClustersBadRequest  %+v", 400, o.Payload)
}

func (o *GetClustersBadRequest) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/kubernetes/clusters/v1][%d] getClustersBadRequest  %+v", 400, o.Payload)
}

func (o *GetClustersBadRequest) GetPayload() *models.K8sregGetClustersResp {
	return o.Payload
}

func (o *GetClustersBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.K8sregGetClustersResp)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetClustersForbidden creates a GetClustersForbidden with default headers values
func NewGetClustersForbidden() *GetClustersForbidden {
	return &GetClustersForbidden{}
}

/*
GetClustersForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetClustersForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get clusters forbidden response has a 2xx status code
func (o *GetClustersForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get clusters forbidden response has a 3xx status code
func (o *GetClustersForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get clusters forbidden response has a 4xx status code
func (o *GetClustersForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get clusters forbidden response has a 5xx status code
func (o *GetClustersForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get clusters forbidden response a status code equal to that given
func (o *GetClustersForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get clusters forbidden response
func (o *GetClustersForbidden) Code() int {
	return 403
}

func (o *GetClustersForbidden) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/kubernetes/clusters/v1][%d] getClustersForbidden  %+v", 403, o.Payload)
}

func (o *GetClustersForbidden) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/kubernetes/clusters/v1][%d] getClustersForbidden  %+v", 403, o.Payload)
}

func (o *GetClustersForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetClustersForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetClustersTooManyRequests creates a GetClustersTooManyRequests with default headers values
func NewGetClustersTooManyRequests() *GetClustersTooManyRequests {
	return &GetClustersTooManyRequests{}
}

/*
GetClustersTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetClustersTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get clusters too many requests response has a 2xx status code
func (o *GetClustersTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get clusters too many requests response has a 3xx status code
func (o *GetClustersTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get clusters too many requests response has a 4xx status code
func (o *GetClustersTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get clusters too many requests response has a 5xx status code
func (o *GetClustersTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get clusters too many requests response a status code equal to that given
func (o *GetClustersTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get clusters too many requests response
func (o *GetClustersTooManyRequests) Code() int {
	return 429
}

func (o *GetClustersTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/kubernetes/clusters/v1][%d] getClustersTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetClustersTooManyRequests) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/kubernetes/clusters/v1][%d] getClustersTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetClustersTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetClustersTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetClustersInternalServerError creates a GetClustersInternalServerError with default headers values
func NewGetClustersInternalServerError() *GetClustersInternalServerError {
	return &GetClustersInternalServerError{}
}

/*
GetClustersInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetClustersInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.K8sregGetClustersResp
}

// IsSuccess returns true when this get clusters internal server error response has a 2xx status code
func (o *GetClustersInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get clusters internal server error response has a 3xx status code
func (o *GetClustersInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get clusters internal server error response has a 4xx status code
func (o *GetClustersInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get clusters internal server error response has a 5xx status code
func (o *GetClustersInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get clusters internal server error response a status code equal to that given
func (o *GetClustersInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get clusters internal server error response
func (o *GetClustersInternalServerError) Code() int {
	return 500
}

func (o *GetClustersInternalServerError) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/kubernetes/clusters/v1][%d] getClustersInternalServerError  %+v", 500, o.Payload)
}

func (o *GetClustersInternalServerError) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/kubernetes/clusters/v1][%d] getClustersInternalServerError  %+v", 500, o.Payload)
}

func (o *GetClustersInternalServerError) GetPayload() *models.K8sregGetClustersResp {
	return o.Payload
}

func (o *GetClustersInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.K8sregGetClustersResp)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
