// Code generated by go-swagger; DO NOT EDIT.

package kubernetes_protection

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetCombinedCloudClustersParams creates a new GetCombinedCloudClustersParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetCombinedCloudClustersParams() *GetCombinedCloudClustersParams {
	return &GetCombinedCloudClustersParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetCombinedCloudClustersParamsWithTimeout creates a new GetCombinedCloudClustersParams object
// with the ability to set a timeout on a request.
func NewGetCombinedCloudClustersParamsWithTimeout(timeout time.Duration) *GetCombinedCloudClustersParams {
	return &GetCombinedCloudClustersParams{
		timeout: timeout,
	}
}

// NewGetCombinedCloudClustersParamsWithContext creates a new GetCombinedCloudClustersParams object
// with the ability to set a context for a request.
func NewGetCombinedCloudClustersParamsWithContext(ctx context.Context) *GetCombinedCloudClustersParams {
	return &GetCombinedCloudClustersParams{
		Context: ctx,
	}
}

// NewGetCombinedCloudClustersParamsWithHTTPClient creates a new GetCombinedCloudClustersParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetCombinedCloudClustersParamsWithHTTPClient(client *http.Client) *GetCombinedCloudClustersParams {
	return &GetCombinedCloudClustersParams{
		HTTPClient: client,
	}
}

/*
GetCombinedCloudClustersParams contains all the parameters to send to the API endpoint

	for the get combined cloud clusters operation.

	Typically these are written to a http.Request.
*/
type GetCombinedCloudClustersParams struct {

	/* ClusterService.

	   Cluster Service
	*/
	ClusterService []string

	/* ClusterStatus.

	   Cluster Status
	*/
	ClusterStatus []string

	/* Ids.

	   Cloud Account IDs
	*/
	Ids []string

	/* Limit.

	   Limit returned accounts
	*/
	Limit *int64

	/* Locations.

	   Cloud location
	*/
	Locations []string

	/* Offset.

	   Offset returned accounts
	*/
	Offset *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get combined cloud clusters params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetCombinedCloudClustersParams) WithDefaults() *GetCombinedCloudClustersParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get combined cloud clusters params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetCombinedCloudClustersParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get combined cloud clusters params
func (o *GetCombinedCloudClustersParams) WithTimeout(timeout time.Duration) *GetCombinedCloudClustersParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get combined cloud clusters params
func (o *GetCombinedCloudClustersParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get combined cloud clusters params
func (o *GetCombinedCloudClustersParams) WithContext(ctx context.Context) *GetCombinedCloudClustersParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get combined cloud clusters params
func (o *GetCombinedCloudClustersParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get combined cloud clusters params
func (o *GetCombinedCloudClustersParams) WithHTTPClient(client *http.Client) *GetCombinedCloudClustersParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get combined cloud clusters params
func (o *GetCombinedCloudClustersParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterService adds the clusterService to the get combined cloud clusters params
func (o *GetCombinedCloudClustersParams) WithClusterService(clusterService []string) *GetCombinedCloudClustersParams {
	o.SetClusterService(clusterService)
	return o
}

// SetClusterService adds the clusterService to the get combined cloud clusters params
func (o *GetCombinedCloudClustersParams) SetClusterService(clusterService []string) {
	o.ClusterService = clusterService
}

// WithClusterStatus adds the clusterStatus to the get combined cloud clusters params
func (o *GetCombinedCloudClustersParams) WithClusterStatus(clusterStatus []string) *GetCombinedCloudClustersParams {
	o.SetClusterStatus(clusterStatus)
	return o
}

// SetClusterStatus adds the clusterStatus to the get combined cloud clusters params
func (o *GetCombinedCloudClustersParams) SetClusterStatus(clusterStatus []string) {
	o.ClusterStatus = clusterStatus
}

// WithIds adds the ids to the get combined cloud clusters params
func (o *GetCombinedCloudClustersParams) WithIds(ids []string) *GetCombinedCloudClustersParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the get combined cloud clusters params
func (o *GetCombinedCloudClustersParams) SetIds(ids []string) {
	o.Ids = ids
}

// WithLimit adds the limit to the get combined cloud clusters params
func (o *GetCombinedCloudClustersParams) WithLimit(limit *int64) *GetCombinedCloudClustersParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the get combined cloud clusters params
func (o *GetCombinedCloudClustersParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithLocations adds the locations to the get combined cloud clusters params
func (o *GetCombinedCloudClustersParams) WithLocations(locations []string) *GetCombinedCloudClustersParams {
	o.SetLocations(locations)
	return o
}

// SetLocations adds the locations to the get combined cloud clusters params
func (o *GetCombinedCloudClustersParams) SetLocations(locations []string) {
	o.Locations = locations
}

// WithOffset adds the offset to the get combined cloud clusters params
func (o *GetCombinedCloudClustersParams) WithOffset(offset *int64) *GetCombinedCloudClustersParams {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the get combined cloud clusters params
func (o *GetCombinedCloudClustersParams) SetOffset(offset *int64) {
	o.Offset = offset
}

// WriteToRequest writes these params to a swagger request
func (o *GetCombinedCloudClustersParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ClusterService != nil {

		// binding items for cluster_service
		joinedClusterService := o.bindParamClusterService(reg)

		// query array param cluster_service
		if err := r.SetQueryParam("cluster_service", joinedClusterService...); err != nil {
			return err
		}
	}

	if o.ClusterStatus != nil {

		// binding items for cluster_status
		joinedClusterStatus := o.bindParamClusterStatus(reg)

		// query array param cluster_status
		if err := r.SetQueryParam("cluster_status", joinedClusterStatus...); err != nil {
			return err
		}
	}

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Locations != nil {

		// binding items for locations
		joinedLocations := o.bindParamLocations(reg)

		// query array param locations
		if err := r.SetQueryParam("locations", joinedLocations...); err != nil {
			return err
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset int64

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := swag.FormatInt64(qrOffset)
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGetCombinedCloudClusters binds the parameter cluster_service
func (o *GetCombinedCloudClustersParams) bindParamClusterService(formats strfmt.Registry) []string {
	clusterServiceIR := o.ClusterService

	var clusterServiceIC []string
	for _, clusterServiceIIR := range clusterServiceIR { // explode []string

		clusterServiceIIV := clusterServiceIIR // string as string
		clusterServiceIC = append(clusterServiceIC, clusterServiceIIV)
	}

	// items.CollectionFormat: "csv"
	clusterServiceIS := swag.JoinByFormat(clusterServiceIC, "csv")

	return clusterServiceIS
}

// bindParamGetCombinedCloudClusters binds the parameter cluster_status
func (o *GetCombinedCloudClustersParams) bindParamClusterStatus(formats strfmt.Registry) []string {
	clusterStatusIR := o.ClusterStatus

	var clusterStatusIC []string
	for _, clusterStatusIIR := range clusterStatusIR { // explode []string

		clusterStatusIIV := clusterStatusIIR // string as string
		clusterStatusIC = append(clusterStatusIC, clusterStatusIIV)
	}

	// items.CollectionFormat: "csv"
	clusterStatusIS := swag.JoinByFormat(clusterStatusIC, "csv")

	return clusterStatusIS
}

// bindParamGetCombinedCloudClusters binds the parameter ids
func (o *GetCombinedCloudClustersParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "csv"
	idsIS := swag.JoinByFormat(idsIC, "csv")

	return idsIS
}

// bindParamGetCombinedCloudClusters binds the parameter locations
func (o *GetCombinedCloudClustersParams) bindParamLocations(formats strfmt.Registry) []string {
	locationsIR := o.Locations

	var locationsIC []string
	for _, locationsIIR := range locationsIR { // explode []string

		locationsIIV := locationsIIR // string as string
		locationsIC = append(locationsIC, locationsIIV)
	}

	// items.CollectionFormat: "csv"
	locationsIS := swag.JoinByFormat(locationsIC, "csv")

	return locationsIS
}
