// Code generated by go-swagger; DO NOT EDIT.

package kubernetes_protection

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetCombinedCloudClustersReader is a Reader for the GetCombinedCloudClusters structure.
type GetCombinedCloudClustersReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetCombinedCloudClustersReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetCombinedCloudClustersOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 207:
		result := NewGetCombinedCloudClustersMultiStatus()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetCombinedCloudClustersBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetCombinedCloudClustersForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetCombinedCloudClustersTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetCombinedCloudClustersInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /kubernetes-protection/entities/cloud_cluster/v1] GetCombinedCloudClusters", response, response.Code())
	}
}

// NewGetCombinedCloudClustersOK creates a GetCombinedCloudClustersOK with default headers values
func NewGetCombinedCloudClustersOK() *GetCombinedCloudClustersOK {
	return &GetCombinedCloudClustersOK{}
}

/*
GetCombinedCloudClustersOK describes a response with status code 200, with default header values.

OK
*/
type GetCombinedCloudClustersOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.K8sregListClusterCloudResp
}

// IsSuccess returns true when this get combined cloud clusters o k response has a 2xx status code
func (o *GetCombinedCloudClustersOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get combined cloud clusters o k response has a 3xx status code
func (o *GetCombinedCloudClustersOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get combined cloud clusters o k response has a 4xx status code
func (o *GetCombinedCloudClustersOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get combined cloud clusters o k response has a 5xx status code
func (o *GetCombinedCloudClustersOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get combined cloud clusters o k response a status code equal to that given
func (o *GetCombinedCloudClustersOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get combined cloud clusters o k response
func (o *GetCombinedCloudClustersOK) Code() int {
	return 200
}

func (o *GetCombinedCloudClustersOK) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/cloud_cluster/v1][%d] getCombinedCloudClustersOK  %+v", 200, o.Payload)
}

func (o *GetCombinedCloudClustersOK) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/cloud_cluster/v1][%d] getCombinedCloudClustersOK  %+v", 200, o.Payload)
}

func (o *GetCombinedCloudClustersOK) GetPayload() *models.K8sregListClusterCloudResp {
	return o.Payload
}

func (o *GetCombinedCloudClustersOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.K8sregListClusterCloudResp)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCombinedCloudClustersMultiStatus creates a GetCombinedCloudClustersMultiStatus with default headers values
func NewGetCombinedCloudClustersMultiStatus() *GetCombinedCloudClustersMultiStatus {
	return &GetCombinedCloudClustersMultiStatus{}
}

/*
GetCombinedCloudClustersMultiStatus describes a response with status code 207, with default header values.

Multi-Status
*/
type GetCombinedCloudClustersMultiStatus struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.K8sregListClusterCloudResp
}

// IsSuccess returns true when this get combined cloud clusters multi status response has a 2xx status code
func (o *GetCombinedCloudClustersMultiStatus) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get combined cloud clusters multi status response has a 3xx status code
func (o *GetCombinedCloudClustersMultiStatus) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get combined cloud clusters multi status response has a 4xx status code
func (o *GetCombinedCloudClustersMultiStatus) IsClientError() bool {
	return false
}

// IsServerError returns true when this get combined cloud clusters multi status response has a 5xx status code
func (o *GetCombinedCloudClustersMultiStatus) IsServerError() bool {
	return false
}

// IsCode returns true when this get combined cloud clusters multi status response a status code equal to that given
func (o *GetCombinedCloudClustersMultiStatus) IsCode(code int) bool {
	return code == 207
}

// Code gets the status code for the get combined cloud clusters multi status response
func (o *GetCombinedCloudClustersMultiStatus) Code() int {
	return 207
}

func (o *GetCombinedCloudClustersMultiStatus) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/cloud_cluster/v1][%d] getCombinedCloudClustersMultiStatus  %+v", 207, o.Payload)
}

func (o *GetCombinedCloudClustersMultiStatus) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/cloud_cluster/v1][%d] getCombinedCloudClustersMultiStatus  %+v", 207, o.Payload)
}

func (o *GetCombinedCloudClustersMultiStatus) GetPayload() *models.K8sregListClusterCloudResp {
	return o.Payload
}

func (o *GetCombinedCloudClustersMultiStatus) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.K8sregListClusterCloudResp)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCombinedCloudClustersBadRequest creates a GetCombinedCloudClustersBadRequest with default headers values
func NewGetCombinedCloudClustersBadRequest() *GetCombinedCloudClustersBadRequest {
	return &GetCombinedCloudClustersBadRequest{}
}

/*
GetCombinedCloudClustersBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetCombinedCloudClustersBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.K8sregListClusterCloudResp
}

// IsSuccess returns true when this get combined cloud clusters bad request response has a 2xx status code
func (o *GetCombinedCloudClustersBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get combined cloud clusters bad request response has a 3xx status code
func (o *GetCombinedCloudClustersBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get combined cloud clusters bad request response has a 4xx status code
func (o *GetCombinedCloudClustersBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get combined cloud clusters bad request response has a 5xx status code
func (o *GetCombinedCloudClustersBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get combined cloud clusters bad request response a status code equal to that given
func (o *GetCombinedCloudClustersBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get combined cloud clusters bad request response
func (o *GetCombinedCloudClustersBadRequest) Code() int {
	return 400
}

func (o *GetCombinedCloudClustersBadRequest) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/cloud_cluster/v1][%d] getCombinedCloudClustersBadRequest  %+v", 400, o.Payload)
}

func (o *GetCombinedCloudClustersBadRequest) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/cloud_cluster/v1][%d] getCombinedCloudClustersBadRequest  %+v", 400, o.Payload)
}

func (o *GetCombinedCloudClustersBadRequest) GetPayload() *models.K8sregListClusterCloudResp {
	return o.Payload
}

func (o *GetCombinedCloudClustersBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.K8sregListClusterCloudResp)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCombinedCloudClustersForbidden creates a GetCombinedCloudClustersForbidden with default headers values
func NewGetCombinedCloudClustersForbidden() *GetCombinedCloudClustersForbidden {
	return &GetCombinedCloudClustersForbidden{}
}

/*
GetCombinedCloudClustersForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetCombinedCloudClustersForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get combined cloud clusters forbidden response has a 2xx status code
func (o *GetCombinedCloudClustersForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get combined cloud clusters forbidden response has a 3xx status code
func (o *GetCombinedCloudClustersForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get combined cloud clusters forbidden response has a 4xx status code
func (o *GetCombinedCloudClustersForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get combined cloud clusters forbidden response has a 5xx status code
func (o *GetCombinedCloudClustersForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get combined cloud clusters forbidden response a status code equal to that given
func (o *GetCombinedCloudClustersForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get combined cloud clusters forbidden response
func (o *GetCombinedCloudClustersForbidden) Code() int {
	return 403
}

func (o *GetCombinedCloudClustersForbidden) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/cloud_cluster/v1][%d] getCombinedCloudClustersForbidden  %+v", 403, o.Payload)
}

func (o *GetCombinedCloudClustersForbidden) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/cloud_cluster/v1][%d] getCombinedCloudClustersForbidden  %+v", 403, o.Payload)
}

func (o *GetCombinedCloudClustersForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetCombinedCloudClustersForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCombinedCloudClustersTooManyRequests creates a GetCombinedCloudClustersTooManyRequests with default headers values
func NewGetCombinedCloudClustersTooManyRequests() *GetCombinedCloudClustersTooManyRequests {
	return &GetCombinedCloudClustersTooManyRequests{}
}

/*
GetCombinedCloudClustersTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetCombinedCloudClustersTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get combined cloud clusters too many requests response has a 2xx status code
func (o *GetCombinedCloudClustersTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get combined cloud clusters too many requests response has a 3xx status code
func (o *GetCombinedCloudClustersTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get combined cloud clusters too many requests response has a 4xx status code
func (o *GetCombinedCloudClustersTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get combined cloud clusters too many requests response has a 5xx status code
func (o *GetCombinedCloudClustersTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get combined cloud clusters too many requests response a status code equal to that given
func (o *GetCombinedCloudClustersTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get combined cloud clusters too many requests response
func (o *GetCombinedCloudClustersTooManyRequests) Code() int {
	return 429
}

func (o *GetCombinedCloudClustersTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/cloud_cluster/v1][%d] getCombinedCloudClustersTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetCombinedCloudClustersTooManyRequests) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/cloud_cluster/v1][%d] getCombinedCloudClustersTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetCombinedCloudClustersTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetCombinedCloudClustersTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCombinedCloudClustersInternalServerError creates a GetCombinedCloudClustersInternalServerError with default headers values
func NewGetCombinedCloudClustersInternalServerError() *GetCombinedCloudClustersInternalServerError {
	return &GetCombinedCloudClustersInternalServerError{}
}

/*
GetCombinedCloudClustersInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetCombinedCloudClustersInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.K8sregListClusterCloudResp
}

// IsSuccess returns true when this get combined cloud clusters internal server error response has a 2xx status code
func (o *GetCombinedCloudClustersInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get combined cloud clusters internal server error response has a 3xx status code
func (o *GetCombinedCloudClustersInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get combined cloud clusters internal server error response has a 4xx status code
func (o *GetCombinedCloudClustersInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get combined cloud clusters internal server error response has a 5xx status code
func (o *GetCombinedCloudClustersInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get combined cloud clusters internal server error response a status code equal to that given
func (o *GetCombinedCloudClustersInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get combined cloud clusters internal server error response
func (o *GetCombinedCloudClustersInternalServerError) Code() int {
	return 500
}

func (o *GetCombinedCloudClustersInternalServerError) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/cloud_cluster/v1][%d] getCombinedCloudClustersInternalServerError  %+v", 500, o.Payload)
}

func (o *GetCombinedCloudClustersInternalServerError) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/cloud_cluster/v1][%d] getCombinedCloudClustersInternalServerError  %+v", 500, o.Payload)
}

func (o *GetCombinedCloudClustersInternalServerError) GetPayload() *models.K8sregListClusterCloudResp {
	return o.Payload
}

func (o *GetCombinedCloudClustersInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.K8sregListClusterCloudResp)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
