// Code generated by go-swagger; DO NOT EDIT.

package kubernetes_protection

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetHelmValuesYamlReader is a Reader for the GetHelmValuesYaml structure.
type GetHelmValuesYamlReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetHelmValuesYamlReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetHelmValuesYamlOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetHelmValuesYamlBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetHelmValuesYamlForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetHelmValuesYamlTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetHelmValuesYamlInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /kubernetes-protection/entities/integration/agent/v1] GetHelmValuesYaml", response, response.Code())
	}
}

// NewGetHelmValuesYamlOK creates a GetHelmValuesYamlOK with default headers values
func NewGetHelmValuesYamlOK() *GetHelmValuesYamlOK {
	return &GetHelmValuesYamlOK{}
}

/*
GetHelmValuesYamlOK describes a response with status code 200, with default header values.

OK
*/
type GetHelmValuesYamlOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload models.K8sregHelmYAMLResp
}

// IsSuccess returns true when this get helm values yaml o k response has a 2xx status code
func (o *GetHelmValuesYamlOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get helm values yaml o k response has a 3xx status code
func (o *GetHelmValuesYamlOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get helm values yaml o k response has a 4xx status code
func (o *GetHelmValuesYamlOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get helm values yaml o k response has a 5xx status code
func (o *GetHelmValuesYamlOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get helm values yaml o k response a status code equal to that given
func (o *GetHelmValuesYamlOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get helm values yaml o k response
func (o *GetHelmValuesYamlOK) Code() int {
	return 200
}

func (o *GetHelmValuesYamlOK) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/integration/agent/v1][%d] getHelmValuesYamlOK  %+v", 200, o.Payload)
}

func (o *GetHelmValuesYamlOK) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/integration/agent/v1][%d] getHelmValuesYamlOK  %+v", 200, o.Payload)
}

func (o *GetHelmValuesYamlOK) GetPayload() models.K8sregHelmYAMLResp {
	return o.Payload
}

func (o *GetHelmValuesYamlOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetHelmValuesYamlBadRequest creates a GetHelmValuesYamlBadRequest with default headers values
func NewGetHelmValuesYamlBadRequest() *GetHelmValuesYamlBadRequest {
	return &GetHelmValuesYamlBadRequest{}
}

/*
GetHelmValuesYamlBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetHelmValuesYamlBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get helm values yaml bad request response has a 2xx status code
func (o *GetHelmValuesYamlBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get helm values yaml bad request response has a 3xx status code
func (o *GetHelmValuesYamlBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get helm values yaml bad request response has a 4xx status code
func (o *GetHelmValuesYamlBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get helm values yaml bad request response has a 5xx status code
func (o *GetHelmValuesYamlBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get helm values yaml bad request response a status code equal to that given
func (o *GetHelmValuesYamlBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get helm values yaml bad request response
func (o *GetHelmValuesYamlBadRequest) Code() int {
	return 400
}

func (o *GetHelmValuesYamlBadRequest) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/integration/agent/v1][%d] getHelmValuesYamlBadRequest  %+v", 400, o.Payload)
}

func (o *GetHelmValuesYamlBadRequest) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/integration/agent/v1][%d] getHelmValuesYamlBadRequest  %+v", 400, o.Payload)
}

func (o *GetHelmValuesYamlBadRequest) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetHelmValuesYamlBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetHelmValuesYamlForbidden creates a GetHelmValuesYamlForbidden with default headers values
func NewGetHelmValuesYamlForbidden() *GetHelmValuesYamlForbidden {
	return &GetHelmValuesYamlForbidden{}
}

/*
GetHelmValuesYamlForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetHelmValuesYamlForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get helm values yaml forbidden response has a 2xx status code
func (o *GetHelmValuesYamlForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get helm values yaml forbidden response has a 3xx status code
func (o *GetHelmValuesYamlForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get helm values yaml forbidden response has a 4xx status code
func (o *GetHelmValuesYamlForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get helm values yaml forbidden response has a 5xx status code
func (o *GetHelmValuesYamlForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get helm values yaml forbidden response a status code equal to that given
func (o *GetHelmValuesYamlForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get helm values yaml forbidden response
func (o *GetHelmValuesYamlForbidden) Code() int {
	return 403
}

func (o *GetHelmValuesYamlForbidden) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/integration/agent/v1][%d] getHelmValuesYamlForbidden  %+v", 403, o.Payload)
}

func (o *GetHelmValuesYamlForbidden) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/integration/agent/v1][%d] getHelmValuesYamlForbidden  %+v", 403, o.Payload)
}

func (o *GetHelmValuesYamlForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetHelmValuesYamlForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetHelmValuesYamlTooManyRequests creates a GetHelmValuesYamlTooManyRequests with default headers values
func NewGetHelmValuesYamlTooManyRequests() *GetHelmValuesYamlTooManyRequests {
	return &GetHelmValuesYamlTooManyRequests{}
}

/*
GetHelmValuesYamlTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetHelmValuesYamlTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get helm values yaml too many requests response has a 2xx status code
func (o *GetHelmValuesYamlTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get helm values yaml too many requests response has a 3xx status code
func (o *GetHelmValuesYamlTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get helm values yaml too many requests response has a 4xx status code
func (o *GetHelmValuesYamlTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get helm values yaml too many requests response has a 5xx status code
func (o *GetHelmValuesYamlTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get helm values yaml too many requests response a status code equal to that given
func (o *GetHelmValuesYamlTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get helm values yaml too many requests response
func (o *GetHelmValuesYamlTooManyRequests) Code() int {
	return 429
}

func (o *GetHelmValuesYamlTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/integration/agent/v1][%d] getHelmValuesYamlTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetHelmValuesYamlTooManyRequests) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/integration/agent/v1][%d] getHelmValuesYamlTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetHelmValuesYamlTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetHelmValuesYamlTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetHelmValuesYamlInternalServerError creates a GetHelmValuesYamlInternalServerError with default headers values
func NewGetHelmValuesYamlInternalServerError() *GetHelmValuesYamlInternalServerError {
	return &GetHelmValuesYamlInternalServerError{}
}

/*
GetHelmValuesYamlInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetHelmValuesYamlInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get helm values yaml internal server error response has a 2xx status code
func (o *GetHelmValuesYamlInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get helm values yaml internal server error response has a 3xx status code
func (o *GetHelmValuesYamlInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get helm values yaml internal server error response has a 4xx status code
func (o *GetHelmValuesYamlInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get helm values yaml internal server error response has a 5xx status code
func (o *GetHelmValuesYamlInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get helm values yaml internal server error response a status code equal to that given
func (o *GetHelmValuesYamlInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get helm values yaml internal server error response
func (o *GetHelmValuesYamlInternalServerError) Code() int {
	return 500
}

func (o *GetHelmValuesYamlInternalServerError) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/integration/agent/v1][%d] getHelmValuesYamlInternalServerError  %+v", 500, o.Payload)
}

func (o *GetHelmValuesYamlInternalServerError) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/integration/agent/v1][%d] getHelmValuesYamlInternalServerError  %+v", 500, o.Payload)
}

func (o *GetHelmValuesYamlInternalServerError) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetHelmValuesYamlInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
