// Code generated by go-swagger; DO NOT EDIT.

package kubernetes_protection

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetStaticScriptsReader is a Reader for the GetStaticScripts structure.
type GetStaticScriptsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetStaticScriptsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetStaticScriptsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 207:
		result := NewGetStaticScriptsMultiStatus()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetStaticScriptsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetStaticScriptsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetStaticScriptsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetStaticScriptsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /kubernetes-protection/entities/gen/scripts/v1] GetStaticScripts", response, response.Code())
	}
}

// NewGetStaticScriptsOK creates a GetStaticScriptsOK with default headers values
func NewGetStaticScriptsOK() *GetStaticScriptsOK {
	return &GetStaticScriptsOK{}
}

/*
GetStaticScriptsOK describes a response with status code 200, with default header values.

OK
*/
type GetStaticScriptsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.K8sregGetScriptsResp
}

// IsSuccess returns true when this get static scripts o k response has a 2xx status code
func (o *GetStaticScriptsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get static scripts o k response has a 3xx status code
func (o *GetStaticScriptsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get static scripts o k response has a 4xx status code
func (o *GetStaticScriptsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get static scripts o k response has a 5xx status code
func (o *GetStaticScriptsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get static scripts o k response a status code equal to that given
func (o *GetStaticScriptsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get static scripts o k response
func (o *GetStaticScriptsOK) Code() int {
	return 200
}

func (o *GetStaticScriptsOK) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/gen/scripts/v1][%d] getStaticScriptsOK  %+v", 200, o.Payload)
}

func (o *GetStaticScriptsOK) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/gen/scripts/v1][%d] getStaticScriptsOK  %+v", 200, o.Payload)
}

func (o *GetStaticScriptsOK) GetPayload() *models.K8sregGetScriptsResp {
	return o.Payload
}

func (o *GetStaticScriptsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.K8sregGetScriptsResp)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetStaticScriptsMultiStatus creates a GetStaticScriptsMultiStatus with default headers values
func NewGetStaticScriptsMultiStatus() *GetStaticScriptsMultiStatus {
	return &GetStaticScriptsMultiStatus{}
}

/*
GetStaticScriptsMultiStatus describes a response with status code 207, with default header values.

Multi-Status
*/
type GetStaticScriptsMultiStatus struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.K8sregGetScriptsResp
}

// IsSuccess returns true when this get static scripts multi status response has a 2xx status code
func (o *GetStaticScriptsMultiStatus) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get static scripts multi status response has a 3xx status code
func (o *GetStaticScriptsMultiStatus) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get static scripts multi status response has a 4xx status code
func (o *GetStaticScriptsMultiStatus) IsClientError() bool {
	return false
}

// IsServerError returns true when this get static scripts multi status response has a 5xx status code
func (o *GetStaticScriptsMultiStatus) IsServerError() bool {
	return false
}

// IsCode returns true when this get static scripts multi status response a status code equal to that given
func (o *GetStaticScriptsMultiStatus) IsCode(code int) bool {
	return code == 207
}

// Code gets the status code for the get static scripts multi status response
func (o *GetStaticScriptsMultiStatus) Code() int {
	return 207
}

func (o *GetStaticScriptsMultiStatus) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/gen/scripts/v1][%d] getStaticScriptsMultiStatus  %+v", 207, o.Payload)
}

func (o *GetStaticScriptsMultiStatus) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/gen/scripts/v1][%d] getStaticScriptsMultiStatus  %+v", 207, o.Payload)
}

func (o *GetStaticScriptsMultiStatus) GetPayload() *models.K8sregGetScriptsResp {
	return o.Payload
}

func (o *GetStaticScriptsMultiStatus) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.K8sregGetScriptsResp)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetStaticScriptsBadRequest creates a GetStaticScriptsBadRequest with default headers values
func NewGetStaticScriptsBadRequest() *GetStaticScriptsBadRequest {
	return &GetStaticScriptsBadRequest{}
}

/*
GetStaticScriptsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetStaticScriptsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.K8sregGetScriptsResp
}

// IsSuccess returns true when this get static scripts bad request response has a 2xx status code
func (o *GetStaticScriptsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get static scripts bad request response has a 3xx status code
func (o *GetStaticScriptsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get static scripts bad request response has a 4xx status code
func (o *GetStaticScriptsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get static scripts bad request response has a 5xx status code
func (o *GetStaticScriptsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get static scripts bad request response a status code equal to that given
func (o *GetStaticScriptsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get static scripts bad request response
func (o *GetStaticScriptsBadRequest) Code() int {
	return 400
}

func (o *GetStaticScriptsBadRequest) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/gen/scripts/v1][%d] getStaticScriptsBadRequest  %+v", 400, o.Payload)
}

func (o *GetStaticScriptsBadRequest) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/gen/scripts/v1][%d] getStaticScriptsBadRequest  %+v", 400, o.Payload)
}

func (o *GetStaticScriptsBadRequest) GetPayload() *models.K8sregGetScriptsResp {
	return o.Payload
}

func (o *GetStaticScriptsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.K8sregGetScriptsResp)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetStaticScriptsForbidden creates a GetStaticScriptsForbidden with default headers values
func NewGetStaticScriptsForbidden() *GetStaticScriptsForbidden {
	return &GetStaticScriptsForbidden{}
}

/*
GetStaticScriptsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetStaticScriptsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get static scripts forbidden response has a 2xx status code
func (o *GetStaticScriptsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get static scripts forbidden response has a 3xx status code
func (o *GetStaticScriptsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get static scripts forbidden response has a 4xx status code
func (o *GetStaticScriptsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get static scripts forbidden response has a 5xx status code
func (o *GetStaticScriptsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get static scripts forbidden response a status code equal to that given
func (o *GetStaticScriptsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get static scripts forbidden response
func (o *GetStaticScriptsForbidden) Code() int {
	return 403
}

func (o *GetStaticScriptsForbidden) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/gen/scripts/v1][%d] getStaticScriptsForbidden  %+v", 403, o.Payload)
}

func (o *GetStaticScriptsForbidden) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/gen/scripts/v1][%d] getStaticScriptsForbidden  %+v", 403, o.Payload)
}

func (o *GetStaticScriptsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetStaticScriptsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetStaticScriptsTooManyRequests creates a GetStaticScriptsTooManyRequests with default headers values
func NewGetStaticScriptsTooManyRequests() *GetStaticScriptsTooManyRequests {
	return &GetStaticScriptsTooManyRequests{}
}

/*
GetStaticScriptsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetStaticScriptsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get static scripts too many requests response has a 2xx status code
func (o *GetStaticScriptsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get static scripts too many requests response has a 3xx status code
func (o *GetStaticScriptsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get static scripts too many requests response has a 4xx status code
func (o *GetStaticScriptsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get static scripts too many requests response has a 5xx status code
func (o *GetStaticScriptsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get static scripts too many requests response a status code equal to that given
func (o *GetStaticScriptsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get static scripts too many requests response
func (o *GetStaticScriptsTooManyRequests) Code() int {
	return 429
}

func (o *GetStaticScriptsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/gen/scripts/v1][%d] getStaticScriptsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetStaticScriptsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/gen/scripts/v1][%d] getStaticScriptsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetStaticScriptsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetStaticScriptsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetStaticScriptsInternalServerError creates a GetStaticScriptsInternalServerError with default headers values
func NewGetStaticScriptsInternalServerError() *GetStaticScriptsInternalServerError {
	return &GetStaticScriptsInternalServerError{}
}

/*
GetStaticScriptsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetStaticScriptsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.K8sregGetScriptsResp
}

// IsSuccess returns true when this get static scripts internal server error response has a 2xx status code
func (o *GetStaticScriptsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get static scripts internal server error response has a 3xx status code
func (o *GetStaticScriptsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get static scripts internal server error response has a 4xx status code
func (o *GetStaticScriptsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get static scripts internal server error response has a 5xx status code
func (o *GetStaticScriptsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get static scripts internal server error response a status code equal to that given
func (o *GetStaticScriptsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get static scripts internal server error response
func (o *GetStaticScriptsInternalServerError) Code() int {
	return 500
}

func (o *GetStaticScriptsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/gen/scripts/v1][%d] getStaticScriptsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetStaticScriptsInternalServerError) String() string {
	return fmt.Sprintf("[GET /kubernetes-protection/entities/gen/scripts/v1][%d] getStaticScriptsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetStaticScriptsInternalServerError) GetPayload() *models.K8sregGetScriptsResp {
	return o.Payload
}

func (o *GetStaticScriptsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.K8sregGetScriptsResp)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
