// Code generated by go-swagger; DO NOT EDIT.

package kubernetes_protection

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewListAzureAccountsParams creates a new ListAzureAccountsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewListAzureAccountsParams() *ListAzureAccountsParams {
	return &ListAzureAccountsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewListAzureAccountsParamsWithTimeout creates a new ListAzureAccountsParams object
// with the ability to set a timeout on a request.
func NewListAzureAccountsParamsWithTimeout(timeout time.Duration) *ListAzureAccountsParams {
	return &ListAzureAccountsParams{
		timeout: timeout,
	}
}

// NewListAzureAccountsParamsWithContext creates a new ListAzureAccountsParams object
// with the ability to set a context for a request.
func NewListAzureAccountsParamsWithContext(ctx context.Context) *ListAzureAccountsParams {
	return &ListAzureAccountsParams{
		Context: ctx,
	}
}

// NewListAzureAccountsParamsWithHTTPClient creates a new ListAzureAccountsParams object
// with the ability to set a custom HTTPClient for a request.
func NewListAzureAccountsParamsWithHTTPClient(client *http.Client) *ListAzureAccountsParams {
	return &ListAzureAccountsParams{
		HTTPClient: client,
	}
}

/*
ListAzureAccountsParams contains all the parameters to send to the API endpoint

	for the list azure accounts operation.

	Typically these are written to a http.Request.
*/
type ListAzureAccountsParams struct {

	/* Ids.

	   Azure Tenant IDs
	*/
	Ids []string

	/* IsHorizonAcct.

	   Filter by whether an account originates from Horizon or not
	*/
	IsHorizonAcct *string

	/* Limit.

	   Limit returned accounts
	*/
	Limit *int64

	/* Offset.

	   Offset returned accounts
	*/
	Offset *int64

	/* Status.

	   Filter by account status
	*/
	Status *string

	/* SubscriptionID.

	   Azure Subscription IDs
	*/
	SubscriptionID []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the list azure accounts params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListAzureAccountsParams) WithDefaults() *ListAzureAccountsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the list azure accounts params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListAzureAccountsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the list azure accounts params
func (o *ListAzureAccountsParams) WithTimeout(timeout time.Duration) *ListAzureAccountsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the list azure accounts params
func (o *ListAzureAccountsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the list azure accounts params
func (o *ListAzureAccountsParams) WithContext(ctx context.Context) *ListAzureAccountsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the list azure accounts params
func (o *ListAzureAccountsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the list azure accounts params
func (o *ListAzureAccountsParams) WithHTTPClient(client *http.Client) *ListAzureAccountsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the list azure accounts params
func (o *ListAzureAccountsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the list azure accounts params
func (o *ListAzureAccountsParams) WithIds(ids []string) *ListAzureAccountsParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the list azure accounts params
func (o *ListAzureAccountsParams) SetIds(ids []string) {
	o.Ids = ids
}

// WithIsHorizonAcct adds the isHorizonAcct to the list azure accounts params
func (o *ListAzureAccountsParams) WithIsHorizonAcct(isHorizonAcct *string) *ListAzureAccountsParams {
	o.SetIsHorizonAcct(isHorizonAcct)
	return o
}

// SetIsHorizonAcct adds the isHorizonAcct to the list azure accounts params
func (o *ListAzureAccountsParams) SetIsHorizonAcct(isHorizonAcct *string) {
	o.IsHorizonAcct = isHorizonAcct
}

// WithLimit adds the limit to the list azure accounts params
func (o *ListAzureAccountsParams) WithLimit(limit *int64) *ListAzureAccountsParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the list azure accounts params
func (o *ListAzureAccountsParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithOffset adds the offset to the list azure accounts params
func (o *ListAzureAccountsParams) WithOffset(offset *int64) *ListAzureAccountsParams {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the list azure accounts params
func (o *ListAzureAccountsParams) SetOffset(offset *int64) {
	o.Offset = offset
}

// WithStatus adds the status to the list azure accounts params
func (o *ListAzureAccountsParams) WithStatus(status *string) *ListAzureAccountsParams {
	o.SetStatus(status)
	return o
}

// SetStatus adds the status to the list azure accounts params
func (o *ListAzureAccountsParams) SetStatus(status *string) {
	o.Status = status
}

// WithSubscriptionID adds the subscriptionID to the list azure accounts params
func (o *ListAzureAccountsParams) WithSubscriptionID(subscriptionID []string) *ListAzureAccountsParams {
	o.SetSubscriptionID(subscriptionID)
	return o
}

// SetSubscriptionID adds the subscriptionId to the list azure accounts params
func (o *ListAzureAccountsParams) SetSubscriptionID(subscriptionID []string) {
	o.SubscriptionID = subscriptionID
}

// WriteToRequest writes these params to a swagger request
func (o *ListAzureAccountsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if o.IsHorizonAcct != nil {

		// query param is_horizon_acct
		var qrIsHorizonAcct string

		if o.IsHorizonAcct != nil {
			qrIsHorizonAcct = *o.IsHorizonAcct
		}
		qIsHorizonAcct := qrIsHorizonAcct
		if qIsHorizonAcct != "" {

			if err := r.SetQueryParam("is_horizon_acct", qIsHorizonAcct); err != nil {
				return err
			}
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset int64

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := swag.FormatInt64(qrOffset)
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if o.Status != nil {

		// query param status
		var qrStatus string

		if o.Status != nil {
			qrStatus = *o.Status
		}
		qStatus := qrStatus
		if qStatus != "" {

			if err := r.SetQueryParam("status", qStatus); err != nil {
				return err
			}
		}
	}

	if o.SubscriptionID != nil {

		// binding items for subscription_id
		joinedSubscriptionID := o.bindParamSubscriptionID(reg)

		// query array param subscription_id
		if err := r.SetQueryParam("subscription_id", joinedSubscriptionID...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamListAzureAccounts binds the parameter ids
func (o *ListAzureAccountsParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "csv"
	idsIS := swag.JoinByFormat(idsIC, "csv")

	return idsIS
}

// bindParamListAzureAccounts binds the parameter subscription_id
func (o *ListAzureAccountsParams) bindParamSubscriptionID(formats strfmt.Registry) []string {
	subscriptionIDIR := o.SubscriptionID

	var subscriptionIDIC []string
	for _, subscriptionIDIIR := range subscriptionIDIR { // explode []string

		subscriptionIDIIV := subscriptionIDIIR // string as string
		subscriptionIDIC = append(subscriptionIDIC, subscriptionIDIIV)
	}

	// items.CollectionFormat: "csv"
	subscriptionIDIS := swag.JoinByFormat(subscriptionIDIC, "csv")

	return subscriptionIDIS
}
