// Code generated by go-swagger; DO NOT EDIT.

package kubernetes_protection

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// PatchAzureServicePrincipalReader is a Reader for the PatchAzureServicePrincipal structure.
type PatchAzureServicePrincipalReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PatchAzureServicePrincipalReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewPatchAzureServicePrincipalCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 207:
		result := NewPatchAzureServicePrincipalMultiStatus()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewPatchAzureServicePrincipalBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewPatchAzureServicePrincipalForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewPatchAzureServicePrincipalTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewPatchAzureServicePrincipalInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PATCH /kubernetes-protection/entities/service-principal/azure/v1] PatchAzureServicePrincipal", response, response.Code())
	}
}

// NewPatchAzureServicePrincipalCreated creates a PatchAzureServicePrincipalCreated with default headers values
func NewPatchAzureServicePrincipalCreated() *PatchAzureServicePrincipalCreated {
	return &PatchAzureServicePrincipalCreated{}
}

/*
PatchAzureServicePrincipalCreated describes a response with status code 201, with default header values.

Created
*/
type PatchAzureServicePrincipalCreated struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.K8sregGetAzureTenantConfigResp
}

// IsSuccess returns true when this patch azure service principal created response has a 2xx status code
func (o *PatchAzureServicePrincipalCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this patch azure service principal created response has a 3xx status code
func (o *PatchAzureServicePrincipalCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this patch azure service principal created response has a 4xx status code
func (o *PatchAzureServicePrincipalCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this patch azure service principal created response has a 5xx status code
func (o *PatchAzureServicePrincipalCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this patch azure service principal created response a status code equal to that given
func (o *PatchAzureServicePrincipalCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the patch azure service principal created response
func (o *PatchAzureServicePrincipalCreated) Code() int {
	return 201
}

func (o *PatchAzureServicePrincipalCreated) Error() string {
	return fmt.Sprintf("[PATCH /kubernetes-protection/entities/service-principal/azure/v1][%d] patchAzureServicePrincipalCreated  %+v", 201, o.Payload)
}

func (o *PatchAzureServicePrincipalCreated) String() string {
	return fmt.Sprintf("[PATCH /kubernetes-protection/entities/service-principal/azure/v1][%d] patchAzureServicePrincipalCreated  %+v", 201, o.Payload)
}

func (o *PatchAzureServicePrincipalCreated) GetPayload() *models.K8sregGetAzureTenantConfigResp {
	return o.Payload
}

func (o *PatchAzureServicePrincipalCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.K8sregGetAzureTenantConfigResp)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPatchAzureServicePrincipalMultiStatus creates a PatchAzureServicePrincipalMultiStatus with default headers values
func NewPatchAzureServicePrincipalMultiStatus() *PatchAzureServicePrincipalMultiStatus {
	return &PatchAzureServicePrincipalMultiStatus{}
}

/*
PatchAzureServicePrincipalMultiStatus describes a response with status code 207, with default header values.

Multi-Status
*/
type PatchAzureServicePrincipalMultiStatus struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.K8sregGetAzureTenantConfigResp
}

// IsSuccess returns true when this patch azure service principal multi status response has a 2xx status code
func (o *PatchAzureServicePrincipalMultiStatus) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this patch azure service principal multi status response has a 3xx status code
func (o *PatchAzureServicePrincipalMultiStatus) IsRedirect() bool {
	return false
}

// IsClientError returns true when this patch azure service principal multi status response has a 4xx status code
func (o *PatchAzureServicePrincipalMultiStatus) IsClientError() bool {
	return false
}

// IsServerError returns true when this patch azure service principal multi status response has a 5xx status code
func (o *PatchAzureServicePrincipalMultiStatus) IsServerError() bool {
	return false
}

// IsCode returns true when this patch azure service principal multi status response a status code equal to that given
func (o *PatchAzureServicePrincipalMultiStatus) IsCode(code int) bool {
	return code == 207
}

// Code gets the status code for the patch azure service principal multi status response
func (o *PatchAzureServicePrincipalMultiStatus) Code() int {
	return 207
}

func (o *PatchAzureServicePrincipalMultiStatus) Error() string {
	return fmt.Sprintf("[PATCH /kubernetes-protection/entities/service-principal/azure/v1][%d] patchAzureServicePrincipalMultiStatus  %+v", 207, o.Payload)
}

func (o *PatchAzureServicePrincipalMultiStatus) String() string {
	return fmt.Sprintf("[PATCH /kubernetes-protection/entities/service-principal/azure/v1][%d] patchAzureServicePrincipalMultiStatus  %+v", 207, o.Payload)
}

func (o *PatchAzureServicePrincipalMultiStatus) GetPayload() *models.K8sregGetAzureTenantConfigResp {
	return o.Payload
}

func (o *PatchAzureServicePrincipalMultiStatus) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.K8sregGetAzureTenantConfigResp)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPatchAzureServicePrincipalBadRequest creates a PatchAzureServicePrincipalBadRequest with default headers values
func NewPatchAzureServicePrincipalBadRequest() *PatchAzureServicePrincipalBadRequest {
	return &PatchAzureServicePrincipalBadRequest{}
}

/*
PatchAzureServicePrincipalBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type PatchAzureServicePrincipalBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.K8sregGetAzureTenantConfigResp
}

// IsSuccess returns true when this patch azure service principal bad request response has a 2xx status code
func (o *PatchAzureServicePrincipalBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this patch azure service principal bad request response has a 3xx status code
func (o *PatchAzureServicePrincipalBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this patch azure service principal bad request response has a 4xx status code
func (o *PatchAzureServicePrincipalBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this patch azure service principal bad request response has a 5xx status code
func (o *PatchAzureServicePrincipalBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this patch azure service principal bad request response a status code equal to that given
func (o *PatchAzureServicePrincipalBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the patch azure service principal bad request response
func (o *PatchAzureServicePrincipalBadRequest) Code() int {
	return 400
}

func (o *PatchAzureServicePrincipalBadRequest) Error() string {
	return fmt.Sprintf("[PATCH /kubernetes-protection/entities/service-principal/azure/v1][%d] patchAzureServicePrincipalBadRequest  %+v", 400, o.Payload)
}

func (o *PatchAzureServicePrincipalBadRequest) String() string {
	return fmt.Sprintf("[PATCH /kubernetes-protection/entities/service-principal/azure/v1][%d] patchAzureServicePrincipalBadRequest  %+v", 400, o.Payload)
}

func (o *PatchAzureServicePrincipalBadRequest) GetPayload() *models.K8sregGetAzureTenantConfigResp {
	return o.Payload
}

func (o *PatchAzureServicePrincipalBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.K8sregGetAzureTenantConfigResp)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPatchAzureServicePrincipalForbidden creates a PatchAzureServicePrincipalForbidden with default headers values
func NewPatchAzureServicePrincipalForbidden() *PatchAzureServicePrincipalForbidden {
	return &PatchAzureServicePrincipalForbidden{}
}

/*
PatchAzureServicePrincipalForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type PatchAzureServicePrincipalForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this patch azure service principal forbidden response has a 2xx status code
func (o *PatchAzureServicePrincipalForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this patch azure service principal forbidden response has a 3xx status code
func (o *PatchAzureServicePrincipalForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this patch azure service principal forbidden response has a 4xx status code
func (o *PatchAzureServicePrincipalForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this patch azure service principal forbidden response has a 5xx status code
func (o *PatchAzureServicePrincipalForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this patch azure service principal forbidden response a status code equal to that given
func (o *PatchAzureServicePrincipalForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the patch azure service principal forbidden response
func (o *PatchAzureServicePrincipalForbidden) Code() int {
	return 403
}

func (o *PatchAzureServicePrincipalForbidden) Error() string {
	return fmt.Sprintf("[PATCH /kubernetes-protection/entities/service-principal/azure/v1][%d] patchAzureServicePrincipalForbidden  %+v", 403, o.Payload)
}

func (o *PatchAzureServicePrincipalForbidden) String() string {
	return fmt.Sprintf("[PATCH /kubernetes-protection/entities/service-principal/azure/v1][%d] patchAzureServicePrincipalForbidden  %+v", 403, o.Payload)
}

func (o *PatchAzureServicePrincipalForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *PatchAzureServicePrincipalForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPatchAzureServicePrincipalTooManyRequests creates a PatchAzureServicePrincipalTooManyRequests with default headers values
func NewPatchAzureServicePrincipalTooManyRequests() *PatchAzureServicePrincipalTooManyRequests {
	return &PatchAzureServicePrincipalTooManyRequests{}
}

/*
PatchAzureServicePrincipalTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type PatchAzureServicePrincipalTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this patch azure service principal too many requests response has a 2xx status code
func (o *PatchAzureServicePrincipalTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this patch azure service principal too many requests response has a 3xx status code
func (o *PatchAzureServicePrincipalTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this patch azure service principal too many requests response has a 4xx status code
func (o *PatchAzureServicePrincipalTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this patch azure service principal too many requests response has a 5xx status code
func (o *PatchAzureServicePrincipalTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this patch azure service principal too many requests response a status code equal to that given
func (o *PatchAzureServicePrincipalTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the patch azure service principal too many requests response
func (o *PatchAzureServicePrincipalTooManyRequests) Code() int {
	return 429
}

func (o *PatchAzureServicePrincipalTooManyRequests) Error() string {
	return fmt.Sprintf("[PATCH /kubernetes-protection/entities/service-principal/azure/v1][%d] patchAzureServicePrincipalTooManyRequests  %+v", 429, o.Payload)
}

func (o *PatchAzureServicePrincipalTooManyRequests) String() string {
	return fmt.Sprintf("[PATCH /kubernetes-protection/entities/service-principal/azure/v1][%d] patchAzureServicePrincipalTooManyRequests  %+v", 429, o.Payload)
}

func (o *PatchAzureServicePrincipalTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *PatchAzureServicePrincipalTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPatchAzureServicePrincipalInternalServerError creates a PatchAzureServicePrincipalInternalServerError with default headers values
func NewPatchAzureServicePrincipalInternalServerError() *PatchAzureServicePrincipalInternalServerError {
	return &PatchAzureServicePrincipalInternalServerError{}
}

/*
PatchAzureServicePrincipalInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type PatchAzureServicePrincipalInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.K8sregGetAzureTenantConfigResp
}

// IsSuccess returns true when this patch azure service principal internal server error response has a 2xx status code
func (o *PatchAzureServicePrincipalInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this patch azure service principal internal server error response has a 3xx status code
func (o *PatchAzureServicePrincipalInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this patch azure service principal internal server error response has a 4xx status code
func (o *PatchAzureServicePrincipalInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this patch azure service principal internal server error response has a 5xx status code
func (o *PatchAzureServicePrincipalInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this patch azure service principal internal server error response a status code equal to that given
func (o *PatchAzureServicePrincipalInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the patch azure service principal internal server error response
func (o *PatchAzureServicePrincipalInternalServerError) Code() int {
	return 500
}

func (o *PatchAzureServicePrincipalInternalServerError) Error() string {
	return fmt.Sprintf("[PATCH /kubernetes-protection/entities/service-principal/azure/v1][%d] patchAzureServicePrincipalInternalServerError  %+v", 500, o.Payload)
}

func (o *PatchAzureServicePrincipalInternalServerError) String() string {
	return fmt.Sprintf("[PATCH /kubernetes-protection/entities/service-principal/azure/v1][%d] patchAzureServicePrincipalInternalServerError  %+v", 500, o.Payload)
}

func (o *PatchAzureServicePrincipalInternalServerError) GetPayload() *models.K8sregGetAzureTenantConfigResp {
	return o.Payload
}

func (o *PatchAzureServicePrincipalInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.K8sregGetAzureTenantConfigResp)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
