// Code generated by go-swagger; DO NOT EDIT.

package kubernetes_protection

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewTriggerScanParams creates a new TriggerScanParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewTriggerScanParams() *TriggerScanParams {
	return &TriggerScanParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewTriggerScanParamsWithTimeout creates a new TriggerScanParams object
// with the ability to set a timeout on a request.
func NewTriggerScanParamsWithTimeout(timeout time.Duration) *TriggerScanParams {
	return &TriggerScanParams{
		timeout: timeout,
	}
}

// NewTriggerScanParamsWithContext creates a new TriggerScanParams object
// with the ability to set a context for a request.
func NewTriggerScanParamsWithContext(ctx context.Context) *TriggerScanParams {
	return &TriggerScanParams{
		Context: ctx,
	}
}

// NewTriggerScanParamsWithHTTPClient creates a new TriggerScanParams object
// with the ability to set a custom HTTPClient for a request.
func NewTriggerScanParamsWithHTTPClient(client *http.Client) *TriggerScanParams {
	return &TriggerScanParams{
		HTTPClient: client,
	}
}

/*
TriggerScanParams contains all the parameters to send to the API endpoint

	for the trigger scan operation.

	Typically these are written to a http.Request.
*/
type TriggerScanParams struct {

	/* ScanType.

	   Scan Type to do

	   Default: "dry-run"
	*/
	ScanType string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the trigger scan params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TriggerScanParams) WithDefaults() *TriggerScanParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the trigger scan params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TriggerScanParams) SetDefaults() {
	var (
		scanTypeDefault = string("dry-run")
	)

	val := TriggerScanParams{
		ScanType: scanTypeDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the trigger scan params
func (o *TriggerScanParams) WithTimeout(timeout time.Duration) *TriggerScanParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the trigger scan params
func (o *TriggerScanParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the trigger scan params
func (o *TriggerScanParams) WithContext(ctx context.Context) *TriggerScanParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the trigger scan params
func (o *TriggerScanParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the trigger scan params
func (o *TriggerScanParams) WithHTTPClient(client *http.Client) *TriggerScanParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the trigger scan params
func (o *TriggerScanParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithScanType adds the scanType to the trigger scan params
func (o *TriggerScanParams) WithScanType(scanType string) *TriggerScanParams {
	o.SetScanType(scanType)
	return o
}

// SetScanType adds the scanType to the trigger scan params
func (o *TriggerScanParams) SetScanType(scanType string) {
	o.ScanType = scanType
}

// WriteToRequest writes these params to a swagger request
func (o *TriggerScanParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// query param scan_type
	qrScanType := o.ScanType
	qScanType := qrScanType
	if qScanType != "" {

		if err := r.SetQueryParam("scan_type", qScanType); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
