// Code generated by go-swagger; DO NOT EDIT.

package kubernetes_protection

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// UpdateAWSAccountReader is a Reader for the UpdateAWSAccount structure.
type UpdateAWSAccountReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateAWSAccountReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateAWSAccountOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 207:
		result := NewUpdateAWSAccountMultiStatus()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewUpdateAWSAccountBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUpdateAWSAccountForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewUpdateAWSAccountTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewUpdateAWSAccountInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PATCH /kubernetes-protection/entities/accounts/aws/v1] UpdateAWSAccount", response, response.Code())
	}
}

// NewUpdateAWSAccountOK creates a UpdateAWSAccountOK with default headers values
func NewUpdateAWSAccountOK() *UpdateAWSAccountOK {
	return &UpdateAWSAccountOK{}
}

/*
UpdateAWSAccountOK describes a response with status code 200, with default header values.

OK
*/
type UpdateAWSAccountOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaBaseEntitiesResponse
}

// IsSuccess returns true when this update a w s account o k response has a 2xx status code
func (o *UpdateAWSAccountOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update a w s account o k response has a 3xx status code
func (o *UpdateAWSAccountOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update a w s account o k response has a 4xx status code
func (o *UpdateAWSAccountOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update a w s account o k response has a 5xx status code
func (o *UpdateAWSAccountOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update a w s account o k response a status code equal to that given
func (o *UpdateAWSAccountOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update a w s account o k response
func (o *UpdateAWSAccountOK) Code() int {
	return 200
}

func (o *UpdateAWSAccountOK) Error() string {
	return fmt.Sprintf("[PATCH /kubernetes-protection/entities/accounts/aws/v1][%d] updateAWSAccountOK  %+v", 200, o.Payload)
}

func (o *UpdateAWSAccountOK) String() string {
	return fmt.Sprintf("[PATCH /kubernetes-protection/entities/accounts/aws/v1][%d] updateAWSAccountOK  %+v", 200, o.Payload)
}

func (o *UpdateAWSAccountOK) GetPayload() *models.MsaBaseEntitiesResponse {
	return o.Payload
}

func (o *UpdateAWSAccountOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaBaseEntitiesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateAWSAccountMultiStatus creates a UpdateAWSAccountMultiStatus with default headers values
func NewUpdateAWSAccountMultiStatus() *UpdateAWSAccountMultiStatus {
	return &UpdateAWSAccountMultiStatus{}
}

/*
UpdateAWSAccountMultiStatus describes a response with status code 207, with default header values.

Multi-Status
*/
type UpdateAWSAccountMultiStatus struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaBaseEntitiesResponse
}

// IsSuccess returns true when this update a w s account multi status response has a 2xx status code
func (o *UpdateAWSAccountMultiStatus) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update a w s account multi status response has a 3xx status code
func (o *UpdateAWSAccountMultiStatus) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update a w s account multi status response has a 4xx status code
func (o *UpdateAWSAccountMultiStatus) IsClientError() bool {
	return false
}

// IsServerError returns true when this update a w s account multi status response has a 5xx status code
func (o *UpdateAWSAccountMultiStatus) IsServerError() bool {
	return false
}

// IsCode returns true when this update a w s account multi status response a status code equal to that given
func (o *UpdateAWSAccountMultiStatus) IsCode(code int) bool {
	return code == 207
}

// Code gets the status code for the update a w s account multi status response
func (o *UpdateAWSAccountMultiStatus) Code() int {
	return 207
}

func (o *UpdateAWSAccountMultiStatus) Error() string {
	return fmt.Sprintf("[PATCH /kubernetes-protection/entities/accounts/aws/v1][%d] updateAWSAccountMultiStatus  %+v", 207, o.Payload)
}

func (o *UpdateAWSAccountMultiStatus) String() string {
	return fmt.Sprintf("[PATCH /kubernetes-protection/entities/accounts/aws/v1][%d] updateAWSAccountMultiStatus  %+v", 207, o.Payload)
}

func (o *UpdateAWSAccountMultiStatus) GetPayload() *models.MsaBaseEntitiesResponse {
	return o.Payload
}

func (o *UpdateAWSAccountMultiStatus) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaBaseEntitiesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateAWSAccountBadRequest creates a UpdateAWSAccountBadRequest with default headers values
func NewUpdateAWSAccountBadRequest() *UpdateAWSAccountBadRequest {
	return &UpdateAWSAccountBadRequest{}
}

/*
UpdateAWSAccountBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type UpdateAWSAccountBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaBaseEntitiesResponse
}

// IsSuccess returns true when this update a w s account bad request response has a 2xx status code
func (o *UpdateAWSAccountBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update a w s account bad request response has a 3xx status code
func (o *UpdateAWSAccountBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update a w s account bad request response has a 4xx status code
func (o *UpdateAWSAccountBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this update a w s account bad request response has a 5xx status code
func (o *UpdateAWSAccountBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this update a w s account bad request response a status code equal to that given
func (o *UpdateAWSAccountBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the update a w s account bad request response
func (o *UpdateAWSAccountBadRequest) Code() int {
	return 400
}

func (o *UpdateAWSAccountBadRequest) Error() string {
	return fmt.Sprintf("[PATCH /kubernetes-protection/entities/accounts/aws/v1][%d] updateAWSAccountBadRequest  %+v", 400, o.Payload)
}

func (o *UpdateAWSAccountBadRequest) String() string {
	return fmt.Sprintf("[PATCH /kubernetes-protection/entities/accounts/aws/v1][%d] updateAWSAccountBadRequest  %+v", 400, o.Payload)
}

func (o *UpdateAWSAccountBadRequest) GetPayload() *models.MsaBaseEntitiesResponse {
	return o.Payload
}

func (o *UpdateAWSAccountBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaBaseEntitiesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateAWSAccountForbidden creates a UpdateAWSAccountForbidden with default headers values
func NewUpdateAWSAccountForbidden() *UpdateAWSAccountForbidden {
	return &UpdateAWSAccountForbidden{}
}

/*
UpdateAWSAccountForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type UpdateAWSAccountForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this update a w s account forbidden response has a 2xx status code
func (o *UpdateAWSAccountForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update a w s account forbidden response has a 3xx status code
func (o *UpdateAWSAccountForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update a w s account forbidden response has a 4xx status code
func (o *UpdateAWSAccountForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this update a w s account forbidden response has a 5xx status code
func (o *UpdateAWSAccountForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this update a w s account forbidden response a status code equal to that given
func (o *UpdateAWSAccountForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the update a w s account forbidden response
func (o *UpdateAWSAccountForbidden) Code() int {
	return 403
}

func (o *UpdateAWSAccountForbidden) Error() string {
	return fmt.Sprintf("[PATCH /kubernetes-protection/entities/accounts/aws/v1][%d] updateAWSAccountForbidden  %+v", 403, o.Payload)
}

func (o *UpdateAWSAccountForbidden) String() string {
	return fmt.Sprintf("[PATCH /kubernetes-protection/entities/accounts/aws/v1][%d] updateAWSAccountForbidden  %+v", 403, o.Payload)
}

func (o *UpdateAWSAccountForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *UpdateAWSAccountForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateAWSAccountTooManyRequests creates a UpdateAWSAccountTooManyRequests with default headers values
func NewUpdateAWSAccountTooManyRequests() *UpdateAWSAccountTooManyRequests {
	return &UpdateAWSAccountTooManyRequests{}
}

/*
UpdateAWSAccountTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type UpdateAWSAccountTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this update a w s account too many requests response has a 2xx status code
func (o *UpdateAWSAccountTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update a w s account too many requests response has a 3xx status code
func (o *UpdateAWSAccountTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update a w s account too many requests response has a 4xx status code
func (o *UpdateAWSAccountTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this update a w s account too many requests response has a 5xx status code
func (o *UpdateAWSAccountTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this update a w s account too many requests response a status code equal to that given
func (o *UpdateAWSAccountTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the update a w s account too many requests response
func (o *UpdateAWSAccountTooManyRequests) Code() int {
	return 429
}

func (o *UpdateAWSAccountTooManyRequests) Error() string {
	return fmt.Sprintf("[PATCH /kubernetes-protection/entities/accounts/aws/v1][%d] updateAWSAccountTooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdateAWSAccountTooManyRequests) String() string {
	return fmt.Sprintf("[PATCH /kubernetes-protection/entities/accounts/aws/v1][%d] updateAWSAccountTooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdateAWSAccountTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *UpdateAWSAccountTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateAWSAccountInternalServerError creates a UpdateAWSAccountInternalServerError with default headers values
func NewUpdateAWSAccountInternalServerError() *UpdateAWSAccountInternalServerError {
	return &UpdateAWSAccountInternalServerError{}
}

/*
UpdateAWSAccountInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type UpdateAWSAccountInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaBaseEntitiesResponse
}

// IsSuccess returns true when this update a w s account internal server error response has a 2xx status code
func (o *UpdateAWSAccountInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update a w s account internal server error response has a 3xx status code
func (o *UpdateAWSAccountInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update a w s account internal server error response has a 4xx status code
func (o *UpdateAWSAccountInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this update a w s account internal server error response has a 5xx status code
func (o *UpdateAWSAccountInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this update a w s account internal server error response a status code equal to that given
func (o *UpdateAWSAccountInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the update a w s account internal server error response
func (o *UpdateAWSAccountInternalServerError) Code() int {
	return 500
}

func (o *UpdateAWSAccountInternalServerError) Error() string {
	return fmt.Sprintf("[PATCH /kubernetes-protection/entities/accounts/aws/v1][%d] updateAWSAccountInternalServerError  %+v", 500, o.Payload)
}

func (o *UpdateAWSAccountInternalServerError) String() string {
	return fmt.Sprintf("[PATCH /kubernetes-protection/entities/accounts/aws/v1][%d] updateAWSAccountInternalServerError  %+v", 500, o.Payload)
}

func (o *UpdateAWSAccountInternalServerError) GetPayload() *models.MsaBaseEntitiesResponse {
	return o.Payload
}

func (o *UpdateAWSAccountInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaBaseEntitiesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
