// Code generated by go-swagger; DO NOT EDIT.

package malquery

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetMalQueryQuotasV1Reader is a Reader for the GetMalQueryQuotasV1 structure.
type GetMalQueryQuotasV1Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetMalQueryQuotasV1Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetMalQueryQuotasV1OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetMalQueryQuotasV1BadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewGetMalQueryQuotasV1Unauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetMalQueryQuotasV1Forbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetMalQueryQuotasV1NotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetMalQueryQuotasV1TooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetMalQueryQuotasV1InternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /malquery/aggregates/quotas/v1] GetMalQueryQuotasV1", response, response.Code())
	}
}

// NewGetMalQueryQuotasV1OK creates a GetMalQueryQuotasV1OK with default headers values
func NewGetMalQueryQuotasV1OK() *GetMalQueryQuotasV1OK {
	return &GetMalQueryQuotasV1OK{}
}

/*
GetMalQueryQuotasV1OK describes a response with status code 200, with default header values.

OK
*/
type GetMalQueryQuotasV1OK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MalqueryRateLimitsResponse
}

// IsSuccess returns true when this get mal query quotas v1 o k response has a 2xx status code
func (o *GetMalQueryQuotasV1OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get mal query quotas v1 o k response has a 3xx status code
func (o *GetMalQueryQuotasV1OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get mal query quotas v1 o k response has a 4xx status code
func (o *GetMalQueryQuotasV1OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get mal query quotas v1 o k response has a 5xx status code
func (o *GetMalQueryQuotasV1OK) IsServerError() bool {
	return false
}

// IsCode returns true when this get mal query quotas v1 o k response a status code equal to that given
func (o *GetMalQueryQuotasV1OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get mal query quotas v1 o k response
func (o *GetMalQueryQuotasV1OK) Code() int {
	return 200
}

func (o *GetMalQueryQuotasV1OK) Error() string {
	return fmt.Sprintf("[GET /malquery/aggregates/quotas/v1][%d] getMalQueryQuotasV1OK  %+v", 200, o.Payload)
}

func (o *GetMalQueryQuotasV1OK) String() string {
	return fmt.Sprintf("[GET /malquery/aggregates/quotas/v1][%d] getMalQueryQuotasV1OK  %+v", 200, o.Payload)
}

func (o *GetMalQueryQuotasV1OK) GetPayload() *models.MalqueryRateLimitsResponse {
	return o.Payload
}

func (o *GetMalQueryQuotasV1OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MalqueryRateLimitsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetMalQueryQuotasV1BadRequest creates a GetMalQueryQuotasV1BadRequest with default headers values
func NewGetMalQueryQuotasV1BadRequest() *GetMalQueryQuotasV1BadRequest {
	return &GetMalQueryQuotasV1BadRequest{}
}

/*
GetMalQueryQuotasV1BadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetMalQueryQuotasV1BadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this get mal query quotas v1 bad request response has a 2xx status code
func (o *GetMalQueryQuotasV1BadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get mal query quotas v1 bad request response has a 3xx status code
func (o *GetMalQueryQuotasV1BadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get mal query quotas v1 bad request response has a 4xx status code
func (o *GetMalQueryQuotasV1BadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get mal query quotas v1 bad request response has a 5xx status code
func (o *GetMalQueryQuotasV1BadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get mal query quotas v1 bad request response a status code equal to that given
func (o *GetMalQueryQuotasV1BadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get mal query quotas v1 bad request response
func (o *GetMalQueryQuotasV1BadRequest) Code() int {
	return 400
}

func (o *GetMalQueryQuotasV1BadRequest) Error() string {
	return fmt.Sprintf("[GET /malquery/aggregates/quotas/v1][%d] getMalQueryQuotasV1BadRequest  %+v", 400, o.Payload)
}

func (o *GetMalQueryQuotasV1BadRequest) String() string {
	return fmt.Sprintf("[GET /malquery/aggregates/quotas/v1][%d] getMalQueryQuotasV1BadRequest  %+v", 400, o.Payload)
}

func (o *GetMalQueryQuotasV1BadRequest) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *GetMalQueryQuotasV1BadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetMalQueryQuotasV1Unauthorized creates a GetMalQueryQuotasV1Unauthorized with default headers values
func NewGetMalQueryQuotasV1Unauthorized() *GetMalQueryQuotasV1Unauthorized {
	return &GetMalQueryQuotasV1Unauthorized{}
}

/*
GetMalQueryQuotasV1Unauthorized describes a response with status code 401, with default header values.

Unauthorized
*/
type GetMalQueryQuotasV1Unauthorized struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this get mal query quotas v1 unauthorized response has a 2xx status code
func (o *GetMalQueryQuotasV1Unauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get mal query quotas v1 unauthorized response has a 3xx status code
func (o *GetMalQueryQuotasV1Unauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get mal query quotas v1 unauthorized response has a 4xx status code
func (o *GetMalQueryQuotasV1Unauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get mal query quotas v1 unauthorized response has a 5xx status code
func (o *GetMalQueryQuotasV1Unauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get mal query quotas v1 unauthorized response a status code equal to that given
func (o *GetMalQueryQuotasV1Unauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get mal query quotas v1 unauthorized response
func (o *GetMalQueryQuotasV1Unauthorized) Code() int {
	return 401
}

func (o *GetMalQueryQuotasV1Unauthorized) Error() string {
	return fmt.Sprintf("[GET /malquery/aggregates/quotas/v1][%d] getMalQueryQuotasV1Unauthorized  %+v", 401, o.Payload)
}

func (o *GetMalQueryQuotasV1Unauthorized) String() string {
	return fmt.Sprintf("[GET /malquery/aggregates/quotas/v1][%d] getMalQueryQuotasV1Unauthorized  %+v", 401, o.Payload)
}

func (o *GetMalQueryQuotasV1Unauthorized) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *GetMalQueryQuotasV1Unauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetMalQueryQuotasV1Forbidden creates a GetMalQueryQuotasV1Forbidden with default headers values
func NewGetMalQueryQuotasV1Forbidden() *GetMalQueryQuotasV1Forbidden {
	return &GetMalQueryQuotasV1Forbidden{}
}

/*
GetMalQueryQuotasV1Forbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetMalQueryQuotasV1Forbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this get mal query quotas v1 forbidden response has a 2xx status code
func (o *GetMalQueryQuotasV1Forbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get mal query quotas v1 forbidden response has a 3xx status code
func (o *GetMalQueryQuotasV1Forbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get mal query quotas v1 forbidden response has a 4xx status code
func (o *GetMalQueryQuotasV1Forbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get mal query quotas v1 forbidden response has a 5xx status code
func (o *GetMalQueryQuotasV1Forbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get mal query quotas v1 forbidden response a status code equal to that given
func (o *GetMalQueryQuotasV1Forbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get mal query quotas v1 forbidden response
func (o *GetMalQueryQuotasV1Forbidden) Code() int {
	return 403
}

func (o *GetMalQueryQuotasV1Forbidden) Error() string {
	return fmt.Sprintf("[GET /malquery/aggregates/quotas/v1][%d] getMalQueryQuotasV1Forbidden  %+v", 403, o.Payload)
}

func (o *GetMalQueryQuotasV1Forbidden) String() string {
	return fmt.Sprintf("[GET /malquery/aggregates/quotas/v1][%d] getMalQueryQuotasV1Forbidden  %+v", 403, o.Payload)
}

func (o *GetMalQueryQuotasV1Forbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *GetMalQueryQuotasV1Forbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetMalQueryQuotasV1NotFound creates a GetMalQueryQuotasV1NotFound with default headers values
func NewGetMalQueryQuotasV1NotFound() *GetMalQueryQuotasV1NotFound {
	return &GetMalQueryQuotasV1NotFound{}
}

/*
GetMalQueryQuotasV1NotFound describes a response with status code 404, with default header values.

Not Found
*/
type GetMalQueryQuotasV1NotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MalqueryRateLimitsResponse
}

// IsSuccess returns true when this get mal query quotas v1 not found response has a 2xx status code
func (o *GetMalQueryQuotasV1NotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get mal query quotas v1 not found response has a 3xx status code
func (o *GetMalQueryQuotasV1NotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get mal query quotas v1 not found response has a 4xx status code
func (o *GetMalQueryQuotasV1NotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get mal query quotas v1 not found response has a 5xx status code
func (o *GetMalQueryQuotasV1NotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get mal query quotas v1 not found response a status code equal to that given
func (o *GetMalQueryQuotasV1NotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get mal query quotas v1 not found response
func (o *GetMalQueryQuotasV1NotFound) Code() int {
	return 404
}

func (o *GetMalQueryQuotasV1NotFound) Error() string {
	return fmt.Sprintf("[GET /malquery/aggregates/quotas/v1][%d] getMalQueryQuotasV1NotFound  %+v", 404, o.Payload)
}

func (o *GetMalQueryQuotasV1NotFound) String() string {
	return fmt.Sprintf("[GET /malquery/aggregates/quotas/v1][%d] getMalQueryQuotasV1NotFound  %+v", 404, o.Payload)
}

func (o *GetMalQueryQuotasV1NotFound) GetPayload() *models.MalqueryRateLimitsResponse {
	return o.Payload
}

func (o *GetMalQueryQuotasV1NotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MalqueryRateLimitsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetMalQueryQuotasV1TooManyRequests creates a GetMalQueryQuotasV1TooManyRequests with default headers values
func NewGetMalQueryQuotasV1TooManyRequests() *GetMalQueryQuotasV1TooManyRequests {
	return &GetMalQueryQuotasV1TooManyRequests{}
}

/*
GetMalQueryQuotasV1TooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetMalQueryQuotasV1TooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get mal query quotas v1 too many requests response has a 2xx status code
func (o *GetMalQueryQuotasV1TooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get mal query quotas v1 too many requests response has a 3xx status code
func (o *GetMalQueryQuotasV1TooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get mal query quotas v1 too many requests response has a 4xx status code
func (o *GetMalQueryQuotasV1TooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get mal query quotas v1 too many requests response has a 5xx status code
func (o *GetMalQueryQuotasV1TooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get mal query quotas v1 too many requests response a status code equal to that given
func (o *GetMalQueryQuotasV1TooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get mal query quotas v1 too many requests response
func (o *GetMalQueryQuotasV1TooManyRequests) Code() int {
	return 429
}

func (o *GetMalQueryQuotasV1TooManyRequests) Error() string {
	return fmt.Sprintf("[GET /malquery/aggregates/quotas/v1][%d] getMalQueryQuotasV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *GetMalQueryQuotasV1TooManyRequests) String() string {
	return fmt.Sprintf("[GET /malquery/aggregates/quotas/v1][%d] getMalQueryQuotasV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *GetMalQueryQuotasV1TooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetMalQueryQuotasV1TooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetMalQueryQuotasV1InternalServerError creates a GetMalQueryQuotasV1InternalServerError with default headers values
func NewGetMalQueryQuotasV1InternalServerError() *GetMalQueryQuotasV1InternalServerError {
	return &GetMalQueryQuotasV1InternalServerError{}
}

/*
GetMalQueryQuotasV1InternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetMalQueryQuotasV1InternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MalqueryRateLimitsResponse
}

// IsSuccess returns true when this get mal query quotas v1 internal server error response has a 2xx status code
func (o *GetMalQueryQuotasV1InternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get mal query quotas v1 internal server error response has a 3xx status code
func (o *GetMalQueryQuotasV1InternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get mal query quotas v1 internal server error response has a 4xx status code
func (o *GetMalQueryQuotasV1InternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get mal query quotas v1 internal server error response has a 5xx status code
func (o *GetMalQueryQuotasV1InternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get mal query quotas v1 internal server error response a status code equal to that given
func (o *GetMalQueryQuotasV1InternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get mal query quotas v1 internal server error response
func (o *GetMalQueryQuotasV1InternalServerError) Code() int {
	return 500
}

func (o *GetMalQueryQuotasV1InternalServerError) Error() string {
	return fmt.Sprintf("[GET /malquery/aggregates/quotas/v1][%d] getMalQueryQuotasV1InternalServerError  %+v", 500, o.Payload)
}

func (o *GetMalQueryQuotasV1InternalServerError) String() string {
	return fmt.Sprintf("[GET /malquery/aggregates/quotas/v1][%d] getMalQueryQuotasV1InternalServerError  %+v", 500, o.Payload)
}

func (o *GetMalQueryQuotasV1InternalServerError) GetPayload() *models.MalqueryRateLimitsResponse {
	return o.Payload
}

func (o *GetMalQueryQuotasV1InternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MalqueryRateLimitsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
