// Code generated by go-swagger; DO NOT EDIT.

package message_center

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// AggregateCasesReader is a Reader for the AggregateCases structure.
type AggregateCasesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AggregateCasesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAggregateCasesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewAggregateCasesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewAggregateCasesTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /message-center/aggregates/cases/GET/v1] AggregateCases", response, response.Code())
	}
}

// NewAggregateCasesOK creates a AggregateCasesOK with default headers values
func NewAggregateCasesOK() *AggregateCasesOK {
	return &AggregateCasesOK{}
}

/*
AggregateCasesOK describes a response with status code 200, with default header values.

OK
*/
type AggregateCasesOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaAggregatesResponse
}

// IsSuccess returns true when this aggregate cases o k response has a 2xx status code
func (o *AggregateCasesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this aggregate cases o k response has a 3xx status code
func (o *AggregateCasesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aggregate cases o k response has a 4xx status code
func (o *AggregateCasesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this aggregate cases o k response has a 5xx status code
func (o *AggregateCasesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this aggregate cases o k response a status code equal to that given
func (o *AggregateCasesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the aggregate cases o k response
func (o *AggregateCasesOK) Code() int {
	return 200
}

func (o *AggregateCasesOK) Error() string {
	return fmt.Sprintf("[POST /message-center/aggregates/cases/GET/v1][%d] aggregateCasesOK  %+v", 200, o.Payload)
}

func (o *AggregateCasesOK) String() string {
	return fmt.Sprintf("[POST /message-center/aggregates/cases/GET/v1][%d] aggregateCasesOK  %+v", 200, o.Payload)
}

func (o *AggregateCasesOK) GetPayload() *models.MsaAggregatesResponse {
	return o.Payload
}

func (o *AggregateCasesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaAggregatesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAggregateCasesForbidden creates a AggregateCasesForbidden with default headers values
func NewAggregateCasesForbidden() *AggregateCasesForbidden {
	return &AggregateCasesForbidden{}
}

/*
AggregateCasesForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type AggregateCasesForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this aggregate cases forbidden response has a 2xx status code
func (o *AggregateCasesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aggregate cases forbidden response has a 3xx status code
func (o *AggregateCasesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aggregate cases forbidden response has a 4xx status code
func (o *AggregateCasesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this aggregate cases forbidden response has a 5xx status code
func (o *AggregateCasesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this aggregate cases forbidden response a status code equal to that given
func (o *AggregateCasesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the aggregate cases forbidden response
func (o *AggregateCasesForbidden) Code() int {
	return 403
}

func (o *AggregateCasesForbidden) Error() string {
	return fmt.Sprintf("[POST /message-center/aggregates/cases/GET/v1][%d] aggregateCasesForbidden  %+v", 403, o.Payload)
}

func (o *AggregateCasesForbidden) String() string {
	return fmt.Sprintf("[POST /message-center/aggregates/cases/GET/v1][%d] aggregateCasesForbidden  %+v", 403, o.Payload)
}

func (o *AggregateCasesForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *AggregateCasesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAggregateCasesTooManyRequests creates a AggregateCasesTooManyRequests with default headers values
func NewAggregateCasesTooManyRequests() *AggregateCasesTooManyRequests {
	return &AggregateCasesTooManyRequests{}
}

/*
AggregateCasesTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type AggregateCasesTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this aggregate cases too many requests response has a 2xx status code
func (o *AggregateCasesTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aggregate cases too many requests response has a 3xx status code
func (o *AggregateCasesTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aggregate cases too many requests response has a 4xx status code
func (o *AggregateCasesTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this aggregate cases too many requests response has a 5xx status code
func (o *AggregateCasesTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this aggregate cases too many requests response a status code equal to that given
func (o *AggregateCasesTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the aggregate cases too many requests response
func (o *AggregateCasesTooManyRequests) Code() int {
	return 429
}

func (o *AggregateCasesTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /message-center/aggregates/cases/GET/v1][%d] aggregateCasesTooManyRequests  %+v", 429, o.Payload)
}

func (o *AggregateCasesTooManyRequests) String() string {
	return fmt.Sprintf("[POST /message-center/aggregates/cases/GET/v1][%d] aggregateCasesTooManyRequests  %+v", 429, o.Payload)
}

func (o *AggregateCasesTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *AggregateCasesTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
