// Code generated by go-swagger; DO NOT EDIT.

package message_center

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// CaseAddActivityReader is a Reader for the CaseAddActivity structure.
type CaseAddActivityReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CaseAddActivityReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCaseAddActivityOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewCaseAddActivityBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewCaseAddActivityForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewCaseAddActivityTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewCaseAddActivityInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /message-center/entities/case-activity/v1] CaseAddActivity", response, response.Code())
	}
}

// NewCaseAddActivityOK creates a CaseAddActivityOK with default headers values
func NewCaseAddActivityOK() *CaseAddActivityOK {
	return &CaseAddActivityOK{}
}

/*
CaseAddActivityOK describes a response with status code 200, with default header values.

OK
*/
type CaseAddActivityOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this case add activity o k response has a 2xx status code
func (o *CaseAddActivityOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this case add activity o k response has a 3xx status code
func (o *CaseAddActivityOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this case add activity o k response has a 4xx status code
func (o *CaseAddActivityOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this case add activity o k response has a 5xx status code
func (o *CaseAddActivityOK) IsServerError() bool {
	return false
}

// IsCode returns true when this case add activity o k response a status code equal to that given
func (o *CaseAddActivityOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the case add activity o k response
func (o *CaseAddActivityOK) Code() int {
	return 200
}

func (o *CaseAddActivityOK) Error() string {
	return fmt.Sprintf("[POST /message-center/entities/case-activity/v1][%d] caseAddActivityOK  %+v", 200, o.Payload)
}

func (o *CaseAddActivityOK) String() string {
	return fmt.Sprintf("[POST /message-center/entities/case-activity/v1][%d] caseAddActivityOK  %+v", 200, o.Payload)
}

func (o *CaseAddActivityOK) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CaseAddActivityOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCaseAddActivityBadRequest creates a CaseAddActivityBadRequest with default headers values
func NewCaseAddActivityBadRequest() *CaseAddActivityBadRequest {
	return &CaseAddActivityBadRequest{}
}

/*
CaseAddActivityBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type CaseAddActivityBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this case add activity bad request response has a 2xx status code
func (o *CaseAddActivityBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this case add activity bad request response has a 3xx status code
func (o *CaseAddActivityBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this case add activity bad request response has a 4xx status code
func (o *CaseAddActivityBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this case add activity bad request response has a 5xx status code
func (o *CaseAddActivityBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this case add activity bad request response a status code equal to that given
func (o *CaseAddActivityBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the case add activity bad request response
func (o *CaseAddActivityBadRequest) Code() int {
	return 400
}

func (o *CaseAddActivityBadRequest) Error() string {
	return fmt.Sprintf("[POST /message-center/entities/case-activity/v1][%d] caseAddActivityBadRequest  %+v", 400, o.Payload)
}

func (o *CaseAddActivityBadRequest) String() string {
	return fmt.Sprintf("[POST /message-center/entities/case-activity/v1][%d] caseAddActivityBadRequest  %+v", 400, o.Payload)
}

func (o *CaseAddActivityBadRequest) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CaseAddActivityBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCaseAddActivityForbidden creates a CaseAddActivityForbidden with default headers values
func NewCaseAddActivityForbidden() *CaseAddActivityForbidden {
	return &CaseAddActivityForbidden{}
}

/*
CaseAddActivityForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type CaseAddActivityForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this case add activity forbidden response has a 2xx status code
func (o *CaseAddActivityForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this case add activity forbidden response has a 3xx status code
func (o *CaseAddActivityForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this case add activity forbidden response has a 4xx status code
func (o *CaseAddActivityForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this case add activity forbidden response has a 5xx status code
func (o *CaseAddActivityForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this case add activity forbidden response a status code equal to that given
func (o *CaseAddActivityForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the case add activity forbidden response
func (o *CaseAddActivityForbidden) Code() int {
	return 403
}

func (o *CaseAddActivityForbidden) Error() string {
	return fmt.Sprintf("[POST /message-center/entities/case-activity/v1][%d] caseAddActivityForbidden  %+v", 403, o.Payload)
}

func (o *CaseAddActivityForbidden) String() string {
	return fmt.Sprintf("[POST /message-center/entities/case-activity/v1][%d] caseAddActivityForbidden  %+v", 403, o.Payload)
}

func (o *CaseAddActivityForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CaseAddActivityForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCaseAddActivityTooManyRequests creates a CaseAddActivityTooManyRequests with default headers values
func NewCaseAddActivityTooManyRequests() *CaseAddActivityTooManyRequests {
	return &CaseAddActivityTooManyRequests{}
}

/*
CaseAddActivityTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type CaseAddActivityTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this case add activity too many requests response has a 2xx status code
func (o *CaseAddActivityTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this case add activity too many requests response has a 3xx status code
func (o *CaseAddActivityTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this case add activity too many requests response has a 4xx status code
func (o *CaseAddActivityTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this case add activity too many requests response has a 5xx status code
func (o *CaseAddActivityTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this case add activity too many requests response a status code equal to that given
func (o *CaseAddActivityTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the case add activity too many requests response
func (o *CaseAddActivityTooManyRequests) Code() int {
	return 429
}

func (o *CaseAddActivityTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /message-center/entities/case-activity/v1][%d] caseAddActivityTooManyRequests  %+v", 429, o.Payload)
}

func (o *CaseAddActivityTooManyRequests) String() string {
	return fmt.Sprintf("[POST /message-center/entities/case-activity/v1][%d] caseAddActivityTooManyRequests  %+v", 429, o.Payload)
}

func (o *CaseAddActivityTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CaseAddActivityTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCaseAddActivityInternalServerError creates a CaseAddActivityInternalServerError with default headers values
func NewCaseAddActivityInternalServerError() *CaseAddActivityInternalServerError {
	return &CaseAddActivityInternalServerError{}
}

/*
CaseAddActivityInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type CaseAddActivityInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this case add activity internal server error response has a 2xx status code
func (o *CaseAddActivityInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this case add activity internal server error response has a 3xx status code
func (o *CaseAddActivityInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this case add activity internal server error response has a 4xx status code
func (o *CaseAddActivityInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this case add activity internal server error response has a 5xx status code
func (o *CaseAddActivityInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this case add activity internal server error response a status code equal to that given
func (o *CaseAddActivityInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the case add activity internal server error response
func (o *CaseAddActivityInternalServerError) Code() int {
	return 500
}

func (o *CaseAddActivityInternalServerError) Error() string {
	return fmt.Sprintf("[POST /message-center/entities/case-activity/v1][%d] caseAddActivityInternalServerError  %+v", 500, o.Payload)
}

func (o *CaseAddActivityInternalServerError) String() string {
	return fmt.Sprintf("[POST /message-center/entities/case-activity/v1][%d] caseAddActivityInternalServerError  %+v", 500, o.Payload)
}

func (o *CaseAddActivityInternalServerError) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CaseAddActivityInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
