// Code generated by go-swagger; DO NOT EDIT.

package message_center

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// CaseDownloadAttachmentReader is a Reader for the CaseDownloadAttachment structure.
type CaseDownloadAttachmentReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CaseDownloadAttachmentReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCaseDownloadAttachmentOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewCaseDownloadAttachmentBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewCaseDownloadAttachmentForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewCaseDownloadAttachmentNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewCaseDownloadAttachmentTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewCaseDownloadAttachmentInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /message-center/entities/case-attachment/v1] CaseDownloadAttachment", response, response.Code())
	}
}

// NewCaseDownloadAttachmentOK creates a CaseDownloadAttachmentOK with default headers values
func NewCaseDownloadAttachmentOK() *CaseDownloadAttachmentOK {
	return &CaseDownloadAttachmentOK{}
}

/*
CaseDownloadAttachmentOK describes a response with status code 200, with default header values.

OK
*/
type CaseDownloadAttachmentOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload string
}

// IsSuccess returns true when this case download attachment o k response has a 2xx status code
func (o *CaseDownloadAttachmentOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this case download attachment o k response has a 3xx status code
func (o *CaseDownloadAttachmentOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this case download attachment o k response has a 4xx status code
func (o *CaseDownloadAttachmentOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this case download attachment o k response has a 5xx status code
func (o *CaseDownloadAttachmentOK) IsServerError() bool {
	return false
}

// IsCode returns true when this case download attachment o k response a status code equal to that given
func (o *CaseDownloadAttachmentOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the case download attachment o k response
func (o *CaseDownloadAttachmentOK) Code() int {
	return 200
}

func (o *CaseDownloadAttachmentOK) Error() string {
	return fmt.Sprintf("[GET /message-center/entities/case-attachment/v1][%d] caseDownloadAttachmentOK  %+v", 200, o.Payload)
}

func (o *CaseDownloadAttachmentOK) String() string {
	return fmt.Sprintf("[GET /message-center/entities/case-attachment/v1][%d] caseDownloadAttachmentOK  %+v", 200, o.Payload)
}

func (o *CaseDownloadAttachmentOK) GetPayload() string {
	return o.Payload
}

func (o *CaseDownloadAttachmentOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCaseDownloadAttachmentBadRequest creates a CaseDownloadAttachmentBadRequest with default headers values
func NewCaseDownloadAttachmentBadRequest() *CaseDownloadAttachmentBadRequest {
	return &CaseDownloadAttachmentBadRequest{}
}

/*
CaseDownloadAttachmentBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type CaseDownloadAttachmentBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this case download attachment bad request response has a 2xx status code
func (o *CaseDownloadAttachmentBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this case download attachment bad request response has a 3xx status code
func (o *CaseDownloadAttachmentBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this case download attachment bad request response has a 4xx status code
func (o *CaseDownloadAttachmentBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this case download attachment bad request response has a 5xx status code
func (o *CaseDownloadAttachmentBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this case download attachment bad request response a status code equal to that given
func (o *CaseDownloadAttachmentBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the case download attachment bad request response
func (o *CaseDownloadAttachmentBadRequest) Code() int {
	return 400
}

func (o *CaseDownloadAttachmentBadRequest) Error() string {
	return fmt.Sprintf("[GET /message-center/entities/case-attachment/v1][%d] caseDownloadAttachmentBadRequest  %+v", 400, o.Payload)
}

func (o *CaseDownloadAttachmentBadRequest) String() string {
	return fmt.Sprintf("[GET /message-center/entities/case-attachment/v1][%d] caseDownloadAttachmentBadRequest  %+v", 400, o.Payload)
}

func (o *CaseDownloadAttachmentBadRequest) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CaseDownloadAttachmentBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCaseDownloadAttachmentForbidden creates a CaseDownloadAttachmentForbidden with default headers values
func NewCaseDownloadAttachmentForbidden() *CaseDownloadAttachmentForbidden {
	return &CaseDownloadAttachmentForbidden{}
}

/*
CaseDownloadAttachmentForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type CaseDownloadAttachmentForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this case download attachment forbidden response has a 2xx status code
func (o *CaseDownloadAttachmentForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this case download attachment forbidden response has a 3xx status code
func (o *CaseDownloadAttachmentForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this case download attachment forbidden response has a 4xx status code
func (o *CaseDownloadAttachmentForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this case download attachment forbidden response has a 5xx status code
func (o *CaseDownloadAttachmentForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this case download attachment forbidden response a status code equal to that given
func (o *CaseDownloadAttachmentForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the case download attachment forbidden response
func (o *CaseDownloadAttachmentForbidden) Code() int {
	return 403
}

func (o *CaseDownloadAttachmentForbidden) Error() string {
	return fmt.Sprintf("[GET /message-center/entities/case-attachment/v1][%d] caseDownloadAttachmentForbidden  %+v", 403, o.Payload)
}

func (o *CaseDownloadAttachmentForbidden) String() string {
	return fmt.Sprintf("[GET /message-center/entities/case-attachment/v1][%d] caseDownloadAttachmentForbidden  %+v", 403, o.Payload)
}

func (o *CaseDownloadAttachmentForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CaseDownloadAttachmentForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCaseDownloadAttachmentNotFound creates a CaseDownloadAttachmentNotFound with default headers values
func NewCaseDownloadAttachmentNotFound() *CaseDownloadAttachmentNotFound {
	return &CaseDownloadAttachmentNotFound{}
}

/*
CaseDownloadAttachmentNotFound describes a response with status code 404, with default header values.

Not Found
*/
type CaseDownloadAttachmentNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this case download attachment not found response has a 2xx status code
func (o *CaseDownloadAttachmentNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this case download attachment not found response has a 3xx status code
func (o *CaseDownloadAttachmentNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this case download attachment not found response has a 4xx status code
func (o *CaseDownloadAttachmentNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this case download attachment not found response has a 5xx status code
func (o *CaseDownloadAttachmentNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this case download attachment not found response a status code equal to that given
func (o *CaseDownloadAttachmentNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the case download attachment not found response
func (o *CaseDownloadAttachmentNotFound) Code() int {
	return 404
}

func (o *CaseDownloadAttachmentNotFound) Error() string {
	return fmt.Sprintf("[GET /message-center/entities/case-attachment/v1][%d] caseDownloadAttachmentNotFound  %+v", 404, o.Payload)
}

func (o *CaseDownloadAttachmentNotFound) String() string {
	return fmt.Sprintf("[GET /message-center/entities/case-attachment/v1][%d] caseDownloadAttachmentNotFound  %+v", 404, o.Payload)
}

func (o *CaseDownloadAttachmentNotFound) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CaseDownloadAttachmentNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCaseDownloadAttachmentTooManyRequests creates a CaseDownloadAttachmentTooManyRequests with default headers values
func NewCaseDownloadAttachmentTooManyRequests() *CaseDownloadAttachmentTooManyRequests {
	return &CaseDownloadAttachmentTooManyRequests{}
}

/*
CaseDownloadAttachmentTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type CaseDownloadAttachmentTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this case download attachment too many requests response has a 2xx status code
func (o *CaseDownloadAttachmentTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this case download attachment too many requests response has a 3xx status code
func (o *CaseDownloadAttachmentTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this case download attachment too many requests response has a 4xx status code
func (o *CaseDownloadAttachmentTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this case download attachment too many requests response has a 5xx status code
func (o *CaseDownloadAttachmentTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this case download attachment too many requests response a status code equal to that given
func (o *CaseDownloadAttachmentTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the case download attachment too many requests response
func (o *CaseDownloadAttachmentTooManyRequests) Code() int {
	return 429
}

func (o *CaseDownloadAttachmentTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /message-center/entities/case-attachment/v1][%d] caseDownloadAttachmentTooManyRequests  %+v", 429, o.Payload)
}

func (o *CaseDownloadAttachmentTooManyRequests) String() string {
	return fmt.Sprintf("[GET /message-center/entities/case-attachment/v1][%d] caseDownloadAttachmentTooManyRequests  %+v", 429, o.Payload)
}

func (o *CaseDownloadAttachmentTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CaseDownloadAttachmentTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCaseDownloadAttachmentInternalServerError creates a CaseDownloadAttachmentInternalServerError with default headers values
func NewCaseDownloadAttachmentInternalServerError() *CaseDownloadAttachmentInternalServerError {
	return &CaseDownloadAttachmentInternalServerError{}
}

/*
CaseDownloadAttachmentInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type CaseDownloadAttachmentInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this case download attachment internal server error response has a 2xx status code
func (o *CaseDownloadAttachmentInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this case download attachment internal server error response has a 3xx status code
func (o *CaseDownloadAttachmentInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this case download attachment internal server error response has a 4xx status code
func (o *CaseDownloadAttachmentInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this case download attachment internal server error response has a 5xx status code
func (o *CaseDownloadAttachmentInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this case download attachment internal server error response a status code equal to that given
func (o *CaseDownloadAttachmentInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the case download attachment internal server error response
func (o *CaseDownloadAttachmentInternalServerError) Code() int {
	return 500
}

func (o *CaseDownloadAttachmentInternalServerError) Error() string {
	return fmt.Sprintf("[GET /message-center/entities/case-attachment/v1][%d] caseDownloadAttachmentInternalServerError  %+v", 500, o.Payload)
}

func (o *CaseDownloadAttachmentInternalServerError) String() string {
	return fmt.Sprintf("[GET /message-center/entities/case-attachment/v1][%d] caseDownloadAttachmentInternalServerError  %+v", 500, o.Payload)
}

func (o *CaseDownloadAttachmentInternalServerError) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CaseDownloadAttachmentInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
