// Code generated by go-swagger; DO NOT EDIT.

package message_center

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// CreateCaseReader is a Reader for the CreateCase structure.
type CreateCaseReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateCaseReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreateCaseOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewCreateCaseBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewCreateCaseForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewCreateCaseTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewCreateCaseInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /message-center/entities/case/v1] CreateCase", response, response.Code())
	}
}

// NewCreateCaseOK creates a CreateCaseOK with default headers values
func NewCreateCaseOK() *CreateCaseOK {
	return &CreateCaseOK{}
}

/*
CreateCaseOK describes a response with status code 200, with default header values.

OK
*/
type CreateCaseOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyAffectedEntities
}

// IsSuccess returns true when this create case o k response has a 2xx status code
func (o *CreateCaseOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create case o k response has a 3xx status code
func (o *CreateCaseOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create case o k response has a 4xx status code
func (o *CreateCaseOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this create case o k response has a 5xx status code
func (o *CreateCaseOK) IsServerError() bool {
	return false
}

// IsCode returns true when this create case o k response a status code equal to that given
func (o *CreateCaseOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the create case o k response
func (o *CreateCaseOK) Code() int {
	return 200
}

func (o *CreateCaseOK) Error() string {
	return fmt.Sprintf("[POST /message-center/entities/case/v1][%d] createCaseOK  %+v", 200, o.Payload)
}

func (o *CreateCaseOK) String() string {
	return fmt.Sprintf("[POST /message-center/entities/case/v1][%d] createCaseOK  %+v", 200, o.Payload)
}

func (o *CreateCaseOK) GetPayload() *models.MsaReplyAffectedEntities {
	return o.Payload
}

func (o *CreateCaseOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyAffectedEntities)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateCaseBadRequest creates a CreateCaseBadRequest with default headers values
func NewCreateCaseBadRequest() *CreateCaseBadRequest {
	return &CreateCaseBadRequest{}
}

/*
CreateCaseBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type CreateCaseBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this create case bad request response has a 2xx status code
func (o *CreateCaseBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create case bad request response has a 3xx status code
func (o *CreateCaseBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create case bad request response has a 4xx status code
func (o *CreateCaseBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this create case bad request response has a 5xx status code
func (o *CreateCaseBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this create case bad request response a status code equal to that given
func (o *CreateCaseBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the create case bad request response
func (o *CreateCaseBadRequest) Code() int {
	return 400
}

func (o *CreateCaseBadRequest) Error() string {
	return fmt.Sprintf("[POST /message-center/entities/case/v1][%d] createCaseBadRequest  %+v", 400, o.Payload)
}

func (o *CreateCaseBadRequest) String() string {
	return fmt.Sprintf("[POST /message-center/entities/case/v1][%d] createCaseBadRequest  %+v", 400, o.Payload)
}

func (o *CreateCaseBadRequest) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CreateCaseBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateCaseForbidden creates a CreateCaseForbidden with default headers values
func NewCreateCaseForbidden() *CreateCaseForbidden {
	return &CreateCaseForbidden{}
}

/*
CreateCaseForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type CreateCaseForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this create case forbidden response has a 2xx status code
func (o *CreateCaseForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create case forbidden response has a 3xx status code
func (o *CreateCaseForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create case forbidden response has a 4xx status code
func (o *CreateCaseForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this create case forbidden response has a 5xx status code
func (o *CreateCaseForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this create case forbidden response a status code equal to that given
func (o *CreateCaseForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the create case forbidden response
func (o *CreateCaseForbidden) Code() int {
	return 403
}

func (o *CreateCaseForbidden) Error() string {
	return fmt.Sprintf("[POST /message-center/entities/case/v1][%d] createCaseForbidden  %+v", 403, o.Payload)
}

func (o *CreateCaseForbidden) String() string {
	return fmt.Sprintf("[POST /message-center/entities/case/v1][%d] createCaseForbidden  %+v", 403, o.Payload)
}

func (o *CreateCaseForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CreateCaseForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateCaseTooManyRequests creates a CreateCaseTooManyRequests with default headers values
func NewCreateCaseTooManyRequests() *CreateCaseTooManyRequests {
	return &CreateCaseTooManyRequests{}
}

/*
CreateCaseTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type CreateCaseTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this create case too many requests response has a 2xx status code
func (o *CreateCaseTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create case too many requests response has a 3xx status code
func (o *CreateCaseTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create case too many requests response has a 4xx status code
func (o *CreateCaseTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this create case too many requests response has a 5xx status code
func (o *CreateCaseTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this create case too many requests response a status code equal to that given
func (o *CreateCaseTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the create case too many requests response
func (o *CreateCaseTooManyRequests) Code() int {
	return 429
}

func (o *CreateCaseTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /message-center/entities/case/v1][%d] createCaseTooManyRequests  %+v", 429, o.Payload)
}

func (o *CreateCaseTooManyRequests) String() string {
	return fmt.Sprintf("[POST /message-center/entities/case/v1][%d] createCaseTooManyRequests  %+v", 429, o.Payload)
}

func (o *CreateCaseTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CreateCaseTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateCaseInternalServerError creates a CreateCaseInternalServerError with default headers values
func NewCreateCaseInternalServerError() *CreateCaseInternalServerError {
	return &CreateCaseInternalServerError{}
}

/*
CreateCaseInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type CreateCaseInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this create case internal server error response has a 2xx status code
func (o *CreateCaseInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create case internal server error response has a 3xx status code
func (o *CreateCaseInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create case internal server error response has a 4xx status code
func (o *CreateCaseInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this create case internal server error response has a 5xx status code
func (o *CreateCaseInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this create case internal server error response a status code equal to that given
func (o *CreateCaseInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the create case internal server error response
func (o *CreateCaseInternalServerError) Code() int {
	return 500
}

func (o *CreateCaseInternalServerError) Error() string {
	return fmt.Sprintf("[POST /message-center/entities/case/v1][%d] createCaseInternalServerError  %+v", 500, o.Payload)
}

func (o *CreateCaseInternalServerError) String() string {
	return fmt.Sprintf("[POST /message-center/entities/case/v1][%d] createCaseInternalServerError  %+v", 500, o.Payload)
}

func (o *CreateCaseInternalServerError) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CreateCaseInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
