// Code generated by go-swagger; DO NOT EDIT.

package message_center

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// CreateCaseV2Reader is a Reader for the CreateCaseV2 structure.
type CreateCaseV2Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateCaseV2Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreateCaseV2OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewCreateCaseV2BadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewCreateCaseV2Forbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewCreateCaseV2TooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewCreateCaseV2InternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /message-center/entities/case/v2] CreateCaseV2", response, response.Code())
	}
}

// NewCreateCaseV2OK creates a CreateCaseV2OK with default headers values
func NewCreateCaseV2OK() *CreateCaseV2OK {
	return &CreateCaseV2OK{}
}

/*
CreateCaseV2OK describes a response with status code 200, with default header values.

OK
*/
type CreateCaseV2OK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyAffectedEntities
}

// IsSuccess returns true when this create case v2 o k response has a 2xx status code
func (o *CreateCaseV2OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create case v2 o k response has a 3xx status code
func (o *CreateCaseV2OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create case v2 o k response has a 4xx status code
func (o *CreateCaseV2OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this create case v2 o k response has a 5xx status code
func (o *CreateCaseV2OK) IsServerError() bool {
	return false
}

// IsCode returns true when this create case v2 o k response a status code equal to that given
func (o *CreateCaseV2OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the create case v2 o k response
func (o *CreateCaseV2OK) Code() int {
	return 200
}

func (o *CreateCaseV2OK) Error() string {
	return fmt.Sprintf("[POST /message-center/entities/case/v2][%d] createCaseV2OK  %+v", 200, o.Payload)
}

func (o *CreateCaseV2OK) String() string {
	return fmt.Sprintf("[POST /message-center/entities/case/v2][%d] createCaseV2OK  %+v", 200, o.Payload)
}

func (o *CreateCaseV2OK) GetPayload() *models.MsaReplyAffectedEntities {
	return o.Payload
}

func (o *CreateCaseV2OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyAffectedEntities)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateCaseV2BadRequest creates a CreateCaseV2BadRequest with default headers values
func NewCreateCaseV2BadRequest() *CreateCaseV2BadRequest {
	return &CreateCaseV2BadRequest{}
}

/*
CreateCaseV2BadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type CreateCaseV2BadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this create case v2 bad request response has a 2xx status code
func (o *CreateCaseV2BadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create case v2 bad request response has a 3xx status code
func (o *CreateCaseV2BadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create case v2 bad request response has a 4xx status code
func (o *CreateCaseV2BadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this create case v2 bad request response has a 5xx status code
func (o *CreateCaseV2BadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this create case v2 bad request response a status code equal to that given
func (o *CreateCaseV2BadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the create case v2 bad request response
func (o *CreateCaseV2BadRequest) Code() int {
	return 400
}

func (o *CreateCaseV2BadRequest) Error() string {
	return fmt.Sprintf("[POST /message-center/entities/case/v2][%d] createCaseV2BadRequest  %+v", 400, o.Payload)
}

func (o *CreateCaseV2BadRequest) String() string {
	return fmt.Sprintf("[POST /message-center/entities/case/v2][%d] createCaseV2BadRequest  %+v", 400, o.Payload)
}

func (o *CreateCaseV2BadRequest) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CreateCaseV2BadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateCaseV2Forbidden creates a CreateCaseV2Forbidden with default headers values
func NewCreateCaseV2Forbidden() *CreateCaseV2Forbidden {
	return &CreateCaseV2Forbidden{}
}

/*
CreateCaseV2Forbidden describes a response with status code 403, with default header values.

Forbidden
*/
type CreateCaseV2Forbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this create case v2 forbidden response has a 2xx status code
func (o *CreateCaseV2Forbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create case v2 forbidden response has a 3xx status code
func (o *CreateCaseV2Forbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create case v2 forbidden response has a 4xx status code
func (o *CreateCaseV2Forbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this create case v2 forbidden response has a 5xx status code
func (o *CreateCaseV2Forbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this create case v2 forbidden response a status code equal to that given
func (o *CreateCaseV2Forbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the create case v2 forbidden response
func (o *CreateCaseV2Forbidden) Code() int {
	return 403
}

func (o *CreateCaseV2Forbidden) Error() string {
	return fmt.Sprintf("[POST /message-center/entities/case/v2][%d] createCaseV2Forbidden  %+v", 403, o.Payload)
}

func (o *CreateCaseV2Forbidden) String() string {
	return fmt.Sprintf("[POST /message-center/entities/case/v2][%d] createCaseV2Forbidden  %+v", 403, o.Payload)
}

func (o *CreateCaseV2Forbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CreateCaseV2Forbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateCaseV2TooManyRequests creates a CreateCaseV2TooManyRequests with default headers values
func NewCreateCaseV2TooManyRequests() *CreateCaseV2TooManyRequests {
	return &CreateCaseV2TooManyRequests{}
}

/*
CreateCaseV2TooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type CreateCaseV2TooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this create case v2 too many requests response has a 2xx status code
func (o *CreateCaseV2TooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create case v2 too many requests response has a 3xx status code
func (o *CreateCaseV2TooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create case v2 too many requests response has a 4xx status code
func (o *CreateCaseV2TooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this create case v2 too many requests response has a 5xx status code
func (o *CreateCaseV2TooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this create case v2 too many requests response a status code equal to that given
func (o *CreateCaseV2TooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the create case v2 too many requests response
func (o *CreateCaseV2TooManyRequests) Code() int {
	return 429
}

func (o *CreateCaseV2TooManyRequests) Error() string {
	return fmt.Sprintf("[POST /message-center/entities/case/v2][%d] createCaseV2TooManyRequests  %+v", 429, o.Payload)
}

func (o *CreateCaseV2TooManyRequests) String() string {
	return fmt.Sprintf("[POST /message-center/entities/case/v2][%d] createCaseV2TooManyRequests  %+v", 429, o.Payload)
}

func (o *CreateCaseV2TooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CreateCaseV2TooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateCaseV2InternalServerError creates a CreateCaseV2InternalServerError with default headers values
func NewCreateCaseV2InternalServerError() *CreateCaseV2InternalServerError {
	return &CreateCaseV2InternalServerError{}
}

/*
CreateCaseV2InternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type CreateCaseV2InternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this create case v2 internal server error response has a 2xx status code
func (o *CreateCaseV2InternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create case v2 internal server error response has a 3xx status code
func (o *CreateCaseV2InternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create case v2 internal server error response has a 4xx status code
func (o *CreateCaseV2InternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this create case v2 internal server error response has a 5xx status code
func (o *CreateCaseV2InternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this create case v2 internal server error response a status code equal to that given
func (o *CreateCaseV2InternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the create case v2 internal server error response
func (o *CreateCaseV2InternalServerError) Code() int {
	return 500
}

func (o *CreateCaseV2InternalServerError) Error() string {
	return fmt.Sprintf("[POST /message-center/entities/case/v2][%d] createCaseV2InternalServerError  %+v", 500, o.Payload)
}

func (o *CreateCaseV2InternalServerError) String() string {
	return fmt.Sprintf("[POST /message-center/entities/case/v2][%d] createCaseV2InternalServerError  %+v", 500, o.Payload)
}

func (o *CreateCaseV2InternalServerError) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CreateCaseV2InternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
