// Code generated by go-swagger; DO NOT EDIT.

package message_center

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetCaseActivityByIdsReader is a Reader for the GetCaseActivityByIds structure.
type GetCaseActivityByIdsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetCaseActivityByIdsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetCaseActivityByIdsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetCaseActivityByIdsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetCaseActivityByIdsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetCaseActivityByIdsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetCaseActivityByIdsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /message-center/entities/case-activities/GET/v1] GetCaseActivityByIds", response, response.Code())
	}
}

// NewGetCaseActivityByIdsOK creates a GetCaseActivityByIdsOK with default headers values
func NewGetCaseActivityByIdsOK() *GetCaseActivityByIdsOK {
	return &GetCaseActivityByIdsOK{}
}

/*
GetCaseActivityByIdsOK describes a response with status code 200, with default header values.

OK
*/
type GetCaseActivityByIdsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.APIMessageCenterActivityResponse
}

// IsSuccess returns true when this get case activity by ids o k response has a 2xx status code
func (o *GetCaseActivityByIdsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get case activity by ids o k response has a 3xx status code
func (o *GetCaseActivityByIdsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get case activity by ids o k response has a 4xx status code
func (o *GetCaseActivityByIdsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get case activity by ids o k response has a 5xx status code
func (o *GetCaseActivityByIdsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get case activity by ids o k response a status code equal to that given
func (o *GetCaseActivityByIdsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get case activity by ids o k response
func (o *GetCaseActivityByIdsOK) Code() int {
	return 200
}

func (o *GetCaseActivityByIdsOK) Error() string {
	return fmt.Sprintf("[POST /message-center/entities/case-activities/GET/v1][%d] getCaseActivityByIdsOK  %+v", 200, o.Payload)
}

func (o *GetCaseActivityByIdsOK) String() string {
	return fmt.Sprintf("[POST /message-center/entities/case-activities/GET/v1][%d] getCaseActivityByIdsOK  %+v", 200, o.Payload)
}

func (o *GetCaseActivityByIdsOK) GetPayload() *models.APIMessageCenterActivityResponse {
	return o.Payload
}

func (o *GetCaseActivityByIdsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.APIMessageCenterActivityResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCaseActivityByIdsBadRequest creates a GetCaseActivityByIdsBadRequest with default headers values
func NewGetCaseActivityByIdsBadRequest() *GetCaseActivityByIdsBadRequest {
	return &GetCaseActivityByIdsBadRequest{}
}

/*
GetCaseActivityByIdsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetCaseActivityByIdsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get case activity by ids bad request response has a 2xx status code
func (o *GetCaseActivityByIdsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get case activity by ids bad request response has a 3xx status code
func (o *GetCaseActivityByIdsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get case activity by ids bad request response has a 4xx status code
func (o *GetCaseActivityByIdsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get case activity by ids bad request response has a 5xx status code
func (o *GetCaseActivityByIdsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get case activity by ids bad request response a status code equal to that given
func (o *GetCaseActivityByIdsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get case activity by ids bad request response
func (o *GetCaseActivityByIdsBadRequest) Code() int {
	return 400
}

func (o *GetCaseActivityByIdsBadRequest) Error() string {
	return fmt.Sprintf("[POST /message-center/entities/case-activities/GET/v1][%d] getCaseActivityByIdsBadRequest  %+v", 400, o.Payload)
}

func (o *GetCaseActivityByIdsBadRequest) String() string {
	return fmt.Sprintf("[POST /message-center/entities/case-activities/GET/v1][%d] getCaseActivityByIdsBadRequest  %+v", 400, o.Payload)
}

func (o *GetCaseActivityByIdsBadRequest) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetCaseActivityByIdsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCaseActivityByIdsForbidden creates a GetCaseActivityByIdsForbidden with default headers values
func NewGetCaseActivityByIdsForbidden() *GetCaseActivityByIdsForbidden {
	return &GetCaseActivityByIdsForbidden{}
}

/*
GetCaseActivityByIdsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetCaseActivityByIdsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get case activity by ids forbidden response has a 2xx status code
func (o *GetCaseActivityByIdsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get case activity by ids forbidden response has a 3xx status code
func (o *GetCaseActivityByIdsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get case activity by ids forbidden response has a 4xx status code
func (o *GetCaseActivityByIdsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get case activity by ids forbidden response has a 5xx status code
func (o *GetCaseActivityByIdsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get case activity by ids forbidden response a status code equal to that given
func (o *GetCaseActivityByIdsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get case activity by ids forbidden response
func (o *GetCaseActivityByIdsForbidden) Code() int {
	return 403
}

func (o *GetCaseActivityByIdsForbidden) Error() string {
	return fmt.Sprintf("[POST /message-center/entities/case-activities/GET/v1][%d] getCaseActivityByIdsForbidden  %+v", 403, o.Payload)
}

func (o *GetCaseActivityByIdsForbidden) String() string {
	return fmt.Sprintf("[POST /message-center/entities/case-activities/GET/v1][%d] getCaseActivityByIdsForbidden  %+v", 403, o.Payload)
}

func (o *GetCaseActivityByIdsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetCaseActivityByIdsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCaseActivityByIdsTooManyRequests creates a GetCaseActivityByIdsTooManyRequests with default headers values
func NewGetCaseActivityByIdsTooManyRequests() *GetCaseActivityByIdsTooManyRequests {
	return &GetCaseActivityByIdsTooManyRequests{}
}

/*
GetCaseActivityByIdsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetCaseActivityByIdsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get case activity by ids too many requests response has a 2xx status code
func (o *GetCaseActivityByIdsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get case activity by ids too many requests response has a 3xx status code
func (o *GetCaseActivityByIdsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get case activity by ids too many requests response has a 4xx status code
func (o *GetCaseActivityByIdsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get case activity by ids too many requests response has a 5xx status code
func (o *GetCaseActivityByIdsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get case activity by ids too many requests response a status code equal to that given
func (o *GetCaseActivityByIdsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get case activity by ids too many requests response
func (o *GetCaseActivityByIdsTooManyRequests) Code() int {
	return 429
}

func (o *GetCaseActivityByIdsTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /message-center/entities/case-activities/GET/v1][%d] getCaseActivityByIdsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetCaseActivityByIdsTooManyRequests) String() string {
	return fmt.Sprintf("[POST /message-center/entities/case-activities/GET/v1][%d] getCaseActivityByIdsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetCaseActivityByIdsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetCaseActivityByIdsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCaseActivityByIdsInternalServerError creates a GetCaseActivityByIdsInternalServerError with default headers values
func NewGetCaseActivityByIdsInternalServerError() *GetCaseActivityByIdsInternalServerError {
	return &GetCaseActivityByIdsInternalServerError{}
}

/*
GetCaseActivityByIdsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetCaseActivityByIdsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get case activity by ids internal server error response has a 2xx status code
func (o *GetCaseActivityByIdsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get case activity by ids internal server error response has a 3xx status code
func (o *GetCaseActivityByIdsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get case activity by ids internal server error response has a 4xx status code
func (o *GetCaseActivityByIdsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get case activity by ids internal server error response has a 5xx status code
func (o *GetCaseActivityByIdsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get case activity by ids internal server error response a status code equal to that given
func (o *GetCaseActivityByIdsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get case activity by ids internal server error response
func (o *GetCaseActivityByIdsInternalServerError) Code() int {
	return 500
}

func (o *GetCaseActivityByIdsInternalServerError) Error() string {
	return fmt.Sprintf("[POST /message-center/entities/case-activities/GET/v1][%d] getCaseActivityByIdsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetCaseActivityByIdsInternalServerError) String() string {
	return fmt.Sprintf("[POST /message-center/entities/case-activities/GET/v1][%d] getCaseActivityByIdsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetCaseActivityByIdsInternalServerError) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetCaseActivityByIdsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
