// Code generated by go-swagger; DO NOT EDIT.

package message_center

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new message center API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for message center API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	AggregateCases(params *AggregateCasesParams, opts ...ClientOption) (*AggregateCasesOK, error)

	CaseAddActivity(params *CaseAddActivityParams, opts ...ClientOption) (*CaseAddActivityOK, error)

	CaseAddAttachment(params *CaseAddAttachmentParams, opts ...ClientOption) (*CaseAddAttachmentOK, error)

	CaseDownloadAttachment(params *CaseDownloadAttachmentParams, opts ...ClientOption) (*CaseDownloadAttachmentOK, error)

	CreateCase(params *CreateCaseParams, opts ...ClientOption) (*CreateCaseOK, error)

	CreateCaseV2(params *CreateCaseV2Params, opts ...ClientOption) (*CreateCaseV2OK, error)

	GetCaseActivityByIds(params *GetCaseActivityByIdsParams, opts ...ClientOption) (*GetCaseActivityByIdsOK, error)

	GetCaseEntitiesByIDs(params *GetCaseEntitiesByIDsParams, opts ...ClientOption) (*GetCaseEntitiesByIDsOK, error)

	QueryActivityByCaseID(params *QueryActivityByCaseIDParams, opts ...ClientOption) (*QueryActivityByCaseIDOK, error)

	QueryCasesIdsByFilter(params *QueryCasesIdsByFilterParams, opts ...ClientOption) (*QueryCasesIdsByFilterOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
AggregateCases retrieves aggregate case values based on the matched filter
*/
func (a *Client) AggregateCases(params *AggregateCasesParams, opts ...ClientOption) (*AggregateCasesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAggregateCasesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "AggregateCases",
		Method:             "POST",
		PathPattern:        "/message-center/aggregates/cases/GET/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AggregateCasesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AggregateCasesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for AggregateCases: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
CaseAddActivity adds an activity to case only activities of type comment are allowed via API
*/
func (a *Client) CaseAddActivity(params *CaseAddActivityParams, opts ...ClientOption) (*CaseAddActivityOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCaseAddActivityParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CaseAddActivity",
		Method:             "POST",
		PathPattern:        "/message-center/entities/case-activity/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CaseAddActivityReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CaseAddActivityOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for CaseAddActivity: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
	 CaseAddAttachment uploads an attachment for the case

	 Upload an attachment for the case. Maximum upload size allowed is *15 MB*.

	Filename must start with *[a-zA-Z0-9_-]*. Allowed characters in file name are *[a-zA-Z0-9-_.\s]*.

	Maximum file name is *255* characters



	Following attachment types are allowed:

- png

- bmp

- jpg

- jpeg

- gif

- pdf

- doc

- docx

- xls

- xlsx

- pptx

- txt

- csv
*/
func (a *Client) CaseAddAttachment(params *CaseAddAttachmentParams, opts ...ClientOption) (*CaseAddAttachmentOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCaseAddAttachmentParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CaseAddAttachment",
		Method:             "POST",
		PathPattern:        "/message-center/entities/case-attachment/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"multipart/form-data"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CaseAddAttachmentReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CaseAddAttachmentOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for CaseAddAttachment: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
CaseDownloadAttachment retrieves an attachment for the case given the attachment id
*/
func (a *Client) CaseDownloadAttachment(params *CaseDownloadAttachmentParams, opts ...ClientOption) (*CaseDownloadAttachmentOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCaseDownloadAttachmentParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CaseDownloadAttachment",
		Method:             "GET",
		PathPattern:        "/message-center/entities/case-attachment/v1",
		ProducesMediaTypes: []string{"application/json", "application/msword", "application/pdf", "application/vnd.ms-excel", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/zip", "image/bmp", "image/gif", "image/jpeg", "image/jpg", "image/png", "text/plain"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CaseDownloadAttachmentReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CaseDownloadAttachmentOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for CaseDownloadAttachment: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
CreateCase creates a new case
*/
func (a *Client) CreateCase(params *CreateCaseParams, opts ...ClientOption) (*CreateCaseOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateCaseParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateCase",
		Method:             "POST",
		PathPattern:        "/message-center/entities/case/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CreateCaseReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateCaseOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for CreateCase: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
CreateCaseV2 creates a new case
*/
func (a *Client) CreateCaseV2(params *CreateCaseV2Params, opts ...ClientOption) (*CreateCaseV2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateCaseV2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateCaseV2",
		Method:             "POST",
		PathPattern:        "/message-center/entities/case/v2",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CreateCaseV2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateCaseV2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for CreateCaseV2: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetCaseActivityByIds retrieves activities for given id s
*/
func (a *Client) GetCaseActivityByIds(params *GetCaseActivityByIdsParams, opts ...ClientOption) (*GetCaseActivityByIdsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetCaseActivityByIdsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetCaseActivityByIds",
		Method:             "POST",
		PathPattern:        "/message-center/entities/case-activities/GET/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetCaseActivityByIdsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetCaseActivityByIdsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetCaseActivityByIds: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetCaseEntitiesByIDs retrieves message center cases
*/
func (a *Client) GetCaseEntitiesByIDs(params *GetCaseEntitiesByIDsParams, opts ...ClientOption) (*GetCaseEntitiesByIDsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetCaseEntitiesByIDsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetCaseEntitiesByIDs",
		Method:             "POST",
		PathPattern:        "/message-center/entities/cases/GET/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetCaseEntitiesByIDsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetCaseEntitiesByIDsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetCaseEntitiesByIDs: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryActivityByCaseID retrieves activities id s for a case
*/
func (a *Client) QueryActivityByCaseID(params *QueryActivityByCaseIDParams, opts ...ClientOption) (*QueryActivityByCaseIDOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryActivityByCaseIDParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "QueryActivityByCaseID",
		Method:             "GET",
		PathPattern:        "/message-center/queries/case-activities/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryActivityByCaseIDReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryActivityByCaseIDOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for QueryActivityByCaseID: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryCasesIdsByFilter retrieves case id s that match the provided filter criteria
*/
func (a *Client) QueryCasesIdsByFilter(params *QueryCasesIdsByFilterParams, opts ...ClientOption) (*QueryCasesIdsByFilterOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryCasesIdsByFilterParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "QueryCasesIdsByFilter",
		Method:             "GET",
		PathPattern:        "/message-center/queries/cases/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryCasesIdsByFilterReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryCasesIdsByFilterOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for QueryCasesIdsByFilter: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
