// Code generated by go-swagger; DO NOT EDIT.

package message_center

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// QueryCasesIdsByFilterReader is a Reader for the QueryCasesIdsByFilter structure.
type QueryCasesIdsByFilterReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QueryCasesIdsByFilterReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQueryCasesIdsByFilterOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewQueryCasesIdsByFilterBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewQueryCasesIdsByFilterForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewQueryCasesIdsByFilterTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewQueryCasesIdsByFilterInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /message-center/queries/cases/v1] QueryCasesIdsByFilter", response, response.Code())
	}
}

// NewQueryCasesIdsByFilterOK creates a QueryCasesIdsByFilterOK with default headers values
func NewQueryCasesIdsByFilterOK() *QueryCasesIdsByFilterOK {
	return &QueryCasesIdsByFilterOK{}
}

/*
QueryCasesIdsByFilterOK describes a response with status code 200, with default header values.

OK
*/
type QueryCasesIdsByFilterOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this query cases ids by filter o k response has a 2xx status code
func (o *QueryCasesIdsByFilterOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query cases ids by filter o k response has a 3xx status code
func (o *QueryCasesIdsByFilterOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query cases ids by filter o k response has a 4xx status code
func (o *QueryCasesIdsByFilterOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query cases ids by filter o k response has a 5xx status code
func (o *QueryCasesIdsByFilterOK) IsServerError() bool {
	return false
}

// IsCode returns true when this query cases ids by filter o k response a status code equal to that given
func (o *QueryCasesIdsByFilterOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query cases ids by filter o k response
func (o *QueryCasesIdsByFilterOK) Code() int {
	return 200
}

func (o *QueryCasesIdsByFilterOK) Error() string {
	return fmt.Sprintf("[GET /message-center/queries/cases/v1][%d] queryCasesIdsByFilterOK  %+v", 200, o.Payload)
}

func (o *QueryCasesIdsByFilterOK) String() string {
	return fmt.Sprintf("[GET /message-center/queries/cases/v1][%d] queryCasesIdsByFilterOK  %+v", 200, o.Payload)
}

func (o *QueryCasesIdsByFilterOK) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *QueryCasesIdsByFilterOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCasesIdsByFilterBadRequest creates a QueryCasesIdsByFilterBadRequest with default headers values
func NewQueryCasesIdsByFilterBadRequest() *QueryCasesIdsByFilterBadRequest {
	return &QueryCasesIdsByFilterBadRequest{}
}

/*
QueryCasesIdsByFilterBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type QueryCasesIdsByFilterBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query cases ids by filter bad request response has a 2xx status code
func (o *QueryCasesIdsByFilterBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query cases ids by filter bad request response has a 3xx status code
func (o *QueryCasesIdsByFilterBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query cases ids by filter bad request response has a 4xx status code
func (o *QueryCasesIdsByFilterBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this query cases ids by filter bad request response has a 5xx status code
func (o *QueryCasesIdsByFilterBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this query cases ids by filter bad request response a status code equal to that given
func (o *QueryCasesIdsByFilterBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the query cases ids by filter bad request response
func (o *QueryCasesIdsByFilterBadRequest) Code() int {
	return 400
}

func (o *QueryCasesIdsByFilterBadRequest) Error() string {
	return fmt.Sprintf("[GET /message-center/queries/cases/v1][%d] queryCasesIdsByFilterBadRequest  %+v", 400, o.Payload)
}

func (o *QueryCasesIdsByFilterBadRequest) String() string {
	return fmt.Sprintf("[GET /message-center/queries/cases/v1][%d] queryCasesIdsByFilterBadRequest  %+v", 400, o.Payload)
}

func (o *QueryCasesIdsByFilterBadRequest) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryCasesIdsByFilterBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCasesIdsByFilterForbidden creates a QueryCasesIdsByFilterForbidden with default headers values
func NewQueryCasesIdsByFilterForbidden() *QueryCasesIdsByFilterForbidden {
	return &QueryCasesIdsByFilterForbidden{}
}

/*
QueryCasesIdsByFilterForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type QueryCasesIdsByFilterForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query cases ids by filter forbidden response has a 2xx status code
func (o *QueryCasesIdsByFilterForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query cases ids by filter forbidden response has a 3xx status code
func (o *QueryCasesIdsByFilterForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query cases ids by filter forbidden response has a 4xx status code
func (o *QueryCasesIdsByFilterForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this query cases ids by filter forbidden response has a 5xx status code
func (o *QueryCasesIdsByFilterForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this query cases ids by filter forbidden response a status code equal to that given
func (o *QueryCasesIdsByFilterForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the query cases ids by filter forbidden response
func (o *QueryCasesIdsByFilterForbidden) Code() int {
	return 403
}

func (o *QueryCasesIdsByFilterForbidden) Error() string {
	return fmt.Sprintf("[GET /message-center/queries/cases/v1][%d] queryCasesIdsByFilterForbidden  %+v", 403, o.Payload)
}

func (o *QueryCasesIdsByFilterForbidden) String() string {
	return fmt.Sprintf("[GET /message-center/queries/cases/v1][%d] queryCasesIdsByFilterForbidden  %+v", 403, o.Payload)
}

func (o *QueryCasesIdsByFilterForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryCasesIdsByFilterForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCasesIdsByFilterTooManyRequests creates a QueryCasesIdsByFilterTooManyRequests with default headers values
func NewQueryCasesIdsByFilterTooManyRequests() *QueryCasesIdsByFilterTooManyRequests {
	return &QueryCasesIdsByFilterTooManyRequests{}
}

/*
QueryCasesIdsByFilterTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type QueryCasesIdsByFilterTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query cases ids by filter too many requests response has a 2xx status code
func (o *QueryCasesIdsByFilterTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query cases ids by filter too many requests response has a 3xx status code
func (o *QueryCasesIdsByFilterTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query cases ids by filter too many requests response has a 4xx status code
func (o *QueryCasesIdsByFilterTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this query cases ids by filter too many requests response has a 5xx status code
func (o *QueryCasesIdsByFilterTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this query cases ids by filter too many requests response a status code equal to that given
func (o *QueryCasesIdsByFilterTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the query cases ids by filter too many requests response
func (o *QueryCasesIdsByFilterTooManyRequests) Code() int {
	return 429
}

func (o *QueryCasesIdsByFilterTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /message-center/queries/cases/v1][%d] queryCasesIdsByFilterTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryCasesIdsByFilterTooManyRequests) String() string {
	return fmt.Sprintf("[GET /message-center/queries/cases/v1][%d] queryCasesIdsByFilterTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryCasesIdsByFilterTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryCasesIdsByFilterTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCasesIdsByFilterInternalServerError creates a QueryCasesIdsByFilterInternalServerError with default headers values
func NewQueryCasesIdsByFilterInternalServerError() *QueryCasesIdsByFilterInternalServerError {
	return &QueryCasesIdsByFilterInternalServerError{}
}

/*
QueryCasesIdsByFilterInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type QueryCasesIdsByFilterInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query cases ids by filter internal server error response has a 2xx status code
func (o *QueryCasesIdsByFilterInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query cases ids by filter internal server error response has a 3xx status code
func (o *QueryCasesIdsByFilterInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query cases ids by filter internal server error response has a 4xx status code
func (o *QueryCasesIdsByFilterInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this query cases ids by filter internal server error response has a 5xx status code
func (o *QueryCasesIdsByFilterInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this query cases ids by filter internal server error response a status code equal to that given
func (o *QueryCasesIdsByFilterInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the query cases ids by filter internal server error response
func (o *QueryCasesIdsByFilterInternalServerError) Code() int {
	return 500
}

func (o *QueryCasesIdsByFilterInternalServerError) Error() string {
	return fmt.Sprintf("[GET /message-center/queries/cases/v1][%d] queryCasesIdsByFilterInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryCasesIdsByFilterInternalServerError) String() string {
	return fmt.Sprintf("[GET /message-center/queries/cases/v1][%d] queryCasesIdsByFilterInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryCasesIdsByFilterInternalServerError) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryCasesIdsByFilterInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
