// Code generated by go-swagger; DO NOT EDIT.

package ml_exclusions

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDeleteMLExclusionsV1Params creates a new DeleteMLExclusionsV1Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDeleteMLExclusionsV1Params() *DeleteMLExclusionsV1Params {
	return &DeleteMLExclusionsV1Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewDeleteMLExclusionsV1ParamsWithTimeout creates a new DeleteMLExclusionsV1Params object
// with the ability to set a timeout on a request.
func NewDeleteMLExclusionsV1ParamsWithTimeout(timeout time.Duration) *DeleteMLExclusionsV1Params {
	return &DeleteMLExclusionsV1Params{
		timeout: timeout,
	}
}

// NewDeleteMLExclusionsV1ParamsWithContext creates a new DeleteMLExclusionsV1Params object
// with the ability to set a context for a request.
func NewDeleteMLExclusionsV1ParamsWithContext(ctx context.Context) *DeleteMLExclusionsV1Params {
	return &DeleteMLExclusionsV1Params{
		Context: ctx,
	}
}

// NewDeleteMLExclusionsV1ParamsWithHTTPClient creates a new DeleteMLExclusionsV1Params object
// with the ability to set a custom HTTPClient for a request.
func NewDeleteMLExclusionsV1ParamsWithHTTPClient(client *http.Client) *DeleteMLExclusionsV1Params {
	return &DeleteMLExclusionsV1Params{
		HTTPClient: client,
	}
}

/*
DeleteMLExclusionsV1Params contains all the parameters to send to the API endpoint

	for the delete m l exclusions v1 operation.

	Typically these are written to a http.Request.
*/
type DeleteMLExclusionsV1Params struct {

	/* Comment.

	   Explains why this exclusions was deleted
	*/
	Comment *string

	/* Ids.

	   The ids of the exclusions to delete
	*/
	Ids []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the delete m l exclusions v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteMLExclusionsV1Params) WithDefaults() *DeleteMLExclusionsV1Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the delete m l exclusions v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteMLExclusionsV1Params) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the delete m l exclusions v1 params
func (o *DeleteMLExclusionsV1Params) WithTimeout(timeout time.Duration) *DeleteMLExclusionsV1Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the delete m l exclusions v1 params
func (o *DeleteMLExclusionsV1Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the delete m l exclusions v1 params
func (o *DeleteMLExclusionsV1Params) WithContext(ctx context.Context) *DeleteMLExclusionsV1Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the delete m l exclusions v1 params
func (o *DeleteMLExclusionsV1Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the delete m l exclusions v1 params
func (o *DeleteMLExclusionsV1Params) WithHTTPClient(client *http.Client) *DeleteMLExclusionsV1Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the delete m l exclusions v1 params
func (o *DeleteMLExclusionsV1Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithComment adds the comment to the delete m l exclusions v1 params
func (o *DeleteMLExclusionsV1Params) WithComment(comment *string) *DeleteMLExclusionsV1Params {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the delete m l exclusions v1 params
func (o *DeleteMLExclusionsV1Params) SetComment(comment *string) {
	o.Comment = comment
}

// WithIds adds the ids to the delete m l exclusions v1 params
func (o *DeleteMLExclusionsV1Params) WithIds(ids []string) *DeleteMLExclusionsV1Params {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the delete m l exclusions v1 params
func (o *DeleteMLExclusionsV1Params) SetIds(ids []string) {
	o.Ids = ids
}

// WriteToRequest writes these params to a swagger request
func (o *DeleteMLExclusionsV1Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDeleteMLExclusionsV1 binds the parameter ids
func (o *DeleteMLExclusionsV1Params) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}
