// Code generated by go-swagger; DO NOT EDIT.

package ml_exclusions

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// DeleteMLExclusionsV1Reader is a Reader for the DeleteMLExclusionsV1 structure.
type DeleteMLExclusionsV1Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteMLExclusionsV1Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeleteMLExclusionsV1OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewDeleteMLExclusionsV1BadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewDeleteMLExclusionsV1Forbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewDeleteMLExclusionsV1TooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewDeleteMLExclusionsV1InternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[DELETE /policy/entities/ml-exclusions/v1] deleteMLExclusionsV1", response, response.Code())
	}
}

// NewDeleteMLExclusionsV1OK creates a DeleteMLExclusionsV1OK with default headers values
func NewDeleteMLExclusionsV1OK() *DeleteMLExclusionsV1OK {
	return &DeleteMLExclusionsV1OK{}
}

/*
DeleteMLExclusionsV1OK describes a response with status code 200, with default header values.

OK
*/
type DeleteMLExclusionsV1OK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ExclusionsRespV1
}

// IsSuccess returns true when this delete m l exclusions v1 o k response has a 2xx status code
func (o *DeleteMLExclusionsV1OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete m l exclusions v1 o k response has a 3xx status code
func (o *DeleteMLExclusionsV1OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete m l exclusions v1 o k response has a 4xx status code
func (o *DeleteMLExclusionsV1OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete m l exclusions v1 o k response has a 5xx status code
func (o *DeleteMLExclusionsV1OK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete m l exclusions v1 o k response a status code equal to that given
func (o *DeleteMLExclusionsV1OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the delete m l exclusions v1 o k response
func (o *DeleteMLExclusionsV1OK) Code() int {
	return 200
}

func (o *DeleteMLExclusionsV1OK) Error() string {
	return fmt.Sprintf("[DELETE /policy/entities/ml-exclusions/v1][%d] deleteMLExclusionsV1OK  %+v", 200, o.Payload)
}

func (o *DeleteMLExclusionsV1OK) String() string {
	return fmt.Sprintf("[DELETE /policy/entities/ml-exclusions/v1][%d] deleteMLExclusionsV1OK  %+v", 200, o.Payload)
}

func (o *DeleteMLExclusionsV1OK) GetPayload() *models.ExclusionsRespV1 {
	return o.Payload
}

func (o *DeleteMLExclusionsV1OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ExclusionsRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteMLExclusionsV1BadRequest creates a DeleteMLExclusionsV1BadRequest with default headers values
func NewDeleteMLExclusionsV1BadRequest() *DeleteMLExclusionsV1BadRequest {
	return &DeleteMLExclusionsV1BadRequest{}
}

/*
DeleteMLExclusionsV1BadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type DeleteMLExclusionsV1BadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ExclusionsRespV1
}

// IsSuccess returns true when this delete m l exclusions v1 bad request response has a 2xx status code
func (o *DeleteMLExclusionsV1BadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete m l exclusions v1 bad request response has a 3xx status code
func (o *DeleteMLExclusionsV1BadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete m l exclusions v1 bad request response has a 4xx status code
func (o *DeleteMLExclusionsV1BadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete m l exclusions v1 bad request response has a 5xx status code
func (o *DeleteMLExclusionsV1BadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this delete m l exclusions v1 bad request response a status code equal to that given
func (o *DeleteMLExclusionsV1BadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the delete m l exclusions v1 bad request response
func (o *DeleteMLExclusionsV1BadRequest) Code() int {
	return 400
}

func (o *DeleteMLExclusionsV1BadRequest) Error() string {
	return fmt.Sprintf("[DELETE /policy/entities/ml-exclusions/v1][%d] deleteMLExclusionsV1BadRequest  %+v", 400, o.Payload)
}

func (o *DeleteMLExclusionsV1BadRequest) String() string {
	return fmt.Sprintf("[DELETE /policy/entities/ml-exclusions/v1][%d] deleteMLExclusionsV1BadRequest  %+v", 400, o.Payload)
}

func (o *DeleteMLExclusionsV1BadRequest) GetPayload() *models.ExclusionsRespV1 {
	return o.Payload
}

func (o *DeleteMLExclusionsV1BadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ExclusionsRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteMLExclusionsV1Forbidden creates a DeleteMLExclusionsV1Forbidden with default headers values
func NewDeleteMLExclusionsV1Forbidden() *DeleteMLExclusionsV1Forbidden {
	return &DeleteMLExclusionsV1Forbidden{}
}

/*
DeleteMLExclusionsV1Forbidden describes a response with status code 403, with default header values.

Forbidden
*/
type DeleteMLExclusionsV1Forbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this delete m l exclusions v1 forbidden response has a 2xx status code
func (o *DeleteMLExclusionsV1Forbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete m l exclusions v1 forbidden response has a 3xx status code
func (o *DeleteMLExclusionsV1Forbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete m l exclusions v1 forbidden response has a 4xx status code
func (o *DeleteMLExclusionsV1Forbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete m l exclusions v1 forbidden response has a 5xx status code
func (o *DeleteMLExclusionsV1Forbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this delete m l exclusions v1 forbidden response a status code equal to that given
func (o *DeleteMLExclusionsV1Forbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the delete m l exclusions v1 forbidden response
func (o *DeleteMLExclusionsV1Forbidden) Code() int {
	return 403
}

func (o *DeleteMLExclusionsV1Forbidden) Error() string {
	return fmt.Sprintf("[DELETE /policy/entities/ml-exclusions/v1][%d] deleteMLExclusionsV1Forbidden  %+v", 403, o.Payload)
}

func (o *DeleteMLExclusionsV1Forbidden) String() string {
	return fmt.Sprintf("[DELETE /policy/entities/ml-exclusions/v1][%d] deleteMLExclusionsV1Forbidden  %+v", 403, o.Payload)
}

func (o *DeleteMLExclusionsV1Forbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *DeleteMLExclusionsV1Forbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteMLExclusionsV1TooManyRequests creates a DeleteMLExclusionsV1TooManyRequests with default headers values
func NewDeleteMLExclusionsV1TooManyRequests() *DeleteMLExclusionsV1TooManyRequests {
	return &DeleteMLExclusionsV1TooManyRequests{}
}

/*
DeleteMLExclusionsV1TooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type DeleteMLExclusionsV1TooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this delete m l exclusions v1 too many requests response has a 2xx status code
func (o *DeleteMLExclusionsV1TooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete m l exclusions v1 too many requests response has a 3xx status code
func (o *DeleteMLExclusionsV1TooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete m l exclusions v1 too many requests response has a 4xx status code
func (o *DeleteMLExclusionsV1TooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete m l exclusions v1 too many requests response has a 5xx status code
func (o *DeleteMLExclusionsV1TooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this delete m l exclusions v1 too many requests response a status code equal to that given
func (o *DeleteMLExclusionsV1TooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the delete m l exclusions v1 too many requests response
func (o *DeleteMLExclusionsV1TooManyRequests) Code() int {
	return 429
}

func (o *DeleteMLExclusionsV1TooManyRequests) Error() string {
	return fmt.Sprintf("[DELETE /policy/entities/ml-exclusions/v1][%d] deleteMLExclusionsV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *DeleteMLExclusionsV1TooManyRequests) String() string {
	return fmt.Sprintf("[DELETE /policy/entities/ml-exclusions/v1][%d] deleteMLExclusionsV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *DeleteMLExclusionsV1TooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *DeleteMLExclusionsV1TooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteMLExclusionsV1InternalServerError creates a DeleteMLExclusionsV1InternalServerError with default headers values
func NewDeleteMLExclusionsV1InternalServerError() *DeleteMLExclusionsV1InternalServerError {
	return &DeleteMLExclusionsV1InternalServerError{}
}

/*
DeleteMLExclusionsV1InternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type DeleteMLExclusionsV1InternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ExclusionsRespV1
}

// IsSuccess returns true when this delete m l exclusions v1 internal server error response has a 2xx status code
func (o *DeleteMLExclusionsV1InternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete m l exclusions v1 internal server error response has a 3xx status code
func (o *DeleteMLExclusionsV1InternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete m l exclusions v1 internal server error response has a 4xx status code
func (o *DeleteMLExclusionsV1InternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete m l exclusions v1 internal server error response has a 5xx status code
func (o *DeleteMLExclusionsV1InternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this delete m l exclusions v1 internal server error response a status code equal to that given
func (o *DeleteMLExclusionsV1InternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the delete m l exclusions v1 internal server error response
func (o *DeleteMLExclusionsV1InternalServerError) Code() int {
	return 500
}

func (o *DeleteMLExclusionsV1InternalServerError) Error() string {
	return fmt.Sprintf("[DELETE /policy/entities/ml-exclusions/v1][%d] deleteMLExclusionsV1InternalServerError  %+v", 500, o.Payload)
}

func (o *DeleteMLExclusionsV1InternalServerError) String() string {
	return fmt.Sprintf("[DELETE /policy/entities/ml-exclusions/v1][%d] deleteMLExclusionsV1InternalServerError  %+v", 500, o.Payload)
}

func (o *DeleteMLExclusionsV1InternalServerError) GetPayload() *models.ExclusionsRespV1 {
	return o.Payload
}

func (o *DeleteMLExclusionsV1InternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ExclusionsRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
