// Code generated by go-swagger; DO NOT EDIT.

package ml_exclusions

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetMLExclusionsV1Reader is a Reader for the GetMLExclusionsV1 structure.
type GetMLExclusionsV1Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetMLExclusionsV1Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetMLExclusionsV1OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetMLExclusionsV1BadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetMLExclusionsV1Forbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetMLExclusionsV1TooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetMLExclusionsV1InternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /policy/entities/ml-exclusions/v1] getMLExclusionsV1", response, response.Code())
	}
}

// NewGetMLExclusionsV1OK creates a GetMLExclusionsV1OK with default headers values
func NewGetMLExclusionsV1OK() *GetMLExclusionsV1OK {
	return &GetMLExclusionsV1OK{}
}

/*
GetMLExclusionsV1OK describes a response with status code 200, with default header values.

OK
*/
type GetMLExclusionsV1OK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ExclusionsRespV1
}

// IsSuccess returns true when this get m l exclusions v1 o k response has a 2xx status code
func (o *GetMLExclusionsV1OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get m l exclusions v1 o k response has a 3xx status code
func (o *GetMLExclusionsV1OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get m l exclusions v1 o k response has a 4xx status code
func (o *GetMLExclusionsV1OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get m l exclusions v1 o k response has a 5xx status code
func (o *GetMLExclusionsV1OK) IsServerError() bool {
	return false
}

// IsCode returns true when this get m l exclusions v1 o k response a status code equal to that given
func (o *GetMLExclusionsV1OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get m l exclusions v1 o k response
func (o *GetMLExclusionsV1OK) Code() int {
	return 200
}

func (o *GetMLExclusionsV1OK) Error() string {
	return fmt.Sprintf("[GET /policy/entities/ml-exclusions/v1][%d] getMLExclusionsV1OK  %+v", 200, o.Payload)
}

func (o *GetMLExclusionsV1OK) String() string {
	return fmt.Sprintf("[GET /policy/entities/ml-exclusions/v1][%d] getMLExclusionsV1OK  %+v", 200, o.Payload)
}

func (o *GetMLExclusionsV1OK) GetPayload() *models.ExclusionsRespV1 {
	return o.Payload
}

func (o *GetMLExclusionsV1OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ExclusionsRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetMLExclusionsV1BadRequest creates a GetMLExclusionsV1BadRequest with default headers values
func NewGetMLExclusionsV1BadRequest() *GetMLExclusionsV1BadRequest {
	return &GetMLExclusionsV1BadRequest{}
}

/*
GetMLExclusionsV1BadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetMLExclusionsV1BadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ExclusionsRespV1
}

// IsSuccess returns true when this get m l exclusions v1 bad request response has a 2xx status code
func (o *GetMLExclusionsV1BadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get m l exclusions v1 bad request response has a 3xx status code
func (o *GetMLExclusionsV1BadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get m l exclusions v1 bad request response has a 4xx status code
func (o *GetMLExclusionsV1BadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get m l exclusions v1 bad request response has a 5xx status code
func (o *GetMLExclusionsV1BadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get m l exclusions v1 bad request response a status code equal to that given
func (o *GetMLExclusionsV1BadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get m l exclusions v1 bad request response
func (o *GetMLExclusionsV1BadRequest) Code() int {
	return 400
}

func (o *GetMLExclusionsV1BadRequest) Error() string {
	return fmt.Sprintf("[GET /policy/entities/ml-exclusions/v1][%d] getMLExclusionsV1BadRequest  %+v", 400, o.Payload)
}

func (o *GetMLExclusionsV1BadRequest) String() string {
	return fmt.Sprintf("[GET /policy/entities/ml-exclusions/v1][%d] getMLExclusionsV1BadRequest  %+v", 400, o.Payload)
}

func (o *GetMLExclusionsV1BadRequest) GetPayload() *models.ExclusionsRespV1 {
	return o.Payload
}

func (o *GetMLExclusionsV1BadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ExclusionsRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetMLExclusionsV1Forbidden creates a GetMLExclusionsV1Forbidden with default headers values
func NewGetMLExclusionsV1Forbidden() *GetMLExclusionsV1Forbidden {
	return &GetMLExclusionsV1Forbidden{}
}

/*
GetMLExclusionsV1Forbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetMLExclusionsV1Forbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this get m l exclusions v1 forbidden response has a 2xx status code
func (o *GetMLExclusionsV1Forbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get m l exclusions v1 forbidden response has a 3xx status code
func (o *GetMLExclusionsV1Forbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get m l exclusions v1 forbidden response has a 4xx status code
func (o *GetMLExclusionsV1Forbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get m l exclusions v1 forbidden response has a 5xx status code
func (o *GetMLExclusionsV1Forbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get m l exclusions v1 forbidden response a status code equal to that given
func (o *GetMLExclusionsV1Forbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get m l exclusions v1 forbidden response
func (o *GetMLExclusionsV1Forbidden) Code() int {
	return 403
}

func (o *GetMLExclusionsV1Forbidden) Error() string {
	return fmt.Sprintf("[GET /policy/entities/ml-exclusions/v1][%d] getMLExclusionsV1Forbidden  %+v", 403, o.Payload)
}

func (o *GetMLExclusionsV1Forbidden) String() string {
	return fmt.Sprintf("[GET /policy/entities/ml-exclusions/v1][%d] getMLExclusionsV1Forbidden  %+v", 403, o.Payload)
}

func (o *GetMLExclusionsV1Forbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *GetMLExclusionsV1Forbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetMLExclusionsV1TooManyRequests creates a GetMLExclusionsV1TooManyRequests with default headers values
func NewGetMLExclusionsV1TooManyRequests() *GetMLExclusionsV1TooManyRequests {
	return &GetMLExclusionsV1TooManyRequests{}
}

/*
GetMLExclusionsV1TooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetMLExclusionsV1TooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get m l exclusions v1 too many requests response has a 2xx status code
func (o *GetMLExclusionsV1TooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get m l exclusions v1 too many requests response has a 3xx status code
func (o *GetMLExclusionsV1TooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get m l exclusions v1 too many requests response has a 4xx status code
func (o *GetMLExclusionsV1TooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get m l exclusions v1 too many requests response has a 5xx status code
func (o *GetMLExclusionsV1TooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get m l exclusions v1 too many requests response a status code equal to that given
func (o *GetMLExclusionsV1TooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get m l exclusions v1 too many requests response
func (o *GetMLExclusionsV1TooManyRequests) Code() int {
	return 429
}

func (o *GetMLExclusionsV1TooManyRequests) Error() string {
	return fmt.Sprintf("[GET /policy/entities/ml-exclusions/v1][%d] getMLExclusionsV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *GetMLExclusionsV1TooManyRequests) String() string {
	return fmt.Sprintf("[GET /policy/entities/ml-exclusions/v1][%d] getMLExclusionsV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *GetMLExclusionsV1TooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetMLExclusionsV1TooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetMLExclusionsV1InternalServerError creates a GetMLExclusionsV1InternalServerError with default headers values
func NewGetMLExclusionsV1InternalServerError() *GetMLExclusionsV1InternalServerError {
	return &GetMLExclusionsV1InternalServerError{}
}

/*
GetMLExclusionsV1InternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetMLExclusionsV1InternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ExclusionsRespV1
}

// IsSuccess returns true when this get m l exclusions v1 internal server error response has a 2xx status code
func (o *GetMLExclusionsV1InternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get m l exclusions v1 internal server error response has a 3xx status code
func (o *GetMLExclusionsV1InternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get m l exclusions v1 internal server error response has a 4xx status code
func (o *GetMLExclusionsV1InternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get m l exclusions v1 internal server error response has a 5xx status code
func (o *GetMLExclusionsV1InternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get m l exclusions v1 internal server error response a status code equal to that given
func (o *GetMLExclusionsV1InternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get m l exclusions v1 internal server error response
func (o *GetMLExclusionsV1InternalServerError) Code() int {
	return 500
}

func (o *GetMLExclusionsV1InternalServerError) Error() string {
	return fmt.Sprintf("[GET /policy/entities/ml-exclusions/v1][%d] getMLExclusionsV1InternalServerError  %+v", 500, o.Payload)
}

func (o *GetMLExclusionsV1InternalServerError) String() string {
	return fmt.Sprintf("[GET /policy/entities/ml-exclusions/v1][%d] getMLExclusionsV1InternalServerError  %+v", 500, o.Payload)
}

func (o *GetMLExclusionsV1InternalServerError) GetPayload() *models.ExclusionsRespV1 {
	return o.Payload
}

func (o *GetMLExclusionsV1InternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ExclusionsRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
