// Code generated by go-swagger; DO NOT EDIT.

package mobile_enrollment

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// NewRequestDeviceEnrollmentV3Params creates a new RequestDeviceEnrollmentV3Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewRequestDeviceEnrollmentV3Params() *RequestDeviceEnrollmentV3Params {
	return &RequestDeviceEnrollmentV3Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewRequestDeviceEnrollmentV3ParamsWithTimeout creates a new RequestDeviceEnrollmentV3Params object
// with the ability to set a timeout on a request.
func NewRequestDeviceEnrollmentV3ParamsWithTimeout(timeout time.Duration) *RequestDeviceEnrollmentV3Params {
	return &RequestDeviceEnrollmentV3Params{
		timeout: timeout,
	}
}

// NewRequestDeviceEnrollmentV3ParamsWithContext creates a new RequestDeviceEnrollmentV3Params object
// with the ability to set a context for a request.
func NewRequestDeviceEnrollmentV3ParamsWithContext(ctx context.Context) *RequestDeviceEnrollmentV3Params {
	return &RequestDeviceEnrollmentV3Params{
		Context: ctx,
	}
}

// NewRequestDeviceEnrollmentV3ParamsWithHTTPClient creates a new RequestDeviceEnrollmentV3Params object
// with the ability to set a custom HTTPClient for a request.
func NewRequestDeviceEnrollmentV3ParamsWithHTTPClient(client *http.Client) *RequestDeviceEnrollmentV3Params {
	return &RequestDeviceEnrollmentV3Params{
		HTTPClient: client,
	}
}

/*
RequestDeviceEnrollmentV3Params contains all the parameters to send to the API endpoint

	for the request device enrollment v3 operation.

	Typically these are written to a http.Request.
*/
type RequestDeviceEnrollmentV3Params struct {

	/* ActionName.

	   Action to perform
	*/
	ActionName string

	// Body.
	Body *models.APIPostEnrollmentDetails

	/* Filter.

	   FQL filter
	*/
	Filter *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the request device enrollment v3 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RequestDeviceEnrollmentV3Params) WithDefaults() *RequestDeviceEnrollmentV3Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the request device enrollment v3 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RequestDeviceEnrollmentV3Params) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the request device enrollment v3 params
func (o *RequestDeviceEnrollmentV3Params) WithTimeout(timeout time.Duration) *RequestDeviceEnrollmentV3Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the request device enrollment v3 params
func (o *RequestDeviceEnrollmentV3Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the request device enrollment v3 params
func (o *RequestDeviceEnrollmentV3Params) WithContext(ctx context.Context) *RequestDeviceEnrollmentV3Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the request device enrollment v3 params
func (o *RequestDeviceEnrollmentV3Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the request device enrollment v3 params
func (o *RequestDeviceEnrollmentV3Params) WithHTTPClient(client *http.Client) *RequestDeviceEnrollmentV3Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the request device enrollment v3 params
func (o *RequestDeviceEnrollmentV3Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithActionName adds the actionName to the request device enrollment v3 params
func (o *RequestDeviceEnrollmentV3Params) WithActionName(actionName string) *RequestDeviceEnrollmentV3Params {
	o.SetActionName(actionName)
	return o
}

// SetActionName adds the actionName to the request device enrollment v3 params
func (o *RequestDeviceEnrollmentV3Params) SetActionName(actionName string) {
	o.ActionName = actionName
}

// WithBody adds the body to the request device enrollment v3 params
func (o *RequestDeviceEnrollmentV3Params) WithBody(body *models.APIPostEnrollmentDetails) *RequestDeviceEnrollmentV3Params {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the request device enrollment v3 params
func (o *RequestDeviceEnrollmentV3Params) SetBody(body *models.APIPostEnrollmentDetails) {
	o.Body = body
}

// WithFilter adds the filter to the request device enrollment v3 params
func (o *RequestDeviceEnrollmentV3Params) WithFilter(filter *string) *RequestDeviceEnrollmentV3Params {
	o.SetFilter(filter)
	return o
}

// SetFilter adds the filter to the request device enrollment v3 params
func (o *RequestDeviceEnrollmentV3Params) SetFilter(filter *string) {
	o.Filter = filter
}

// WriteToRequest writes these params to a swagger request
func (o *RequestDeviceEnrollmentV3Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// query param action_name
	qrActionName := o.ActionName
	qActionName := qrActionName

	if err := r.SetQueryParam("action_name", qActionName); err != nil {
		return err
	}
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if o.Filter != nil {

		// query param filter
		var qrFilter string

		if o.Filter != nil {
			qrFilter = *o.Filter
		}
		qFilter := qrFilter
		if qFilter != "" {

			if err := r.SetQueryParam("filter", qFilter); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
