// Code generated by go-swagger; DO NOT EDIT.

package mobile_enrollment

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// RequestDeviceEnrollmentV3Reader is a Reader for the RequestDeviceEnrollmentV3 structure.
type RequestDeviceEnrollmentV3Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *RequestDeviceEnrollmentV3Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewRequestDeviceEnrollmentV3OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewRequestDeviceEnrollmentV3BadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewRequestDeviceEnrollmentV3Forbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewRequestDeviceEnrollmentV3TooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewRequestDeviceEnrollmentV3InternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /enrollments/entities/details/v3] RequestDeviceEnrollmentV3", response, response.Code())
	}
}

// NewRequestDeviceEnrollmentV3OK creates a RequestDeviceEnrollmentV3OK with default headers values
func NewRequestDeviceEnrollmentV3OK() *RequestDeviceEnrollmentV3OK {
	return &RequestDeviceEnrollmentV3OK{}
}

/*
RequestDeviceEnrollmentV3OK describes a response with status code 200, with default header values.

OK
*/
type RequestDeviceEnrollmentV3OK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.APIPostEnrollmentDetailsResponse
}

// IsSuccess returns true when this request device enrollment v3 o k response has a 2xx status code
func (o *RequestDeviceEnrollmentV3OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this request device enrollment v3 o k response has a 3xx status code
func (o *RequestDeviceEnrollmentV3OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this request device enrollment v3 o k response has a 4xx status code
func (o *RequestDeviceEnrollmentV3OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this request device enrollment v3 o k response has a 5xx status code
func (o *RequestDeviceEnrollmentV3OK) IsServerError() bool {
	return false
}

// IsCode returns true when this request device enrollment v3 o k response a status code equal to that given
func (o *RequestDeviceEnrollmentV3OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the request device enrollment v3 o k response
func (o *RequestDeviceEnrollmentV3OK) Code() int {
	return 200
}

func (o *RequestDeviceEnrollmentV3OK) Error() string {
	return fmt.Sprintf("[POST /enrollments/entities/details/v3][%d] requestDeviceEnrollmentV3OK  %+v", 200, o.Payload)
}

func (o *RequestDeviceEnrollmentV3OK) String() string {
	return fmt.Sprintf("[POST /enrollments/entities/details/v3][%d] requestDeviceEnrollmentV3OK  %+v", 200, o.Payload)
}

func (o *RequestDeviceEnrollmentV3OK) GetPayload() *models.APIPostEnrollmentDetailsResponse {
	return o.Payload
}

func (o *RequestDeviceEnrollmentV3OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.APIPostEnrollmentDetailsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRequestDeviceEnrollmentV3BadRequest creates a RequestDeviceEnrollmentV3BadRequest with default headers values
func NewRequestDeviceEnrollmentV3BadRequest() *RequestDeviceEnrollmentV3BadRequest {
	return &RequestDeviceEnrollmentV3BadRequest{}
}

/*
RequestDeviceEnrollmentV3BadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type RequestDeviceEnrollmentV3BadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecResponseFields
}

// IsSuccess returns true when this request device enrollment v3 bad request response has a 2xx status code
func (o *RequestDeviceEnrollmentV3BadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this request device enrollment v3 bad request response has a 3xx status code
func (o *RequestDeviceEnrollmentV3BadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this request device enrollment v3 bad request response has a 4xx status code
func (o *RequestDeviceEnrollmentV3BadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this request device enrollment v3 bad request response has a 5xx status code
func (o *RequestDeviceEnrollmentV3BadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this request device enrollment v3 bad request response a status code equal to that given
func (o *RequestDeviceEnrollmentV3BadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the request device enrollment v3 bad request response
func (o *RequestDeviceEnrollmentV3BadRequest) Code() int {
	return 400
}

func (o *RequestDeviceEnrollmentV3BadRequest) Error() string {
	return fmt.Sprintf("[POST /enrollments/entities/details/v3][%d] requestDeviceEnrollmentV3BadRequest  %+v", 400, o.Payload)
}

func (o *RequestDeviceEnrollmentV3BadRequest) String() string {
	return fmt.Sprintf("[POST /enrollments/entities/details/v3][%d] requestDeviceEnrollmentV3BadRequest  %+v", 400, o.Payload)
}

func (o *RequestDeviceEnrollmentV3BadRequest) GetPayload() *models.MsaspecResponseFields {
	return o.Payload
}

func (o *RequestDeviceEnrollmentV3BadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRequestDeviceEnrollmentV3Forbidden creates a RequestDeviceEnrollmentV3Forbidden with default headers values
func NewRequestDeviceEnrollmentV3Forbidden() *RequestDeviceEnrollmentV3Forbidden {
	return &RequestDeviceEnrollmentV3Forbidden{}
}

/*
RequestDeviceEnrollmentV3Forbidden describes a response with status code 403, with default header values.

Forbidden
*/
type RequestDeviceEnrollmentV3Forbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this request device enrollment v3 forbidden response has a 2xx status code
func (o *RequestDeviceEnrollmentV3Forbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this request device enrollment v3 forbidden response has a 3xx status code
func (o *RequestDeviceEnrollmentV3Forbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this request device enrollment v3 forbidden response has a 4xx status code
func (o *RequestDeviceEnrollmentV3Forbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this request device enrollment v3 forbidden response has a 5xx status code
func (o *RequestDeviceEnrollmentV3Forbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this request device enrollment v3 forbidden response a status code equal to that given
func (o *RequestDeviceEnrollmentV3Forbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the request device enrollment v3 forbidden response
func (o *RequestDeviceEnrollmentV3Forbidden) Code() int {
	return 403
}

func (o *RequestDeviceEnrollmentV3Forbidden) Error() string {
	return fmt.Sprintf("[POST /enrollments/entities/details/v3][%d] requestDeviceEnrollmentV3Forbidden  %+v", 403, o.Payload)
}

func (o *RequestDeviceEnrollmentV3Forbidden) String() string {
	return fmt.Sprintf("[POST /enrollments/entities/details/v3][%d] requestDeviceEnrollmentV3Forbidden  %+v", 403, o.Payload)
}

func (o *RequestDeviceEnrollmentV3Forbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *RequestDeviceEnrollmentV3Forbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRequestDeviceEnrollmentV3TooManyRequests creates a RequestDeviceEnrollmentV3TooManyRequests with default headers values
func NewRequestDeviceEnrollmentV3TooManyRequests() *RequestDeviceEnrollmentV3TooManyRequests {
	return &RequestDeviceEnrollmentV3TooManyRequests{}
}

/*
RequestDeviceEnrollmentV3TooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type RequestDeviceEnrollmentV3TooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this request device enrollment v3 too many requests response has a 2xx status code
func (o *RequestDeviceEnrollmentV3TooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this request device enrollment v3 too many requests response has a 3xx status code
func (o *RequestDeviceEnrollmentV3TooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this request device enrollment v3 too many requests response has a 4xx status code
func (o *RequestDeviceEnrollmentV3TooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this request device enrollment v3 too many requests response has a 5xx status code
func (o *RequestDeviceEnrollmentV3TooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this request device enrollment v3 too many requests response a status code equal to that given
func (o *RequestDeviceEnrollmentV3TooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the request device enrollment v3 too many requests response
func (o *RequestDeviceEnrollmentV3TooManyRequests) Code() int {
	return 429
}

func (o *RequestDeviceEnrollmentV3TooManyRequests) Error() string {
	return fmt.Sprintf("[POST /enrollments/entities/details/v3][%d] requestDeviceEnrollmentV3TooManyRequests  %+v", 429, o.Payload)
}

func (o *RequestDeviceEnrollmentV3TooManyRequests) String() string {
	return fmt.Sprintf("[POST /enrollments/entities/details/v3][%d] requestDeviceEnrollmentV3TooManyRequests  %+v", 429, o.Payload)
}

func (o *RequestDeviceEnrollmentV3TooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *RequestDeviceEnrollmentV3TooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRequestDeviceEnrollmentV3InternalServerError creates a RequestDeviceEnrollmentV3InternalServerError with default headers values
func NewRequestDeviceEnrollmentV3InternalServerError() *RequestDeviceEnrollmentV3InternalServerError {
	return &RequestDeviceEnrollmentV3InternalServerError{}
}

/*
RequestDeviceEnrollmentV3InternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type RequestDeviceEnrollmentV3InternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecResponseFields
}

// IsSuccess returns true when this request device enrollment v3 internal server error response has a 2xx status code
func (o *RequestDeviceEnrollmentV3InternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this request device enrollment v3 internal server error response has a 3xx status code
func (o *RequestDeviceEnrollmentV3InternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this request device enrollment v3 internal server error response has a 4xx status code
func (o *RequestDeviceEnrollmentV3InternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this request device enrollment v3 internal server error response has a 5xx status code
func (o *RequestDeviceEnrollmentV3InternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this request device enrollment v3 internal server error response a status code equal to that given
func (o *RequestDeviceEnrollmentV3InternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the request device enrollment v3 internal server error response
func (o *RequestDeviceEnrollmentV3InternalServerError) Code() int {
	return 500
}

func (o *RequestDeviceEnrollmentV3InternalServerError) Error() string {
	return fmt.Sprintf("[POST /enrollments/entities/details/v3][%d] requestDeviceEnrollmentV3InternalServerError  %+v", 500, o.Payload)
}

func (o *RequestDeviceEnrollmentV3InternalServerError) String() string {
	return fmt.Sprintf("[POST /enrollments/entities/details/v3][%d] requestDeviceEnrollmentV3InternalServerError  %+v", 500, o.Payload)
}

func (o *RequestDeviceEnrollmentV3InternalServerError) GetPayload() *models.MsaspecResponseFields {
	return o.Payload
}

func (o *RequestDeviceEnrollmentV3InternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
