// Code generated by go-swagger; DO NOT EDIT.

package mssp

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// AddRoleReader is a Reader for the AddRole structure.
type AddRoleReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AddRoleReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAddRoleOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 207:
		result := NewAddRoleMultiStatus()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewAddRoleBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewAddRoleForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewAddRoleTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /mssp/entities/mssp-roles/v1] addRole", response, response.Code())
	}
}

// NewAddRoleOK creates a AddRoleOK with default headers values
func NewAddRoleOK() *AddRoleOK {
	return &AddRoleOK{}
}

/*
AddRoleOK describes a response with status code 200, with default header values.

OK
*/
type AddRoleOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainMSSPRoleResponseV1
}

// IsSuccess returns true when this add role o k response has a 2xx status code
func (o *AddRoleOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this add role o k response has a 3xx status code
func (o *AddRoleOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this add role o k response has a 4xx status code
func (o *AddRoleOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this add role o k response has a 5xx status code
func (o *AddRoleOK) IsServerError() bool {
	return false
}

// IsCode returns true when this add role o k response a status code equal to that given
func (o *AddRoleOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the add role o k response
func (o *AddRoleOK) Code() int {
	return 200
}

func (o *AddRoleOK) Error() string {
	return fmt.Sprintf("[POST /mssp/entities/mssp-roles/v1][%d] addRoleOK  %+v", 200, o.Payload)
}

func (o *AddRoleOK) String() string {
	return fmt.Sprintf("[POST /mssp/entities/mssp-roles/v1][%d] addRoleOK  %+v", 200, o.Payload)
}

func (o *AddRoleOK) GetPayload() *models.DomainMSSPRoleResponseV1 {
	return o.Payload
}

func (o *AddRoleOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainMSSPRoleResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAddRoleMultiStatus creates a AddRoleMultiStatus with default headers values
func NewAddRoleMultiStatus() *AddRoleMultiStatus {
	return &AddRoleMultiStatus{}
}

/*
AddRoleMultiStatus describes a response with status code 207, with default header values.

Multi-Status
*/
type AddRoleMultiStatus struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainMSSPRoleResponseV1
}

// IsSuccess returns true when this add role multi status response has a 2xx status code
func (o *AddRoleMultiStatus) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this add role multi status response has a 3xx status code
func (o *AddRoleMultiStatus) IsRedirect() bool {
	return false
}

// IsClientError returns true when this add role multi status response has a 4xx status code
func (o *AddRoleMultiStatus) IsClientError() bool {
	return false
}

// IsServerError returns true when this add role multi status response has a 5xx status code
func (o *AddRoleMultiStatus) IsServerError() bool {
	return false
}

// IsCode returns true when this add role multi status response a status code equal to that given
func (o *AddRoleMultiStatus) IsCode(code int) bool {
	return code == 207
}

// Code gets the status code for the add role multi status response
func (o *AddRoleMultiStatus) Code() int {
	return 207
}

func (o *AddRoleMultiStatus) Error() string {
	return fmt.Sprintf("[POST /mssp/entities/mssp-roles/v1][%d] addRoleMultiStatus  %+v", 207, o.Payload)
}

func (o *AddRoleMultiStatus) String() string {
	return fmt.Sprintf("[POST /mssp/entities/mssp-roles/v1][%d] addRoleMultiStatus  %+v", 207, o.Payload)
}

func (o *AddRoleMultiStatus) GetPayload() *models.DomainMSSPRoleResponseV1 {
	return o.Payload
}

func (o *AddRoleMultiStatus) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainMSSPRoleResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAddRoleBadRequest creates a AddRoleBadRequest with default headers values
func NewAddRoleBadRequest() *AddRoleBadRequest {
	return &AddRoleBadRequest{}
}

/*
AddRoleBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type AddRoleBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this add role bad request response has a 2xx status code
func (o *AddRoleBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this add role bad request response has a 3xx status code
func (o *AddRoleBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this add role bad request response has a 4xx status code
func (o *AddRoleBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this add role bad request response has a 5xx status code
func (o *AddRoleBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this add role bad request response a status code equal to that given
func (o *AddRoleBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the add role bad request response
func (o *AddRoleBadRequest) Code() int {
	return 400
}

func (o *AddRoleBadRequest) Error() string {
	return fmt.Sprintf("[POST /mssp/entities/mssp-roles/v1][%d] addRoleBadRequest  %+v", 400, o.Payload)
}

func (o *AddRoleBadRequest) String() string {
	return fmt.Sprintf("[POST /mssp/entities/mssp-roles/v1][%d] addRoleBadRequest  %+v", 400, o.Payload)
}

func (o *AddRoleBadRequest) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *AddRoleBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAddRoleForbidden creates a AddRoleForbidden with default headers values
func NewAddRoleForbidden() *AddRoleForbidden {
	return &AddRoleForbidden{}
}

/*
AddRoleForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type AddRoleForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this add role forbidden response has a 2xx status code
func (o *AddRoleForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this add role forbidden response has a 3xx status code
func (o *AddRoleForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this add role forbidden response has a 4xx status code
func (o *AddRoleForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this add role forbidden response has a 5xx status code
func (o *AddRoleForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this add role forbidden response a status code equal to that given
func (o *AddRoleForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the add role forbidden response
func (o *AddRoleForbidden) Code() int {
	return 403
}

func (o *AddRoleForbidden) Error() string {
	return fmt.Sprintf("[POST /mssp/entities/mssp-roles/v1][%d] addRoleForbidden  %+v", 403, o.Payload)
}

func (o *AddRoleForbidden) String() string {
	return fmt.Sprintf("[POST /mssp/entities/mssp-roles/v1][%d] addRoleForbidden  %+v", 403, o.Payload)
}

func (o *AddRoleForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *AddRoleForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAddRoleTooManyRequests creates a AddRoleTooManyRequests with default headers values
func NewAddRoleTooManyRequests() *AddRoleTooManyRequests {
	return &AddRoleTooManyRequests{}
}

/*
AddRoleTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type AddRoleTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this add role too many requests response has a 2xx status code
func (o *AddRoleTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this add role too many requests response has a 3xx status code
func (o *AddRoleTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this add role too many requests response has a 4xx status code
func (o *AddRoleTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this add role too many requests response has a 5xx status code
func (o *AddRoleTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this add role too many requests response a status code equal to that given
func (o *AddRoleTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the add role too many requests response
func (o *AddRoleTooManyRequests) Code() int {
	return 429
}

func (o *AddRoleTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /mssp/entities/mssp-roles/v1][%d] addRoleTooManyRequests  %+v", 429, o.Payload)
}

func (o *AddRoleTooManyRequests) String() string {
	return fmt.Sprintf("[POST /mssp/entities/mssp-roles/v1][%d] addRoleTooManyRequests  %+v", 429, o.Payload)
}

func (o *AddRoleTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *AddRoleTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
