// Code generated by go-swagger; DO NOT EDIT.

package mssp

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// DeleteCIDGroupsReader is a Reader for the DeleteCIDGroups structure.
type DeleteCIDGroupsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteCIDGroupsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeleteCIDGroupsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 207:
		result := NewDeleteCIDGroupsMultiStatus()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewDeleteCIDGroupsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewDeleteCIDGroupsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewDeleteCIDGroupsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[DELETE /mssp/entities/cid-groups/v1] deleteCIDGroups", response, response.Code())
	}
}

// NewDeleteCIDGroupsOK creates a DeleteCIDGroupsOK with default headers values
func NewDeleteCIDGroupsOK() *DeleteCIDGroupsOK {
	return &DeleteCIDGroupsOK{}
}

/*
DeleteCIDGroupsOK describes a response with status code 200, with default header values.

OK
*/
type DeleteCIDGroupsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaEntitiesResponse
}

// IsSuccess returns true when this delete c Id groups o k response has a 2xx status code
func (o *DeleteCIDGroupsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete c Id groups o k response has a 3xx status code
func (o *DeleteCIDGroupsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete c Id groups o k response has a 4xx status code
func (o *DeleteCIDGroupsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete c Id groups o k response has a 5xx status code
func (o *DeleteCIDGroupsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete c Id groups o k response a status code equal to that given
func (o *DeleteCIDGroupsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the delete c Id groups o k response
func (o *DeleteCIDGroupsOK) Code() int {
	return 200
}

func (o *DeleteCIDGroupsOK) Error() string {
	return fmt.Sprintf("[DELETE /mssp/entities/cid-groups/v1][%d] deleteCIdGroupsOK  %+v", 200, o.Payload)
}

func (o *DeleteCIDGroupsOK) String() string {
	return fmt.Sprintf("[DELETE /mssp/entities/cid-groups/v1][%d] deleteCIdGroupsOK  %+v", 200, o.Payload)
}

func (o *DeleteCIDGroupsOK) GetPayload() *models.MsaEntitiesResponse {
	return o.Payload
}

func (o *DeleteCIDGroupsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaEntitiesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteCIDGroupsMultiStatus creates a DeleteCIDGroupsMultiStatus with default headers values
func NewDeleteCIDGroupsMultiStatus() *DeleteCIDGroupsMultiStatus {
	return &DeleteCIDGroupsMultiStatus{}
}

/*
DeleteCIDGroupsMultiStatus describes a response with status code 207, with default header values.

Multi-Status
*/
type DeleteCIDGroupsMultiStatus struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaEntitiesResponse
}

// IsSuccess returns true when this delete c Id groups multi status response has a 2xx status code
func (o *DeleteCIDGroupsMultiStatus) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete c Id groups multi status response has a 3xx status code
func (o *DeleteCIDGroupsMultiStatus) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete c Id groups multi status response has a 4xx status code
func (o *DeleteCIDGroupsMultiStatus) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete c Id groups multi status response has a 5xx status code
func (o *DeleteCIDGroupsMultiStatus) IsServerError() bool {
	return false
}

// IsCode returns true when this delete c Id groups multi status response a status code equal to that given
func (o *DeleteCIDGroupsMultiStatus) IsCode(code int) bool {
	return code == 207
}

// Code gets the status code for the delete c Id groups multi status response
func (o *DeleteCIDGroupsMultiStatus) Code() int {
	return 207
}

func (o *DeleteCIDGroupsMultiStatus) Error() string {
	return fmt.Sprintf("[DELETE /mssp/entities/cid-groups/v1][%d] deleteCIdGroupsMultiStatus  %+v", 207, o.Payload)
}

func (o *DeleteCIDGroupsMultiStatus) String() string {
	return fmt.Sprintf("[DELETE /mssp/entities/cid-groups/v1][%d] deleteCIdGroupsMultiStatus  %+v", 207, o.Payload)
}

func (o *DeleteCIDGroupsMultiStatus) GetPayload() *models.MsaEntitiesResponse {
	return o.Payload
}

func (o *DeleteCIDGroupsMultiStatus) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaEntitiesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteCIDGroupsBadRequest creates a DeleteCIDGroupsBadRequest with default headers values
func NewDeleteCIDGroupsBadRequest() *DeleteCIDGroupsBadRequest {
	return &DeleteCIDGroupsBadRequest{}
}

/*
DeleteCIDGroupsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type DeleteCIDGroupsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this delete c Id groups bad request response has a 2xx status code
func (o *DeleteCIDGroupsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete c Id groups bad request response has a 3xx status code
func (o *DeleteCIDGroupsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete c Id groups bad request response has a 4xx status code
func (o *DeleteCIDGroupsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete c Id groups bad request response has a 5xx status code
func (o *DeleteCIDGroupsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this delete c Id groups bad request response a status code equal to that given
func (o *DeleteCIDGroupsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the delete c Id groups bad request response
func (o *DeleteCIDGroupsBadRequest) Code() int {
	return 400
}

func (o *DeleteCIDGroupsBadRequest) Error() string {
	return fmt.Sprintf("[DELETE /mssp/entities/cid-groups/v1][%d] deleteCIdGroupsBadRequest  %+v", 400, o.Payload)
}

func (o *DeleteCIDGroupsBadRequest) String() string {
	return fmt.Sprintf("[DELETE /mssp/entities/cid-groups/v1][%d] deleteCIdGroupsBadRequest  %+v", 400, o.Payload)
}

func (o *DeleteCIDGroupsBadRequest) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *DeleteCIDGroupsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteCIDGroupsForbidden creates a DeleteCIDGroupsForbidden with default headers values
func NewDeleteCIDGroupsForbidden() *DeleteCIDGroupsForbidden {
	return &DeleteCIDGroupsForbidden{}
}

/*
DeleteCIDGroupsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type DeleteCIDGroupsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this delete c Id groups forbidden response has a 2xx status code
func (o *DeleteCIDGroupsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete c Id groups forbidden response has a 3xx status code
func (o *DeleteCIDGroupsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete c Id groups forbidden response has a 4xx status code
func (o *DeleteCIDGroupsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete c Id groups forbidden response has a 5xx status code
func (o *DeleteCIDGroupsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this delete c Id groups forbidden response a status code equal to that given
func (o *DeleteCIDGroupsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the delete c Id groups forbidden response
func (o *DeleteCIDGroupsForbidden) Code() int {
	return 403
}

func (o *DeleteCIDGroupsForbidden) Error() string {
	return fmt.Sprintf("[DELETE /mssp/entities/cid-groups/v1][%d] deleteCIdGroupsForbidden  %+v", 403, o.Payload)
}

func (o *DeleteCIDGroupsForbidden) String() string {
	return fmt.Sprintf("[DELETE /mssp/entities/cid-groups/v1][%d] deleteCIdGroupsForbidden  %+v", 403, o.Payload)
}

func (o *DeleteCIDGroupsForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *DeleteCIDGroupsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteCIDGroupsTooManyRequests creates a DeleteCIDGroupsTooManyRequests with default headers values
func NewDeleteCIDGroupsTooManyRequests() *DeleteCIDGroupsTooManyRequests {
	return &DeleteCIDGroupsTooManyRequests{}
}

/*
DeleteCIDGroupsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type DeleteCIDGroupsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this delete c Id groups too many requests response has a 2xx status code
func (o *DeleteCIDGroupsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete c Id groups too many requests response has a 3xx status code
func (o *DeleteCIDGroupsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete c Id groups too many requests response has a 4xx status code
func (o *DeleteCIDGroupsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete c Id groups too many requests response has a 5xx status code
func (o *DeleteCIDGroupsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this delete c Id groups too many requests response a status code equal to that given
func (o *DeleteCIDGroupsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the delete c Id groups too many requests response
func (o *DeleteCIDGroupsTooManyRequests) Code() int {
	return 429
}

func (o *DeleteCIDGroupsTooManyRequests) Error() string {
	return fmt.Sprintf("[DELETE /mssp/entities/cid-groups/v1][%d] deleteCIdGroupsTooManyRequests  %+v", 429, o.Payload)
}

func (o *DeleteCIDGroupsTooManyRequests) String() string {
	return fmt.Sprintf("[DELETE /mssp/entities/cid-groups/v1][%d] deleteCIdGroupsTooManyRequests  %+v", 429, o.Payload)
}

func (o *DeleteCIDGroupsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *DeleteCIDGroupsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
