// Code generated by go-swagger; DO NOT EDIT.

package mssp

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// DeleteUserGroupsReader is a Reader for the DeleteUserGroups structure.
type DeleteUserGroupsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteUserGroupsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeleteUserGroupsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 207:
		result := NewDeleteUserGroupsMultiStatus()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewDeleteUserGroupsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewDeleteUserGroupsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewDeleteUserGroupsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[DELETE /mssp/entities/user-groups/v1] deleteUserGroups", response, response.Code())
	}
}

// NewDeleteUserGroupsOK creates a DeleteUserGroupsOK with default headers values
func NewDeleteUserGroupsOK() *DeleteUserGroupsOK {
	return &DeleteUserGroupsOK{}
}

/*
DeleteUserGroupsOK describes a response with status code 200, with default header values.

OK
*/
type DeleteUserGroupsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaEntitiesResponse
}

// IsSuccess returns true when this delete user groups o k response has a 2xx status code
func (o *DeleteUserGroupsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete user groups o k response has a 3xx status code
func (o *DeleteUserGroupsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete user groups o k response has a 4xx status code
func (o *DeleteUserGroupsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete user groups o k response has a 5xx status code
func (o *DeleteUserGroupsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete user groups o k response a status code equal to that given
func (o *DeleteUserGroupsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the delete user groups o k response
func (o *DeleteUserGroupsOK) Code() int {
	return 200
}

func (o *DeleteUserGroupsOK) Error() string {
	return fmt.Sprintf("[DELETE /mssp/entities/user-groups/v1][%d] deleteUserGroupsOK  %+v", 200, o.Payload)
}

func (o *DeleteUserGroupsOK) String() string {
	return fmt.Sprintf("[DELETE /mssp/entities/user-groups/v1][%d] deleteUserGroupsOK  %+v", 200, o.Payload)
}

func (o *DeleteUserGroupsOK) GetPayload() *models.MsaEntitiesResponse {
	return o.Payload
}

func (o *DeleteUserGroupsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaEntitiesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteUserGroupsMultiStatus creates a DeleteUserGroupsMultiStatus with default headers values
func NewDeleteUserGroupsMultiStatus() *DeleteUserGroupsMultiStatus {
	return &DeleteUserGroupsMultiStatus{}
}

/*
DeleteUserGroupsMultiStatus describes a response with status code 207, with default header values.

Multi-Status
*/
type DeleteUserGroupsMultiStatus struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaEntitiesResponse
}

// IsSuccess returns true when this delete user groups multi status response has a 2xx status code
func (o *DeleteUserGroupsMultiStatus) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete user groups multi status response has a 3xx status code
func (o *DeleteUserGroupsMultiStatus) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete user groups multi status response has a 4xx status code
func (o *DeleteUserGroupsMultiStatus) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete user groups multi status response has a 5xx status code
func (o *DeleteUserGroupsMultiStatus) IsServerError() bool {
	return false
}

// IsCode returns true when this delete user groups multi status response a status code equal to that given
func (o *DeleteUserGroupsMultiStatus) IsCode(code int) bool {
	return code == 207
}

// Code gets the status code for the delete user groups multi status response
func (o *DeleteUserGroupsMultiStatus) Code() int {
	return 207
}

func (o *DeleteUserGroupsMultiStatus) Error() string {
	return fmt.Sprintf("[DELETE /mssp/entities/user-groups/v1][%d] deleteUserGroupsMultiStatus  %+v", 207, o.Payload)
}

func (o *DeleteUserGroupsMultiStatus) String() string {
	return fmt.Sprintf("[DELETE /mssp/entities/user-groups/v1][%d] deleteUserGroupsMultiStatus  %+v", 207, o.Payload)
}

func (o *DeleteUserGroupsMultiStatus) GetPayload() *models.MsaEntitiesResponse {
	return o.Payload
}

func (o *DeleteUserGroupsMultiStatus) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaEntitiesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteUserGroupsBadRequest creates a DeleteUserGroupsBadRequest with default headers values
func NewDeleteUserGroupsBadRequest() *DeleteUserGroupsBadRequest {
	return &DeleteUserGroupsBadRequest{}
}

/*
DeleteUserGroupsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type DeleteUserGroupsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this delete user groups bad request response has a 2xx status code
func (o *DeleteUserGroupsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete user groups bad request response has a 3xx status code
func (o *DeleteUserGroupsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete user groups bad request response has a 4xx status code
func (o *DeleteUserGroupsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete user groups bad request response has a 5xx status code
func (o *DeleteUserGroupsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this delete user groups bad request response a status code equal to that given
func (o *DeleteUserGroupsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the delete user groups bad request response
func (o *DeleteUserGroupsBadRequest) Code() int {
	return 400
}

func (o *DeleteUserGroupsBadRequest) Error() string {
	return fmt.Sprintf("[DELETE /mssp/entities/user-groups/v1][%d] deleteUserGroupsBadRequest  %+v", 400, o.Payload)
}

func (o *DeleteUserGroupsBadRequest) String() string {
	return fmt.Sprintf("[DELETE /mssp/entities/user-groups/v1][%d] deleteUserGroupsBadRequest  %+v", 400, o.Payload)
}

func (o *DeleteUserGroupsBadRequest) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *DeleteUserGroupsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteUserGroupsForbidden creates a DeleteUserGroupsForbidden with default headers values
func NewDeleteUserGroupsForbidden() *DeleteUserGroupsForbidden {
	return &DeleteUserGroupsForbidden{}
}

/*
DeleteUserGroupsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type DeleteUserGroupsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this delete user groups forbidden response has a 2xx status code
func (o *DeleteUserGroupsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete user groups forbidden response has a 3xx status code
func (o *DeleteUserGroupsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete user groups forbidden response has a 4xx status code
func (o *DeleteUserGroupsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete user groups forbidden response has a 5xx status code
func (o *DeleteUserGroupsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this delete user groups forbidden response a status code equal to that given
func (o *DeleteUserGroupsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the delete user groups forbidden response
func (o *DeleteUserGroupsForbidden) Code() int {
	return 403
}

func (o *DeleteUserGroupsForbidden) Error() string {
	return fmt.Sprintf("[DELETE /mssp/entities/user-groups/v1][%d] deleteUserGroupsForbidden  %+v", 403, o.Payload)
}

func (o *DeleteUserGroupsForbidden) String() string {
	return fmt.Sprintf("[DELETE /mssp/entities/user-groups/v1][%d] deleteUserGroupsForbidden  %+v", 403, o.Payload)
}

func (o *DeleteUserGroupsForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *DeleteUserGroupsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteUserGroupsTooManyRequests creates a DeleteUserGroupsTooManyRequests with default headers values
func NewDeleteUserGroupsTooManyRequests() *DeleteUserGroupsTooManyRequests {
	return &DeleteUserGroupsTooManyRequests{}
}

/*
DeleteUserGroupsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type DeleteUserGroupsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this delete user groups too many requests response has a 2xx status code
func (o *DeleteUserGroupsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete user groups too many requests response has a 3xx status code
func (o *DeleteUserGroupsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete user groups too many requests response has a 4xx status code
func (o *DeleteUserGroupsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete user groups too many requests response has a 5xx status code
func (o *DeleteUserGroupsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this delete user groups too many requests response a status code equal to that given
func (o *DeleteUserGroupsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the delete user groups too many requests response
func (o *DeleteUserGroupsTooManyRequests) Code() int {
	return 429
}

func (o *DeleteUserGroupsTooManyRequests) Error() string {
	return fmt.Sprintf("[DELETE /mssp/entities/user-groups/v1][%d] deleteUserGroupsTooManyRequests  %+v", 429, o.Payload)
}

func (o *DeleteUserGroupsTooManyRequests) String() string {
	return fmt.Sprintf("[DELETE /mssp/entities/user-groups/v1][%d] deleteUserGroupsTooManyRequests  %+v", 429, o.Payload)
}

func (o *DeleteUserGroupsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *DeleteUserGroupsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
