// Code generated by go-swagger; DO NOT EDIT.

package mssp

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetCIDGroupMembersByParams creates a new GetCIDGroupMembersByParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetCIDGroupMembersByParams() *GetCIDGroupMembersByParams {
	return &GetCIDGroupMembersByParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetCIDGroupMembersByParamsWithTimeout creates a new GetCIDGroupMembersByParams object
// with the ability to set a timeout on a request.
func NewGetCIDGroupMembersByParamsWithTimeout(timeout time.Duration) *GetCIDGroupMembersByParams {
	return &GetCIDGroupMembersByParams{
		timeout: timeout,
	}
}

// NewGetCIDGroupMembersByParamsWithContext creates a new GetCIDGroupMembersByParams object
// with the ability to set a context for a request.
func NewGetCIDGroupMembersByParamsWithContext(ctx context.Context) *GetCIDGroupMembersByParams {
	return &GetCIDGroupMembersByParams{
		Context: ctx,
	}
}

// NewGetCIDGroupMembersByParamsWithHTTPClient creates a new GetCIDGroupMembersByParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetCIDGroupMembersByParamsWithHTTPClient(client *http.Client) *GetCIDGroupMembersByParams {
	return &GetCIDGroupMembersByParams{
		HTTPClient: client,
	}
}

/*
GetCIDGroupMembersByParams contains all the parameters to send to the API endpoint

	for the get c ID group members by operation.

	Typically these are written to a http.Request.
*/
type GetCIDGroupMembersByParams struct {

	/* CidGroupIds.

	   CID group IDs to search for
	*/
	CidGroupIds []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get c ID group members by params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetCIDGroupMembersByParams) WithDefaults() *GetCIDGroupMembersByParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get c ID group members by params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetCIDGroupMembersByParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get c ID group members by params
func (o *GetCIDGroupMembersByParams) WithTimeout(timeout time.Duration) *GetCIDGroupMembersByParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get c ID group members by params
func (o *GetCIDGroupMembersByParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get c ID group members by params
func (o *GetCIDGroupMembersByParams) WithContext(ctx context.Context) *GetCIDGroupMembersByParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get c ID group members by params
func (o *GetCIDGroupMembersByParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get c ID group members by params
func (o *GetCIDGroupMembersByParams) WithHTTPClient(client *http.Client) *GetCIDGroupMembersByParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get c ID group members by params
func (o *GetCIDGroupMembersByParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCidGroupIds adds the cidGroupIds to the get c ID group members by params
func (o *GetCIDGroupMembersByParams) WithCidGroupIds(cidGroupIds []string) *GetCIDGroupMembersByParams {
	o.SetCidGroupIds(cidGroupIds)
	return o
}

// SetCidGroupIds adds the cidGroupIds to the get c ID group members by params
func (o *GetCIDGroupMembersByParams) SetCidGroupIds(cidGroupIds []string) {
	o.CidGroupIds = cidGroupIds
}

// WriteToRequest writes these params to a swagger request
func (o *GetCIDGroupMembersByParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CidGroupIds != nil {

		// binding items for cid_group_ids
		joinedCidGroupIds := o.bindParamCidGroupIds(reg)

		// query array param cid_group_ids
		if err := r.SetQueryParam("cid_group_ids", joinedCidGroupIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGetCIDGroupMembersBy binds the parameter cid_group_ids
func (o *GetCIDGroupMembersByParams) bindParamCidGroupIds(formats strfmt.Registry) []string {
	cidGroupIdsIR := o.CidGroupIds

	var cidGroupIdsIC []string
	for _, cidGroupIdsIIR := range cidGroupIdsIR { // explode []string

		cidGroupIdsIIV := cidGroupIdsIIR // string as string
		cidGroupIdsIC = append(cidGroupIdsIC, cidGroupIdsIIV)
	}

	// items.CollectionFormat: "multi"
	cidGroupIdsIS := swag.JoinByFormat(cidGroupIdsIC, "multi")

	return cidGroupIdsIS
}
