// Code generated by go-swagger; DO NOT EDIT.

package mssp

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetChildrenReader is a Reader for the GetChildren structure.
type GetChildrenReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetChildrenReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetChildrenOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 207:
		result := NewGetChildrenMultiStatus()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetChildrenBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetChildrenForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetChildrenTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /mssp/entities/children/v1] getChildren", response, response.Code())
	}
}

// NewGetChildrenOK creates a GetChildrenOK with default headers values
func NewGetChildrenOK() *GetChildrenOK {
	return &GetChildrenOK{}
}

/*
GetChildrenOK describes a response with status code 200, with default header values.

OK
*/
type GetChildrenOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainChildrenResponseV1
}

// IsSuccess returns true when this get children o k response has a 2xx status code
func (o *GetChildrenOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get children o k response has a 3xx status code
func (o *GetChildrenOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get children o k response has a 4xx status code
func (o *GetChildrenOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get children o k response has a 5xx status code
func (o *GetChildrenOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get children o k response a status code equal to that given
func (o *GetChildrenOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get children o k response
func (o *GetChildrenOK) Code() int {
	return 200
}

func (o *GetChildrenOK) Error() string {
	return fmt.Sprintf("[GET /mssp/entities/children/v1][%d] getChildrenOK  %+v", 200, o.Payload)
}

func (o *GetChildrenOK) String() string {
	return fmt.Sprintf("[GET /mssp/entities/children/v1][%d] getChildrenOK  %+v", 200, o.Payload)
}

func (o *GetChildrenOK) GetPayload() *models.DomainChildrenResponseV1 {
	return o.Payload
}

func (o *GetChildrenOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainChildrenResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetChildrenMultiStatus creates a GetChildrenMultiStatus with default headers values
func NewGetChildrenMultiStatus() *GetChildrenMultiStatus {
	return &GetChildrenMultiStatus{}
}

/*
GetChildrenMultiStatus describes a response with status code 207, with default header values.

Multi-Status
*/
type GetChildrenMultiStatus struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainChildrenResponseV1
}

// IsSuccess returns true when this get children multi status response has a 2xx status code
func (o *GetChildrenMultiStatus) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get children multi status response has a 3xx status code
func (o *GetChildrenMultiStatus) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get children multi status response has a 4xx status code
func (o *GetChildrenMultiStatus) IsClientError() bool {
	return false
}

// IsServerError returns true when this get children multi status response has a 5xx status code
func (o *GetChildrenMultiStatus) IsServerError() bool {
	return false
}

// IsCode returns true when this get children multi status response a status code equal to that given
func (o *GetChildrenMultiStatus) IsCode(code int) bool {
	return code == 207
}

// Code gets the status code for the get children multi status response
func (o *GetChildrenMultiStatus) Code() int {
	return 207
}

func (o *GetChildrenMultiStatus) Error() string {
	return fmt.Sprintf("[GET /mssp/entities/children/v1][%d] getChildrenMultiStatus  %+v", 207, o.Payload)
}

func (o *GetChildrenMultiStatus) String() string {
	return fmt.Sprintf("[GET /mssp/entities/children/v1][%d] getChildrenMultiStatus  %+v", 207, o.Payload)
}

func (o *GetChildrenMultiStatus) GetPayload() *models.DomainChildrenResponseV1 {
	return o.Payload
}

func (o *GetChildrenMultiStatus) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainChildrenResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetChildrenBadRequest creates a GetChildrenBadRequest with default headers values
func NewGetChildrenBadRequest() *GetChildrenBadRequest {
	return &GetChildrenBadRequest{}
}

/*
GetChildrenBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetChildrenBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this get children bad request response has a 2xx status code
func (o *GetChildrenBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get children bad request response has a 3xx status code
func (o *GetChildrenBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get children bad request response has a 4xx status code
func (o *GetChildrenBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get children bad request response has a 5xx status code
func (o *GetChildrenBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get children bad request response a status code equal to that given
func (o *GetChildrenBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get children bad request response
func (o *GetChildrenBadRequest) Code() int {
	return 400
}

func (o *GetChildrenBadRequest) Error() string {
	return fmt.Sprintf("[GET /mssp/entities/children/v1][%d] getChildrenBadRequest  %+v", 400, o.Payload)
}

func (o *GetChildrenBadRequest) String() string {
	return fmt.Sprintf("[GET /mssp/entities/children/v1][%d] getChildrenBadRequest  %+v", 400, o.Payload)
}

func (o *GetChildrenBadRequest) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *GetChildrenBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetChildrenForbidden creates a GetChildrenForbidden with default headers values
func NewGetChildrenForbidden() *GetChildrenForbidden {
	return &GetChildrenForbidden{}
}

/*
GetChildrenForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetChildrenForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this get children forbidden response has a 2xx status code
func (o *GetChildrenForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get children forbidden response has a 3xx status code
func (o *GetChildrenForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get children forbidden response has a 4xx status code
func (o *GetChildrenForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get children forbidden response has a 5xx status code
func (o *GetChildrenForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get children forbidden response a status code equal to that given
func (o *GetChildrenForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get children forbidden response
func (o *GetChildrenForbidden) Code() int {
	return 403
}

func (o *GetChildrenForbidden) Error() string {
	return fmt.Sprintf("[GET /mssp/entities/children/v1][%d] getChildrenForbidden  %+v", 403, o.Payload)
}

func (o *GetChildrenForbidden) String() string {
	return fmt.Sprintf("[GET /mssp/entities/children/v1][%d] getChildrenForbidden  %+v", 403, o.Payload)
}

func (o *GetChildrenForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *GetChildrenForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetChildrenTooManyRequests creates a GetChildrenTooManyRequests with default headers values
func NewGetChildrenTooManyRequests() *GetChildrenTooManyRequests {
	return &GetChildrenTooManyRequests{}
}

/*
GetChildrenTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetChildrenTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get children too many requests response has a 2xx status code
func (o *GetChildrenTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get children too many requests response has a 3xx status code
func (o *GetChildrenTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get children too many requests response has a 4xx status code
func (o *GetChildrenTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get children too many requests response has a 5xx status code
func (o *GetChildrenTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get children too many requests response a status code equal to that given
func (o *GetChildrenTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get children too many requests response
func (o *GetChildrenTooManyRequests) Code() int {
	return 429
}

func (o *GetChildrenTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /mssp/entities/children/v1][%d] getChildrenTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetChildrenTooManyRequests) String() string {
	return fmt.Sprintf("[GET /mssp/entities/children/v1][%d] getChildrenTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetChildrenTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetChildrenTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
