// Code generated by go-swagger; DO NOT EDIT.

package mssp

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetChildrenV2Reader is a Reader for the GetChildrenV2 structure.
type GetChildrenV2Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetChildrenV2Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetChildrenV2OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 207:
		result := NewGetChildrenV2MultiStatus()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetChildrenV2BadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetChildrenV2Forbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetChildrenV2TooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /mssp/entities/children/GET/v2] getChildrenV2", response, response.Code())
	}
}

// NewGetChildrenV2OK creates a GetChildrenV2OK with default headers values
func NewGetChildrenV2OK() *GetChildrenV2OK {
	return &GetChildrenV2OK{}
}

/*
GetChildrenV2OK describes a response with status code 200, with default header values.

OK
*/
type GetChildrenV2OK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainChildrenResponseV1
}

// IsSuccess returns true when this get children v2 o k response has a 2xx status code
func (o *GetChildrenV2OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get children v2 o k response has a 3xx status code
func (o *GetChildrenV2OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get children v2 o k response has a 4xx status code
func (o *GetChildrenV2OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get children v2 o k response has a 5xx status code
func (o *GetChildrenV2OK) IsServerError() bool {
	return false
}

// IsCode returns true when this get children v2 o k response a status code equal to that given
func (o *GetChildrenV2OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get children v2 o k response
func (o *GetChildrenV2OK) Code() int {
	return 200
}

func (o *GetChildrenV2OK) Error() string {
	return fmt.Sprintf("[POST /mssp/entities/children/GET/v2][%d] getChildrenV2OK  %+v", 200, o.Payload)
}

func (o *GetChildrenV2OK) String() string {
	return fmt.Sprintf("[POST /mssp/entities/children/GET/v2][%d] getChildrenV2OK  %+v", 200, o.Payload)
}

func (o *GetChildrenV2OK) GetPayload() *models.DomainChildrenResponseV1 {
	return o.Payload
}

func (o *GetChildrenV2OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainChildrenResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetChildrenV2MultiStatus creates a GetChildrenV2MultiStatus with default headers values
func NewGetChildrenV2MultiStatus() *GetChildrenV2MultiStatus {
	return &GetChildrenV2MultiStatus{}
}

/*
GetChildrenV2MultiStatus describes a response with status code 207, with default header values.

Multi-Status
*/
type GetChildrenV2MultiStatus struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainChildrenResponseV1
}

// IsSuccess returns true when this get children v2 multi status response has a 2xx status code
func (o *GetChildrenV2MultiStatus) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get children v2 multi status response has a 3xx status code
func (o *GetChildrenV2MultiStatus) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get children v2 multi status response has a 4xx status code
func (o *GetChildrenV2MultiStatus) IsClientError() bool {
	return false
}

// IsServerError returns true when this get children v2 multi status response has a 5xx status code
func (o *GetChildrenV2MultiStatus) IsServerError() bool {
	return false
}

// IsCode returns true when this get children v2 multi status response a status code equal to that given
func (o *GetChildrenV2MultiStatus) IsCode(code int) bool {
	return code == 207
}

// Code gets the status code for the get children v2 multi status response
func (o *GetChildrenV2MultiStatus) Code() int {
	return 207
}

func (o *GetChildrenV2MultiStatus) Error() string {
	return fmt.Sprintf("[POST /mssp/entities/children/GET/v2][%d] getChildrenV2MultiStatus  %+v", 207, o.Payload)
}

func (o *GetChildrenV2MultiStatus) String() string {
	return fmt.Sprintf("[POST /mssp/entities/children/GET/v2][%d] getChildrenV2MultiStatus  %+v", 207, o.Payload)
}

func (o *GetChildrenV2MultiStatus) GetPayload() *models.DomainChildrenResponseV1 {
	return o.Payload
}

func (o *GetChildrenV2MultiStatus) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainChildrenResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetChildrenV2BadRequest creates a GetChildrenV2BadRequest with default headers values
func NewGetChildrenV2BadRequest() *GetChildrenV2BadRequest {
	return &GetChildrenV2BadRequest{}
}

/*
GetChildrenV2BadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetChildrenV2BadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecResponseFields
}

// IsSuccess returns true when this get children v2 bad request response has a 2xx status code
func (o *GetChildrenV2BadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get children v2 bad request response has a 3xx status code
func (o *GetChildrenV2BadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get children v2 bad request response has a 4xx status code
func (o *GetChildrenV2BadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get children v2 bad request response has a 5xx status code
func (o *GetChildrenV2BadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get children v2 bad request response a status code equal to that given
func (o *GetChildrenV2BadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get children v2 bad request response
func (o *GetChildrenV2BadRequest) Code() int {
	return 400
}

func (o *GetChildrenV2BadRequest) Error() string {
	return fmt.Sprintf("[POST /mssp/entities/children/GET/v2][%d] getChildrenV2BadRequest  %+v", 400, o.Payload)
}

func (o *GetChildrenV2BadRequest) String() string {
	return fmt.Sprintf("[POST /mssp/entities/children/GET/v2][%d] getChildrenV2BadRequest  %+v", 400, o.Payload)
}

func (o *GetChildrenV2BadRequest) GetPayload() *models.MsaspecResponseFields {
	return o.Payload
}

func (o *GetChildrenV2BadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetChildrenV2Forbidden creates a GetChildrenV2Forbidden with default headers values
func NewGetChildrenV2Forbidden() *GetChildrenV2Forbidden {
	return &GetChildrenV2Forbidden{}
}

/*
GetChildrenV2Forbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetChildrenV2Forbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecResponseFields
}

// IsSuccess returns true when this get children v2 forbidden response has a 2xx status code
func (o *GetChildrenV2Forbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get children v2 forbidden response has a 3xx status code
func (o *GetChildrenV2Forbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get children v2 forbidden response has a 4xx status code
func (o *GetChildrenV2Forbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get children v2 forbidden response has a 5xx status code
func (o *GetChildrenV2Forbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get children v2 forbidden response a status code equal to that given
func (o *GetChildrenV2Forbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get children v2 forbidden response
func (o *GetChildrenV2Forbidden) Code() int {
	return 403
}

func (o *GetChildrenV2Forbidden) Error() string {
	return fmt.Sprintf("[POST /mssp/entities/children/GET/v2][%d] getChildrenV2Forbidden  %+v", 403, o.Payload)
}

func (o *GetChildrenV2Forbidden) String() string {
	return fmt.Sprintf("[POST /mssp/entities/children/GET/v2][%d] getChildrenV2Forbidden  %+v", 403, o.Payload)
}

func (o *GetChildrenV2Forbidden) GetPayload() *models.MsaspecResponseFields {
	return o.Payload
}

func (o *GetChildrenV2Forbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetChildrenV2TooManyRequests creates a GetChildrenV2TooManyRequests with default headers values
func NewGetChildrenV2TooManyRequests() *GetChildrenV2TooManyRequests {
	return &GetChildrenV2TooManyRequests{}
}

/*
GetChildrenV2TooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetChildrenV2TooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get children v2 too many requests response has a 2xx status code
func (o *GetChildrenV2TooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get children v2 too many requests response has a 3xx status code
func (o *GetChildrenV2TooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get children v2 too many requests response has a 4xx status code
func (o *GetChildrenV2TooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get children v2 too many requests response has a 5xx status code
func (o *GetChildrenV2TooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get children v2 too many requests response a status code equal to that given
func (o *GetChildrenV2TooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get children v2 too many requests response
func (o *GetChildrenV2TooManyRequests) Code() int {
	return 429
}

func (o *GetChildrenV2TooManyRequests) Error() string {
	return fmt.Sprintf("[POST /mssp/entities/children/GET/v2][%d] getChildrenV2TooManyRequests  %+v", 429, o.Payload)
}

func (o *GetChildrenV2TooManyRequests) String() string {
	return fmt.Sprintf("[POST /mssp/entities/children/GET/v2][%d] getChildrenV2TooManyRequests  %+v", 429, o.Payload)
}

func (o *GetChildrenV2TooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetChildrenV2TooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
