// Code generated by go-swagger; DO NOT EDIT.

package mssp

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetRolesByIDParams creates a new GetRolesByIDParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetRolesByIDParams() *GetRolesByIDParams {
	return &GetRolesByIDParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetRolesByIDParamsWithTimeout creates a new GetRolesByIDParams object
// with the ability to set a timeout on a request.
func NewGetRolesByIDParamsWithTimeout(timeout time.Duration) *GetRolesByIDParams {
	return &GetRolesByIDParams{
		timeout: timeout,
	}
}

// NewGetRolesByIDParamsWithContext creates a new GetRolesByIDParams object
// with the ability to set a context for a request.
func NewGetRolesByIDParamsWithContext(ctx context.Context) *GetRolesByIDParams {
	return &GetRolesByIDParams{
		Context: ctx,
	}
}

// NewGetRolesByIDParamsWithHTTPClient creates a new GetRolesByIDParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetRolesByIDParamsWithHTTPClient(client *http.Client) *GetRolesByIDParams {
	return &GetRolesByIDParams{
		HTTPClient: client,
	}
}

/*
GetRolesByIDParams contains all the parameters to send to the API endpoint

	for the get roles by ID operation.

	Typically these are written to a http.Request.
*/
type GetRolesByIDParams struct {

	/* Ids.

	   Link ID is a string consisting of multiple components, but should be treated as opaque.
	*/
	Ids []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get roles by ID params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetRolesByIDParams) WithDefaults() *GetRolesByIDParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get roles by ID params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetRolesByIDParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get roles by ID params
func (o *GetRolesByIDParams) WithTimeout(timeout time.Duration) *GetRolesByIDParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get roles by ID params
func (o *GetRolesByIDParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get roles by ID params
func (o *GetRolesByIDParams) WithContext(ctx context.Context) *GetRolesByIDParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get roles by ID params
func (o *GetRolesByIDParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get roles by ID params
func (o *GetRolesByIDParams) WithHTTPClient(client *http.Client) *GetRolesByIDParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get roles by ID params
func (o *GetRolesByIDParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the get roles by ID params
func (o *GetRolesByIDParams) WithIds(ids []string) *GetRolesByIDParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the get roles by ID params
func (o *GetRolesByIDParams) SetIds(ids []string) {
	o.Ids = ids
}

// WriteToRequest writes these params to a swagger request
func (o *GetRolesByIDParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGetRolesByID binds the parameter ids
func (o *GetRolesByIDParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}
