// Code generated by go-swagger; DO NOT EDIT.

package mssp

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetUserGroupMembersByIDReader is a Reader for the GetUserGroupMembersByID structure.
type GetUserGroupMembersByIDReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetUserGroupMembersByIDReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetUserGroupMembersByIDOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 207:
		result := NewGetUserGroupMembersByIDMultiStatus()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetUserGroupMembersByIDBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetUserGroupMembersByIDForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetUserGroupMembersByIDTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /mssp/entities/user-group-members/v1] getUserGroupMembersByID", response, response.Code())
	}
}

// NewGetUserGroupMembersByIDOK creates a GetUserGroupMembersByIDOK with default headers values
func NewGetUserGroupMembersByIDOK() *GetUserGroupMembersByIDOK {
	return &GetUserGroupMembersByIDOK{}
}

/*
GetUserGroupMembersByIDOK describes a response with status code 200, with default header values.

OK
*/
type GetUserGroupMembersByIDOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainUserGroupMembersResponseV1
}

// IsSuccess returns true when this get user group members by Id o k response has a 2xx status code
func (o *GetUserGroupMembersByIDOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get user group members by Id o k response has a 3xx status code
func (o *GetUserGroupMembersByIDOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get user group members by Id o k response has a 4xx status code
func (o *GetUserGroupMembersByIDOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get user group members by Id o k response has a 5xx status code
func (o *GetUserGroupMembersByIDOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get user group members by Id o k response a status code equal to that given
func (o *GetUserGroupMembersByIDOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get user group members by Id o k response
func (o *GetUserGroupMembersByIDOK) Code() int {
	return 200
}

func (o *GetUserGroupMembersByIDOK) Error() string {
	return fmt.Sprintf("[GET /mssp/entities/user-group-members/v1][%d] getUserGroupMembersByIdOK  %+v", 200, o.Payload)
}

func (o *GetUserGroupMembersByIDOK) String() string {
	return fmt.Sprintf("[GET /mssp/entities/user-group-members/v1][%d] getUserGroupMembersByIdOK  %+v", 200, o.Payload)
}

func (o *GetUserGroupMembersByIDOK) GetPayload() *models.DomainUserGroupMembersResponseV1 {
	return o.Payload
}

func (o *GetUserGroupMembersByIDOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainUserGroupMembersResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetUserGroupMembersByIDMultiStatus creates a GetUserGroupMembersByIDMultiStatus with default headers values
func NewGetUserGroupMembersByIDMultiStatus() *GetUserGroupMembersByIDMultiStatus {
	return &GetUserGroupMembersByIDMultiStatus{}
}

/*
GetUserGroupMembersByIDMultiStatus describes a response with status code 207, with default header values.

Multi-Status
*/
type GetUserGroupMembersByIDMultiStatus struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainUserGroupMembersResponseV1
}

// IsSuccess returns true when this get user group members by Id multi status response has a 2xx status code
func (o *GetUserGroupMembersByIDMultiStatus) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get user group members by Id multi status response has a 3xx status code
func (o *GetUserGroupMembersByIDMultiStatus) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get user group members by Id multi status response has a 4xx status code
func (o *GetUserGroupMembersByIDMultiStatus) IsClientError() bool {
	return false
}

// IsServerError returns true when this get user group members by Id multi status response has a 5xx status code
func (o *GetUserGroupMembersByIDMultiStatus) IsServerError() bool {
	return false
}

// IsCode returns true when this get user group members by Id multi status response a status code equal to that given
func (o *GetUserGroupMembersByIDMultiStatus) IsCode(code int) bool {
	return code == 207
}

// Code gets the status code for the get user group members by Id multi status response
func (o *GetUserGroupMembersByIDMultiStatus) Code() int {
	return 207
}

func (o *GetUserGroupMembersByIDMultiStatus) Error() string {
	return fmt.Sprintf("[GET /mssp/entities/user-group-members/v1][%d] getUserGroupMembersByIdMultiStatus  %+v", 207, o.Payload)
}

func (o *GetUserGroupMembersByIDMultiStatus) String() string {
	return fmt.Sprintf("[GET /mssp/entities/user-group-members/v1][%d] getUserGroupMembersByIdMultiStatus  %+v", 207, o.Payload)
}

func (o *GetUserGroupMembersByIDMultiStatus) GetPayload() *models.DomainUserGroupMembersResponseV1 {
	return o.Payload
}

func (o *GetUserGroupMembersByIDMultiStatus) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainUserGroupMembersResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetUserGroupMembersByIDBadRequest creates a GetUserGroupMembersByIDBadRequest with default headers values
func NewGetUserGroupMembersByIDBadRequest() *GetUserGroupMembersByIDBadRequest {
	return &GetUserGroupMembersByIDBadRequest{}
}

/*
GetUserGroupMembersByIDBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetUserGroupMembersByIDBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this get user group members by Id bad request response has a 2xx status code
func (o *GetUserGroupMembersByIDBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get user group members by Id bad request response has a 3xx status code
func (o *GetUserGroupMembersByIDBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get user group members by Id bad request response has a 4xx status code
func (o *GetUserGroupMembersByIDBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get user group members by Id bad request response has a 5xx status code
func (o *GetUserGroupMembersByIDBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get user group members by Id bad request response a status code equal to that given
func (o *GetUserGroupMembersByIDBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get user group members by Id bad request response
func (o *GetUserGroupMembersByIDBadRequest) Code() int {
	return 400
}

func (o *GetUserGroupMembersByIDBadRequest) Error() string {
	return fmt.Sprintf("[GET /mssp/entities/user-group-members/v1][%d] getUserGroupMembersByIdBadRequest  %+v", 400, o.Payload)
}

func (o *GetUserGroupMembersByIDBadRequest) String() string {
	return fmt.Sprintf("[GET /mssp/entities/user-group-members/v1][%d] getUserGroupMembersByIdBadRequest  %+v", 400, o.Payload)
}

func (o *GetUserGroupMembersByIDBadRequest) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *GetUserGroupMembersByIDBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetUserGroupMembersByIDForbidden creates a GetUserGroupMembersByIDForbidden with default headers values
func NewGetUserGroupMembersByIDForbidden() *GetUserGroupMembersByIDForbidden {
	return &GetUserGroupMembersByIDForbidden{}
}

/*
GetUserGroupMembersByIDForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetUserGroupMembersByIDForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this get user group members by Id forbidden response has a 2xx status code
func (o *GetUserGroupMembersByIDForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get user group members by Id forbidden response has a 3xx status code
func (o *GetUserGroupMembersByIDForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get user group members by Id forbidden response has a 4xx status code
func (o *GetUserGroupMembersByIDForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get user group members by Id forbidden response has a 5xx status code
func (o *GetUserGroupMembersByIDForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get user group members by Id forbidden response a status code equal to that given
func (o *GetUserGroupMembersByIDForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get user group members by Id forbidden response
func (o *GetUserGroupMembersByIDForbidden) Code() int {
	return 403
}

func (o *GetUserGroupMembersByIDForbidden) Error() string {
	return fmt.Sprintf("[GET /mssp/entities/user-group-members/v1][%d] getUserGroupMembersByIdForbidden  %+v", 403, o.Payload)
}

func (o *GetUserGroupMembersByIDForbidden) String() string {
	return fmt.Sprintf("[GET /mssp/entities/user-group-members/v1][%d] getUserGroupMembersByIdForbidden  %+v", 403, o.Payload)
}

func (o *GetUserGroupMembersByIDForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *GetUserGroupMembersByIDForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetUserGroupMembersByIDTooManyRequests creates a GetUserGroupMembersByIDTooManyRequests with default headers values
func NewGetUserGroupMembersByIDTooManyRequests() *GetUserGroupMembersByIDTooManyRequests {
	return &GetUserGroupMembersByIDTooManyRequests{}
}

/*
GetUserGroupMembersByIDTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetUserGroupMembersByIDTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get user group members by Id too many requests response has a 2xx status code
func (o *GetUserGroupMembersByIDTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get user group members by Id too many requests response has a 3xx status code
func (o *GetUserGroupMembersByIDTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get user group members by Id too many requests response has a 4xx status code
func (o *GetUserGroupMembersByIDTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get user group members by Id too many requests response has a 5xx status code
func (o *GetUserGroupMembersByIDTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get user group members by Id too many requests response a status code equal to that given
func (o *GetUserGroupMembersByIDTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get user group members by Id too many requests response
func (o *GetUserGroupMembersByIDTooManyRequests) Code() int {
	return 429
}

func (o *GetUserGroupMembersByIDTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /mssp/entities/user-group-members/v1][%d] getUserGroupMembersByIdTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetUserGroupMembersByIDTooManyRequests) String() string {
	return fmt.Sprintf("[GET /mssp/entities/user-group-members/v1][%d] getUserGroupMembersByIdTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetUserGroupMembersByIDTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetUserGroupMembersByIDTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
