// Code generated by go-swagger; DO NOT EDIT.

package mssp

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetUserGroupsByIDParams creates a new GetUserGroupsByIDParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetUserGroupsByIDParams() *GetUserGroupsByIDParams {
	return &GetUserGroupsByIDParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetUserGroupsByIDParamsWithTimeout creates a new GetUserGroupsByIDParams object
// with the ability to set a timeout on a request.
func NewGetUserGroupsByIDParamsWithTimeout(timeout time.Duration) *GetUserGroupsByIDParams {
	return &GetUserGroupsByIDParams{
		timeout: timeout,
	}
}

// NewGetUserGroupsByIDParamsWithContext creates a new GetUserGroupsByIDParams object
// with the ability to set a context for a request.
func NewGetUserGroupsByIDParamsWithContext(ctx context.Context) *GetUserGroupsByIDParams {
	return &GetUserGroupsByIDParams{
		Context: ctx,
	}
}

// NewGetUserGroupsByIDParamsWithHTTPClient creates a new GetUserGroupsByIDParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetUserGroupsByIDParamsWithHTTPClient(client *http.Client) *GetUserGroupsByIDParams {
	return &GetUserGroupsByIDParams{
		HTTPClient: client,
	}
}

/*
GetUserGroupsByIDParams contains all the parameters to send to the API endpoint

	for the get user groups by ID operation.

	Typically these are written to a http.Request.
*/
type GetUserGroupsByIDParams struct {

	/* UserGroupIds.

	   User Group IDs to search for
	*/
	UserGroupIds []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get user groups by ID params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetUserGroupsByIDParams) WithDefaults() *GetUserGroupsByIDParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get user groups by ID params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetUserGroupsByIDParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get user groups by ID params
func (o *GetUserGroupsByIDParams) WithTimeout(timeout time.Duration) *GetUserGroupsByIDParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get user groups by ID params
func (o *GetUserGroupsByIDParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get user groups by ID params
func (o *GetUserGroupsByIDParams) WithContext(ctx context.Context) *GetUserGroupsByIDParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get user groups by ID params
func (o *GetUserGroupsByIDParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get user groups by ID params
func (o *GetUserGroupsByIDParams) WithHTTPClient(client *http.Client) *GetUserGroupsByIDParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get user groups by ID params
func (o *GetUserGroupsByIDParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithUserGroupIds adds the userGroupIds to the get user groups by ID params
func (o *GetUserGroupsByIDParams) WithUserGroupIds(userGroupIds []string) *GetUserGroupsByIDParams {
	o.SetUserGroupIds(userGroupIds)
	return o
}

// SetUserGroupIds adds the userGroupIds to the get user groups by ID params
func (o *GetUserGroupsByIDParams) SetUserGroupIds(userGroupIds []string) {
	o.UserGroupIds = userGroupIds
}

// WriteToRequest writes these params to a swagger request
func (o *GetUserGroupsByIDParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.UserGroupIds != nil {

		// binding items for user_group_ids
		joinedUserGroupIds := o.bindParamUserGroupIds(reg)

		// query array param user_group_ids
		if err := r.SetQueryParam("user_group_ids", joinedUserGroupIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGetUserGroupsByID binds the parameter user_group_ids
func (o *GetUserGroupsByIDParams) bindParamUserGroupIds(formats strfmt.Registry) []string {
	userGroupIdsIR := o.UserGroupIds

	var userGroupIdsIC []string
	for _, userGroupIdsIIR := range userGroupIdsIR { // explode []string

		userGroupIdsIIV := userGroupIdsIIR // string as string
		userGroupIdsIC = append(userGroupIdsIC, userGroupIdsIIV)
	}

	// items.CollectionFormat: "multi"
	userGroupIdsIS := swag.JoinByFormat(userGroupIdsIC, "multi")

	return userGroupIdsIS
}
